/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.erp.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.qing.util.StringUtils;
import com.kingdee.eas.custom.erp.util.HttpsReqUtil;
import com.kingdee.eas.custom.erp.util.SynPublicUtils;
import com.kingdee.eas.custom.erp.util.SynSalaryFromErpUtils;
import com.kingdee.eas.util.ToolUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynPersonToErpUtils {
    private static Logger log = LoggerFactory.getLogger(SynPersonToErpUtils.class);
    private static String ierp = "https://sites.gtiit.edu.cn/kderpdev/ierp";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static String getGt15AdminOrgBetaUrl() {
        Properties config = SynPublicUtils.getConfig();
        ierp = (String)config.get("ierp");
        return new StringBuffer().append(ierp).append("/kapi/v2/gt15/base/bos_user/gt15_user_add").toString();
    }

    public static String getGt15UserDisableUrl() {
        Properties config = SynPublicUtils.getConfig();
        ierp = (String)config.get("ierp");
        return new StringBuffer().append(ierp).append("/kapi/v2/gt15/base/bos_user/gt15_user_disable").toString();
    }

    public static String getGt15UserEnableUrl() {
        Properties config = SynPublicUtils.getConfig();
        ierp = (String)config.get("ierp");
        return new StringBuffer().append(ierp).append("/kapi/v2/gt15/base/bos_user/gt15_user_enable").toString();
    }

    public static void gt15_user_add(Context ctx, String accessToken, String startDate, String endDate, String pNumber) throws Exception {
        String gt15UserAddUrl = SynPersonToErpUtils.getGt15AdminOrgBetaUrl();
        log.info("SynPersonToErpUtils.gt15_user_add.gt15UserAddUrl:" + gt15UserAddUrl);
        log.info("SynPersonToErpUtils.gt15_user_add.accessToken:" + accessToken);
        log.info("SynPersonToErpUtils.gt15_user_add.startDate:" + startDate);
        log.info("SynPersonToErpUtils.gt15_user_add.endDate:" + endDate);
        SynPersonToErpUtils.getUserAddEntryAndPush(ctx, gt15UserAddUrl, accessToken, startDate, endDate, pNumber);
    }

    public static void getUserAddEntryAndPush(Context ctx, String gt15UserAddUrl, String accessToken, String startDateStr, String endDateStr, String pNumber) throws Exception {
        String lastDateZeroTimeStr = "";
        String noeTimeStr = "";
        if (StringUtils.isEmpty((CharSequence)startDateStr) || StringUtils.isEmpty((CharSequence)endDateStr)) {
            lastDateZeroTimeStr = SynPublicUtils.getLastUpdateSynTableTimeStrByEvenName(ctx, "SynPerson");
            if (StringUtils.isEmpty((CharSequence)lastDateZeroTimeStr)) {
                lastDateZeroTimeStr = SynPublicUtils.getLastDateZeroTime();
            }
            SynPublicUtils.updateSynTimeTable(ctx, "SynPerson");
            noeTimeStr = SynPublicUtils.getNowTimeStr();
        } else {
            lastDateZeroTimeStr = startDateStr;
            noeTimeStr = endDateStr;
        }
        log.info("SynPersonToErpUtils.lastDateZeroTimeStr:" + lastDateZeroTimeStr);
        log.info("SynPersonToErpUtils.noeTimeStr:" + noeTimeStr);
        String sql = "/*dialect*/select person.fid as personId,person.fnumber as number,person.fname_l1 as name_l1 ,person.fname_l2 as name_l2,person.fname_l3 as name_l3,person.fglobalroaming as globalroaming,person.fncell as phone,person.femail as email,person.fidcardno as idcard,person.fgender as gender,fullOrPart.fnumber as gt15_fullorpart,\n  employeeClassify.fnumber as gt15_personneltype_number,employeeClassify.fname_l1 as gt15_personneltype_name, workerCategory.fnumber as gt15_workercategory_number, workerCategory.fname_l1 as gt15_workercategory_name,\n  empLaborRelation2.feffdt as  gt15_terminatedon,credentialsType.fnumber as gt15_idtype_number,credentialsType.fname_l1 as gt15_idtype_name,person.fpassportNO as gt15_idno,nationality.fnumber as gt15_placeoforigin_number,\n  nationality.fname_l1 as gt15_placeoforigin_name,person.FHireDate as gt15_joiningdate,person.CFLocalName as gt15_localname ,person.CFUserName as username,temp.dpt_number as dpt_number,temp.dpt_name as dpt_name,\n  temp.position_l1 as position_l1,temp.position_l2 as position_l2,temp.position_l3 as position_l3,temp.isincharge as isincharge,temp.ispartjob as ispartjob,temp.superior_number,temp.superior_name,temp.post_number as post_number,temp.post_name as post_name \n  from t_bd_person person \n  left join CT_MP_Fullorpart fullOrPart on fullOrPart.fid =  person.CFFtorptID\n  left join  T_HR_EmployeeClassify employeeClassify on employeeClassify.fid = person.CFPersontypeID\n  left join (\n select  c.fnumber,c.fname_l1,b.fpersonid as personId, c.flastupdatetime as cflastupdatetime from t_BD_person a left join T_HR_PersonOtherInfo b on a.fid=b.fpersonid left join T_HR_CredentialsType c on b.FCredentialsTypeID=c.fid \n ) credentialsType on credentialsType.personId = person.fid \n  left join  T_BD_Nationality nationality on nationality.fid = person.FNationalityID\n  left join (\n  select x.fid as personId,c.fnumber as dpt_number,c.fname_l1 as dpt_name,b.fnumber as post_number,b.fname_l1 as post_name,b.fisrespposition as isincharge,d.fnumber as ispartjob,e.fnumber as superior_number,e.fname_l1 as superior_name,\n f.fnumber as  position_number,f.fname_l1 as position_l1,f.fname_l2 as position_l2,f.fname_l3 as position_l3,a.CFWorkercategoryID as workercategoryId,\n a.flastupdatetime as aflastupdatetime,b.flastupdatetime as bflastupdatetime,c.flastupdatetime as cflastupdatetime,d.flastupdatetime as dflastupdatetime,f.flastupdatetime as fflastupdatetime\n from t_BD_person x \n  left join   T_HR_EmpOrgRelation a  on x.fid=a.fpersonid  AND TO_CHAR(a.FLEFFDT,'YYYY-MM-DD')='2199-12-31' AND a.FASSIGNTYPE=1 \n  left join t_org_position b on a.fpositionid=b.fid\n  left join t_org_baseunit c on b.fadminorgunitid=c.fid\n left join CT_MP_Fullorpart d on d.fid = a.CFFtorptID\n  left join  T_BD_Person e on e.fid = a.CFLineManagerNameI\n  left join T_ORG_Job f on f.fid = b.FJobID\n  ) temp on temp.personId = person.fid \n left join T_HR_EmpLaborRelation empLaborRelation on empLaborRelation.fpersonid = person.fid and  TO_CHAR(empLaborRelation.FLEFFDT,'YYYY-MM-DD')='2199-12-31' \n  left join  T_HR_EmpOrgRelation empOrgRelation  on person.fid=empOrgRelation.fpersonid  AND TO_CHAR(empOrgRelation.FLEFFDT,'YYYY-MM-DD')='2199-12-31' AND empOrgRelation.FASSIGNTYPE=1  \n  left join t_org_admin admin2 on admin2.fid = empOrgRelation.fadminorgid \n  left join  CT_MP_WorkerCategory workerCategory on workerCategory.fid = temp.workercategoryId \n  left join CT_MP_Fullorpart fullOrPart2 on fullOrPart2.fid = empOrgRelation.CFFtorptID \n  left join T_HR_EmpLaborRelation empLaborRelation2 on empLaborRelation2.fpersonid = person.fid and  \n  empLaborRelation2.flaborrelationstateid in ('00000000-0000-0000-0000-000000000007A29E85B3','00000000-0000-0000-0000-000000000006A29E85B3','FTCmJT3SSRi1twufIaRb56KehbM=')\n";
        if (!StringUtils.isEmpty((CharSequence)pNumber)) {
            String[] split = pNumber.split(",");
            List<String> pNumberList = Arrays.asList(split);
            sql = String.valueOf(sql) + " where person.fnumber in ( " + ToolUtils.aryToStr(pNumberList, (boolean)true) + " ) ";
        } else {
            sql = String.valueOf(sql) + "  where (  (person.flastupdatetime >  {ts '" + lastDateZeroTimeStr + "'} and  person.flastupdatetime <=  {ts '" + noeTimeStr + "'} )\n" + "  or (credentialsType.cflastupdatetime >  {ts '" + lastDateZeroTimeStr + "'} and  credentialsType.cflastupdatetime <=  {ts '" + noeTimeStr + "'})\n" + "  or (temp.aflastupdatetime > {ts '" + lastDateZeroTimeStr + "'} and  temp.aflastupdatetime <=  {ts '" + noeTimeStr + "'} )\n" + "   or (empLaborRelation.flastupdatetime > {ts '" + lastDateZeroTimeStr + "'} and  empLaborRelation.flastupdatetime <=  {ts '" + noeTimeStr + "'})\n" + "   or (empOrgRelation.flastupdatetime> {ts '" + lastDateZeroTimeStr + "'} and  empOrgRelation.flastupdatetime <=  {ts '" + noeTimeStr + "'})\n" + "   or (workerCategory.flastupdatetime> {ts '" + lastDateZeroTimeStr + "'} and  workerCategory.flastupdatetime <=  {ts '" + noeTimeStr + "'})\n" + "   or (empLaborRelation2.flastupdatetime> {ts '" + lastDateZeroTimeStr + "'} and  empLaborRelation2.flastupdatetime <=  {ts '" + noeTimeStr + "'}) ) ";
        }
        log.info("SynPersonToErpUtils.getUserAddEntry.sql:" + sql);
        String number = "";
        String name_l1 = "";
        String name_l2 = "";
        String name_l3 = "";
        String globalroaming = "";
        String phone = "";
        String email = "";
        String idcard = "";
        String gender = "";
        String gt15_fullorpart = "";
        String gt15_personneltype_number = "";
        String gt15_personneltype_name = "";
        String gt15_workercategory_number = "";
        String gt15_workercategory_name = "";
        String gt15_idtype_number = "";
        String gt15_idtype_name = "";
        String gt15_idno = "";
        String gt15_placeoforigin_number = "";
        String gt15_placeoforigin_name = "";
        String gt15_localname = "";
        String username = "";
        String dpt_number = "";
        String dpt_name = "";
        String position_l1 = "";
        String position_l2 = "";
        String position_l3 = "";
        String isincharge = "";
        String ispartjobStr = "";
        boolean ispartjob = false;
        String superior_number = "";
        String superior_name = "";
        String post_number = "";
        String post_name = "";
        String paramJOStr = "";
        String personId = "";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                number = executeQuery.getString("number");
                name_l1 = executeQuery.getString("name_l1");
                name_l2 = executeQuery.getString("name_l2");
                name_l3 = executeQuery.getString("name_l3");
                globalroaming = executeQuery.getString("globalroaming");
                phone = executeQuery.getString("phone");
                email = executeQuery.getString("email");
                idcard = executeQuery.getString("idcard");
                gender = executeQuery.getString("gender");
                gt15_fullorpart = executeQuery.getString("gt15_fullorpart");
                gt15_personneltype_number = executeQuery.getString("gt15_personneltype_number");
                gt15_personneltype_name = executeQuery.getString("gt15_personneltype_name");
                gt15_workercategory_number = executeQuery.getString("gt15_workercategory_number");
                gt15_workercategory_name = executeQuery.getString("gt15_workercategory_name");
                Date gt15_terminatedonDate = executeQuery.getDate("gt15_terminatedon");
                String gt15_terminatedon = null;
                if (gt15_terminatedonDate != null) {
                    gt15_terminatedon = sdf.format(gt15_terminatedonDate);
                }
                gt15_idtype_number = executeQuery.getString("gt15_idtype_number");
                gt15_idtype_name = executeQuery.getString("gt15_idtype_name");
                gt15_idno = executeQuery.getString("gt15_idno");
                gt15_placeoforigin_number = executeQuery.getString("gt15_placeoforigin_number");
                gt15_placeoforigin_name = executeQuery.getString("gt15_placeoforigin_name");
                Date gt15_joiningdateDate = executeQuery.getDate("gt15_joiningdate");
                String gt15_joiningdate = null;
                if (gt15_joiningdateDate != null) {
                    gt15_joiningdate = sdf.format(gt15_joiningdateDate);
                }
                gt15_localname = executeQuery.getString("gt15_localname");
                username = executeQuery.getString("username");
                personId = executeQuery.getString("personId");
                JSONArray entryentitys = SynPersonToErpUtils.getEntryentitysByPersonId(ctx, personId);
                JSONObject data = new JSONObject();
                data.put("number", (Object)number);
                JSONObject name = new JSONObject();
                name.put("en_US", (Object)name_l1);
                name.put("zh_CN", (Object)name_l2);
                name.put("zh_TW", (Object)name_l3);
                data.put("name", (Object)name);
                if (!StringUtils.isEmpty((CharSequence)globalroaming) && !StringUtils.isEmpty((CharSequence)phone)) {
                    phone = String.valueOf(globalroaming) + "-" + phone;
                }
                data.put("phone", (Object)phone);
                data.put("email", (Object)email);
                data.put("idcard", (Object)idcard);
                data.put("gender", (Object)gender);
                data.put("gt15_fullorpart", (Object)gt15_fullorpart);
                data.put("gt15_personneltype_number", (Object)gt15_personneltype_number);
                data.put("gt15_personneltype_name", (Object)gt15_personneltype_name);
                data.put("gt15_workercategory_number", (Object)gt15_workercategory_number);
                data.put("gt15_workercategory_name", (Object)gt15_workercategory_name);
                data.put("gt15_terminatedon", (Object)gt15_terminatedon);
                data.put("gt15_idtype_number", (Object)gt15_idtype_number);
                data.put("gt15_idtype_name", (Object)gt15_idtype_name);
                data.put("gt15_idno", (Object)gt15_idno);
                data.put("gt15_placeoforigin_number", (Object)gt15_placeoforigin_number);
                data.put("gt15_placeoforigin_name", (Object)gt15_placeoforigin_name);
                data.put("gt15_joiningdate", (Object)gt15_joiningdate);
                data.put("gt15_localname", (Object)gt15_localname);
                data.put("username", (Object)username);
                data.put("entryentity", (Object)entryentitys);
                JSONArray datas = new JSONArray();
                datas.add((Object)data);
                JSONObject paramJO = new JSONObject();
                paramJO.put("data", (Object)datas);
                paramJOStr = paramJO.toString();
                log.info("SynPersonToErpUtils.getUserAddEntry.paramJOStr:" + paramJOStr);
                String responseMsg = HttpsReqUtil.postByHttps(gt15UserAddUrl, paramJOStr, accessToken);
                log.info("SynPersonToErpUtils.getUserAddEntry.responseMsg:" + responseMsg);
            }
        }
    }

    private static JSONArray getEntryentitysByPersonId(Context ctx, String personId) throws BOSException, SQLException {
        String sql = "select x.fid as personId,c.fnumber as dpt_number,c.fname_l1 as dpt_name,b.fnumber as post_number,b.fname_l1 as post_name,b.fisrespposition as isincharge, a.fassigntype as ispartjob,e.fnumber as superior_number,e.fname_l1 as superior_name,\n f.fnumber as  position_number,f.fname_l1 as position_l1,f.fname_l2 as position_l2,f.fname_l3 as position_l3,a.CFWorkercategoryID as workercategoryId,\n a.flastupdatetime as aflastupdatetime,b.flastupdatetime as bflastupdatetime,c.flastupdatetime as cflastupdatetime,d.flastupdatetime as dflastupdatetime,f.flastupdatetime as fflastupdatetime \n from T_HR_EmpOrgRelation a  left join t_BD_person x  on x.fid=a.fpersonid    left join t_org_position b on a.fpositionid=b.fid   left join t_org_baseunit c on b.fadminorgunitid=c.fid  left join CT_MP_Fullorpart d on d.fid = a.CFFtorptID   left join  T_BD_Person e on e.fid = a.CFLineManagerNameI   left join T_ORG_Job f on f.fid = b.FJobID   where a.fpersonid = '" + personId + "'  AND TO_CHAR(a.FLEFFDT,'YYYY-MM-DD')='2199-12-31' ";
        log.info("SynPersonToErpUtils.getEntryentitysByPersonId.sql:" + sql);
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        String dpt_number = "";
        String dpt_name = "";
        String position_l1 = "";
        String position_l2 = "";
        String position_l3 = "";
        String isincharge = "";
        int ispartjob = 0;
        String superior_number = "";
        String superior_name = "";
        String post_number = "";
        String post_name = "";
        JSONArray entryentitys = new JSONArray();
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                dpt_number = executeQuery.getString("dpt_number");
                dpt_name = executeQuery.getString("dpt_name");
                position_l1 = executeQuery.getString("position_l1");
                position_l2 = executeQuery.getString("position_l2");
                position_l3 = executeQuery.getString("position_l3");
                isincharge = executeQuery.getString("isincharge");
                ispartjob = executeQuery.getInt("ispartjob");
                superior_number = executeQuery.getString("superior_number");
                superior_name = executeQuery.getString("superior_name");
                post_number = executeQuery.getString("post_number");
                post_name = executeQuery.getString("post_name");
                JSONObject entryentity = new JSONObject();
                entryentity.put("dpt_number", (Object)dpt_number);
                entryentity.put("dpt_name", (Object)dpt_name);
                JSONObject position = new JSONObject();
                position.put("en_US", (Object)position_l1);
                position.put("zh_CN", (Object)position_l2);
                position.put("zh_TW", (Object)position_l3);
                entryentity.put("position", (Object)position);
                entryentity.put("isincharge", (Object)isincharge);
                if (ispartjob == 0) {
                    entryentity.put("ispartjob", (Object)true);
                } else {
                    entryentity.put("ispartjob", (Object)false);
                }
                entryentity.put("superior_number", (Object)superior_number);
                entryentity.put("superior_name", (Object)superior_name);
                entryentity.put("post_number", (Object)post_number);
                entryentity.put("post_name", (Object)post_name);
                entryentitys.add((Object)entryentity);
            }
        }
        return entryentitys;
    }

    public static void synPersonToErp(Context ctx, String startDate, String endDate, String pNumber) throws Exception {
        String appToken = SynSalaryFromErpUtils.getAppToken(ctx);
        log.info("\u83b7\u53d6synPersonToErp.appToken\uff1a" + appToken);
        String accessToken = SynSalaryFromErpUtils.getAccessToken(appToken);
        log.info("\u83b7\u53d6synPersonToErp.accessToken\u72b6\u6001\u4e3a\uff1a" + accessToken);
        SynPersonToErpUtils.gt15_user_add(ctx, accessToken, startDate, endDate, pNumber);
    }

    private static List<String> getPersonNumbersEnableEntry(Context ctx, String startDateStr, String endDateStr) throws BOSException, SQLException {
        String lastDateZeroTimeStr = "";
        String noeTimeStr = "";
        if (StringUtils.isEmpty((CharSequence)startDateStr) || StringUtils.isEmpty((CharSequence)endDateStr)) {
            lastDateZeroTimeStr = SynPublicUtils.getLastUpdateSynTableTimeStrByEvenName(ctx, "synPersonEnableToErp");
            if (StringUtils.isEmpty((CharSequence)lastDateZeroTimeStr)) {
                lastDateZeroTimeStr = SynPublicUtils.getLastDateZeroTime();
            }
            SynPublicUtils.updateSynTimeTable(ctx, "synPersonEnableToErp");
            noeTimeStr = SynPublicUtils.getNowTimeStr();
        } else {
            lastDateZeroTimeStr = startDateStr;
            noeTimeStr = endDateStr;
        }
        String sql = "select person.fnumber as number, user2.fforbidden ,user2.fcreatetime as createtime ,user2.flastupdatetime as lastupdatetime from  t_pm_user user2\n left join t_bd_person person on person.fid = user2.fpersonid\n left join  T_HR_EmpOrgRelation empOrgRelation  on person.fid=empOrgRelation.fpersonid  AND TO_CHAR(empOrgRelation.FLEFFDT,'YYYY-MM-DD')='2199-12-31' AND empOrgRelation.FASSIGNTYPE=1   right join t_org_admin admin on admin.fid = empOrgRelation.fadminorgid  where user2.fforbidden = 0  and  ((user2.flastupdatetime> {ts '" + lastDateZeroTimeStr + "'} and  user2.flastupdatetime <=  {ts '" + noeTimeStr + "'})) ";
        log.info("getPersonNumbersEnableEntry.sql" + sql);
        String number = "";
        Date createtime = null;
        Date lastupdatetime = null;
        String createTimeSdf = "";
        String lastupdateTimeSdf = "";
        ArrayList<String> listNumbers = new ArrayList<String>();
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                number = executeQuery.getString("number");
                createtime = executeQuery.getDate("createtime");
                lastupdatetime = executeQuery.getDate("lastupdatetime");
                createTimeSdf = sdf.format(createtime);
                lastupdateTimeSdf = sdf.format(lastupdatetime);
                listNumbers.add(number);
            }
        }
        return listNumbers;
    }

    private static List<String> getPersonNumbersDisableEntry(Context ctx, String startDateStr, String endDateStr) throws BOSException, SQLException {
        String lastDateZeroTimeStr = "";
        String noeTimeStr = "";
        if (StringUtils.isEmpty((CharSequence)startDateStr) || StringUtils.isEmpty((CharSequence)endDateStr)) {
            lastDateZeroTimeStr = SynPublicUtils.getLastUpdateSynTableTimeStrByEvenName(ctx, "synPersonDisableToErp");
            if (StringUtils.isEmpty((CharSequence)lastDateZeroTimeStr)) {
                lastDateZeroTimeStr = SynPublicUtils.getLastDateZeroTime();
            }
            SynPublicUtils.updateSynTimeTable(ctx, "synPersonDisableToErp");
            noeTimeStr = SynPublicUtils.getNowTimeStr();
        } else {
            lastDateZeroTimeStr = startDateStr;
            noeTimeStr = endDateStr;
        }
        String sql = "select person.fnumber as number, user2.fforbidden from  t_pm_user user2\n left join t_bd_person person on person.fid = user2.fpersonid\n left join  T_HR_EmpOrgRelation empOrgRelation  on person.fid=empOrgRelation.fpersonid  AND TO_CHAR(empOrgRelation.FLEFFDT,'YYYY-MM-DD')='2199-12-31' AND empOrgRelation.FASSIGNTYPE=1   right join t_org_admin admin on admin.fid = empOrgRelation.fadminorgid  where user2.fforbidden = 1  and  ((user2.flastupdatetime> {ts '" + lastDateZeroTimeStr + "'} and  user2.flastupdatetime <=  {ts '" + noeTimeStr + "'}) " + " or  (person.flastupdatetime> {ts '" + lastDateZeroTimeStr + "'} and  person.flastupdatetime <=  {ts '" + noeTimeStr + "'}) " + "  or  (empOrgRelation.flastupdatetime> {ts '" + lastDateZeroTimeStr + "'} and  empOrgRelation.flastupdatetime <=  {ts '" + noeTimeStr + "'})" + " or  (admin.flastupdatetime> {ts '" + lastDateZeroTimeStr + "'} and  admin.flastupdatetime <=  {ts '" + noeTimeStr + "'})) ";
        log.info("getPersonNumbersEnableEntry.sql" + sql);
        String number = "";
        ArrayList<String> listNumbers = new ArrayList<String>();
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                number = executeQuery.getString("number");
                listNumbers.add(number);
            }
        }
        return listNumbers;
    }

    private static void gt15_user_disable(Context ctx, String accessToken, String startDateStr, String endDateStr) throws Exception {
        String gt15UserDisableUrl = SynPersonToErpUtils.getGt15UserDisableUrl();
        log.info("SynPersonToErpUtils.gt15_user_disable.gt15UserDisableUrl:" + gt15UserDisableUrl);
        log.info("SynPersonToErpUtils.gt15_user_disable.accessToken:" + accessToken);
        List<String> listNumbers = SynPersonToErpUtils.getPersonNumbersDisableEntry(ctx, startDateStr, endDateStr);
        for (String number : listNumbers) {
            String paramJOStr = SynPersonToErpUtils.getParamJOStrByNumber(number);
            log.info("gt15_user_disable.paramJOStr:" + paramJOStr);
            String responseMsg = HttpsReqUtil.postByHttps(gt15UserDisableUrl, paramJOStr, accessToken);
            log.info("gt15_user_disable.responseMsg:" + responseMsg);
        }
    }

    public static void gt15_user_enable(Context ctx, String accessToken, String startDateStr, String endDateStr) throws Exception {
        String gt15UserEnableUrl = SynPersonToErpUtils.getGt15UserEnableUrl();
        log.info("SynPersonToErpUtils.gt15_user_enable.gt15UserDisableUrl:" + gt15UserEnableUrl);
        log.info("SynPersonToErpUtils.gt15_user_enable.accessToken:" + accessToken);
        List<String> listNumbers = SynPersonToErpUtils.getPersonNumbersEnableEntry(ctx, startDateStr, endDateStr);
        log.info("SynPersonToErpUtils.gt15_user_enable.listNumbers.size:" + listNumbers.size());
        for (String number : listNumbers) {
            String paramJOStr = SynPersonToErpUtils.getParamJOStrByNumber(number);
            log.info("gt15_user_enable.paramJOStr:" + paramJOStr);
            String responseMsg = HttpsReqUtil.postByHttps(gt15UserEnableUrl, paramJOStr, accessToken);
            log.info("gt15_user_enable.responseMsg:" + responseMsg);
        }
    }

    public static String getParamJOStrByNumber(String number) {
        JSONObject data = new JSONObject();
        data.put("number", (Object)number);
        JSONObject paramJO = new JSONObject();
        paramJO.put("data", (Object)data);
        String paramJOStr = paramJO.toString();
        return paramJOStr;
    }

    public static String synPersonDisableToErp(Context ctx, String startDate, String endDate) throws Exception {
        String appToken = SynSalaryFromErpUtils.getAppToken(ctx);
        log.info("\u83b7\u53d6synPersonDisableToErp.appToken\uff1a" + appToken);
        String accessToken = SynSalaryFromErpUtils.getAccessToken(appToken);
        log.info("\u83b7\u53d6synPersonDisableToErp.accessToken\u4e3a\uff1a" + accessToken);
        SynPersonToErpUtils.gt15_user_disable(ctx, accessToken, startDate, endDate);
        log.info("syndminorgBetaToErp.responseMsg\uff1a" + accessToken);
        return "";
    }

    public static String synPersonEnableToErp(Context ctx, String startDate, String endDate) throws Exception {
        String appToken = SynSalaryFromErpUtils.getAppToken(ctx);
        log.info("\u83b7\u53d6synPersonEnableToErp.appToken\uff1a" + appToken);
        String accessToken = SynSalaryFromErpUtils.getAccessToken(appToken);
        log.info("\u83b7\u53d6synPersonEnableToErp.accessToken\u4e3a\uff1a" + accessToken);
        SynPersonToErpUtils.gt15_user_enable(ctx, accessToken, startDate, endDate);
        log.info("synPersonEnableToErp.responseMsg\uff1a" + accessToken);
        return "";
    }
}

