/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import java.sql.Connection;
import java.util.Map;
import kd.isc.connector.eas.ACL;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.EasContextFactory;
import kd.isc.connector.eas.notify.NotifyUtil;
import kd.isc.iscb.util.connector.EventBindingCache;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.connector.IscHubConfigUtil;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Cipher;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class RemoteUndeploy
extends AbstractCommandExecutor {
    public String getCommand() {
        return "remote_undeploy";
    }

    protected Object exec(ConnectorContext ctx, Map<String, Object> params) {
        EasContext easContext = (EasContext)ctx;
        String dataCenter = easContext.getDataCenter();
        String key = EasContextFactory.getDeployKey(dataCenter);
        String iscHub = D.s((Object)params.get("isc_hub"));
        String data = D.s((Object)params.get("data"));
        Json.toObject((String)Cipher.decrypt((String)data, (String)key));
        Connection cn = ctx.getConnection();
        try {
            if (!StringUtil.isEmpty((String)iscHub)) {
                this.clearTable(cn, iscHub);
                this.clearCache(cn, dataCenter);
            }
        }
        finally {
            ctx.dispose(cn);
        }
        return "ok";
    }

    private void clearTable(Connection cn, String iscHub) {
        EventBindingUtil.deleteIscHub((Connection)cn);
        IscHubConfigUtil.clearIscHubPermissions((Connection)cn);
        EventBindingUtil.batchDeleteEventBind((Connection)cn, (String)iscHub);
        EventBindingUtil.batchDeleteEventQue((Connection)cn, (String)iscHub);
    }

    private void clearCache(Connection cn, String dataCenter) {
        try {
            EventBindingCache.init((String)dataCenter, (Connection)cn);
            EasContext.getErrLogger().error((Object)("EAS\u53cd\u90e8\u7f72\u8fdc\u7aef\u7f13\u5b58\u6e05\u7406:" + dataCenter));
            IscHubConfigUtil.removePermissions((String)dataCenter);
            ACL.removeAccessKeys(dataCenter);
            NotifyUtil.sendMsg(dataCenter, "UNDEPLOY_CLEAR_CACHE");
        }
        catch (Throwable e) {
            EasContext.getErrLogger().error((Object)"EAS\u53cd\u90e8\u7f72\u8fdc\u7aef\u7f13\u5b58\u6e05\u7406\u5f02\u5e38:", e);
        }
    }
}

