/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.isc.connector.eas.EasSideError;
import kd.isc.connector.eas.Util;
import kd.isc.iscb.util.connector.server.CommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.Returns;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class RetrieveAttachment
implements CommandExecutor {
    private static final int BLOCK_SIZE = 0x400000;

    public synchronized void exec(ConnectorContext ctx, Map<String, Object> params, Returns returns) {
        AttachmentServerManager serverManager;
        Context bosContext = Util.generateBosCtx(ctx, null);
        Map fileInfo = (Map)params.get("fileInfo");
        String attachId = D.s(fileInfo.get("srcAttachId"));
        byte[] contentBytes = this.downloadFile(attachId, serverManager = AttachmentManagerFactory.getServerManager((Context)bosContext));
        if (contentBytes.length <= 0) {
            throw new IscBizException("\u6839\u636e\u9644\u4ef6id:" + attachId + "\u627e\u5230\u7684\u9644\u4ef6\u5185\u5bb9\u4e3a\u7a7a");
        }
        this.handleContentByPart(returns, contentBytes, attachId);
    }

    private byte[] downloadFile(String attachId, AttachmentServerManager serverManager) {
        try {
            return serverManager.download(attachId);
        }
        catch (Exception e) {
            throw EasSideError.FILE_READ_ERROR.create((Throwable)e, new String[]{attachId, e.getMessage()});
        }
    }

    private void handleContentByPart(Returns returns, byte[] contentBytes, String attachId) {
        int from = 0;
        int len = contentBytes.length;
        while (from < len) {
            int to = Math.min(from + 0x400000, len);
            boolean hasMore = to < len;
            byte[] bytes = Arrays.copyOfRange(contentBytes, from, to);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("length", bytes.length);
            data.put("data", bytes);
            returns.setResult(data, hasMore);
            from += 0x400000;
        }
    }

    public String getCommand() {
        return "retrieve_attachment";
    }
}

