/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.meta;

import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import java.util.HashMap;
import java.util.Map;
import kd.isc.connector.eas.meta.AbstractSetter;
import kd.isc.connector.eas.meta.BigDecimalSetter;
import kd.isc.connector.eas.meta.BoidSetter;
import kd.isc.connector.eas.meta.BooleanSetter;
import kd.isc.connector.eas.meta.DoubleSetter;
import kd.isc.connector.eas.meta.EntriesSetter;
import kd.isc.connector.eas.meta.EnumSetter;
import kd.isc.connector.eas.meta.F7Setter;
import kd.isc.connector.eas.meta.FloatSetter;
import kd.isc.connector.eas.meta.IntegerSetter;
import kd.isc.connector.eas.meta.LongSetter;
import kd.isc.connector.eas.meta.MultiLangSetter;
import kd.isc.connector.eas.meta.Setter;
import kd.isc.connector.eas.meta.StringSetter;
import kd.isc.connector.eas.meta.TimeStampSetter;
import kd.isc.connector.eas.meta.UnknownTypeSetter;

public class DataTypeParser {
    private static final String DATA_SCHEMA = "data_schema";
    private static final Map<String, Setter> setters = new HashMap<String, Setter>();

    static {
        setters.put("string", new StringSetter());
        setters.put("boid", new BoidSetter());
        setters.put("ml_string", new MultiLangSetter());
        setters.put("integer", new IntegerSetter());
        setters.put("boolean", new BooleanSetter());
        setters.put("float", new FloatSetter());
        setters.put("double", new DoubleSetter());
        setters.put("BigDecimal", new BigDecimalSetter());
        setters.put("long", new LongSetter());
        TimeStampSetter timeStampSetter = new TimeStampSetter();
        setters.put("datetime", timeStampSetter);
        setters.put("date", timeStampSetter);
        setters.put("time", timeStampSetter);
    }

    public static AbstractSetter getSetter(Map<String, Object> dataType, PropertyInfo p, EntityObjectInfo en) {
        String name = (String)dataType.get("name");
        if ("REF".equals(name)) {
            BOSObjectType bostype = (BOSObjectType)dataType.get(DATA_SCHEMA);
            return new F7Setter(bostype);
        }
        if ("ENTRIES".equals(name)) {
            BOSObjectType bostype = (BOSObjectType)dataType.get(DATA_SCHEMA);
            return new EntriesSetter(bostype);
        }
        if ("ENUM".equals(name)) {
            return new EnumSetter((String)dataType.get(DATA_SCHEMA));
        }
        Setter setter = setters.get(name);
        if (setter == null) {
            setter = new UnknownTypeSetter(dataType, p, en);
        }
        return (AbstractSetter)setter;
    }
}

