/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server;

import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.connector.server.ConnectionProxy;
import kd.isc.iscb.util.connector.server.param.ServiceRequest;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.misc.Triple;
import kd.isc.iscb.util.script.Script;

public class ConnectorCallback {
    private static final ReadLockFreeMap<String, Triple<String, Long, Map<String, String>>> tokenCache = new ReadLockFreeMap();
    private static final ReadLockFreeMap<String, Map<String, String>> ierpLoginInfos = new ReadLockFreeMap();

    public static String getIerpServerURL(String dataCenter) {
        Map<String, String> loginInfo = ierpLoginInfos.get(dataCenter);
        if (loginInfo == null) {
            return null;
        }
        return ConnectorCallback.getIerpServerURL(loginInfo);
    }

    public static String lookupTargetOID(String dataCenter, String src_oid, String src_cn_number, String src_table, String target_cn_number, String tar_table) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("src_oid", src_oid);
        params.put("src_cn_number", src_cn_number);
        params.put("src_table", src_table);
        params.put("target_cn_number", target_cn_number);
        params.put("tar_table", tar_table);
        String id = D.s(ConnectorCallback.call(dataCenter, "LookupTargetOIDService", params));
        return id;
    }

    public static String findMappingValue(String dataCenter, String ruleNumber, String value) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ruleNumber", ruleNumber);
        params.put("value", value);
        String id = D.s(ConnectorCallback.call(dataCenter, "FindMappingValueService", params));
        return id;
    }

    public static Object call(String dataCenter, String iscService, Map<String, Object> params) {
        Map<String, String> loginInfo = ConnectorCallback.getIerpLoginInfo(dataCenter);
        return ConnectorCallback.call(loginInfo, iscService, params);
    }

    public static <R> R call(String dataCenter, ServiceRequest<R> param) {
        String svc = param.getServiceName();
        Map<String, Object> params = param.getParams();
        Object result = ConnectorCallback.call(dataCenter, svc, params);
        return param.parseResult(result);
    }

    public static Object call(Map<String, String> loginInfo, String iscService, Map<String, Object> params) {
        try {
            return ConnectorCallback.innerInvoke(loginInfo, iscService, params);
        }
        catch (Exception e) {
            String message = StringUtil.getMessage(e);
            if (!message.contains("error_desc=\u672a\u7ecf\u6388\u6743\u7684\u8bbf\u95ee\u3002")) {
                if (message.contains("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef")) {
                    throw new IscBizException(String.format(ResManager.loadKDString("\u8d26\u5957: %1$s\uff08%2$s\uff09\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u201c\u8fde\u63a5\u914d\u7f6e\u201d\u56de\u8c03\u4ee3\u7406\u7528\u6237\u6216\u5bc6\u7801\u662f\u5426\u6b63\u786e\u3002", "ConnectorCallback_10", "isc-iscb-util", new Object[0]), loginInfo.get("accountId"), loginInfo.get("accountName")), e);
                }
                throw D.e(e);
            }
            DbUtil.getLogger().error(ResManager.loadKDString("\u7531\u4e8e\u7f13\u5b58\u7684accesstoken\u5df2\u5931\u6548\uff0c\u6e05\u9664\u7f13\u5b58\u5e76\u91cd\u8bd5\u8c03\u7528\u3002", "ConnectorCallback_4", "isc-iscb-util", new Object[0]), e);
            ConnectorCallback.removeAccessToken(loginInfo);
            return ConnectorCallback.innerInvoke(loginInfo, iscService, params);
        }
    }

    private static Object innerInvoke(Map<String, String> loginInfo, String iscService, Map<String, Object> params) {
        String token = ConnectorCallback.getAccessToken(loginInfo);
        String url = String.valueOf(ConnectorCallback.getIerpServerURL(loginInfo)) + "/kapi" + "/app/iscb/IscServiceDispatcher" + "?access_token=" + token;
        params.put("command", iscService);
        return NetUtil.asyncHttpInvoke(url, params);
    }

    public static <R> R call(Map<String, String> loginInfo, ServiceRequest<R> param) {
        String svc = param.getServiceName();
        Map<String, Object> params = param.getParams();
        Object result = ConnectorCallback.call(loginInfo, svc, params);
        return param.parseResult(result);
    }

    public static void removeAccessToken(Map<String, String> loginInfo) {
        String key = ConnectorCallback.generateAccessTokenKey(loginInfo);
        tokenCache.remove(key);
    }

    public static String getAccessToken(Map<String, String> loginInfo) {
        String key = ConnectorCallback.generateAccessTokenKey(loginInfo);
        String access_token = ConnectorCallback.getCachedToken(key);
        if (access_token != null) {
            return access_token;
        }
        access_token = ConnectorCallback.getNewAccessToken(loginInfo);
        Triple<String, Long, Map<String, String>> value = new Triple<String, Long, Map<String, String>>(access_token, System.currentTimeMillis(), loginInfo);
        tokenCache.put(key, value);
        return access_token;
    }

    private static String generateAccessTokenKey(Map<String, String> loginInfo) {
        String key = Hash.mur2digital32(loginInfo.get("user"), loginInfo.get("accountId"), loginInfo.get("tenantid"), ConnectorCallback.getIerpServerURL(loginInfo));
        return key;
    }

    public static String getNewAccessToken(Map<String, String> loginInfo) {
        String appToken = ConnectorCallback.getAppToken(loginInfo);
        return ConnectorCallback.getAccessToken(appToken, loginInfo);
    }

    private static String getCachedToken(String key) {
        Triple<String, Long, Map<String, String>> p = tokenCache.get(key);
        if (p == null) {
            return null;
        }
        String access_token = p.getA();
        if (p.getB() > System.currentTimeMillis() - 1800000L) {
            return access_token;
        }
        ConnectorCallback.doLogout(access_token, p.getC());
        tokenCache.remove(key);
        return null;
    }

    private static void doLogout(String access_token, Map<String, String> loginInfo) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("access_token", access_token);
        String json = Json.toString(map, true);
        try {
            Reader reader = NetUtil.httpPost(String.valueOf(ConnectorCallback.getIerpServerURL(loginInfo)) + "/api/logout.do", json);
            ConnectorCallback.getData((Map)Script.parseJson(reader));
        }
        catch (Throwable e) {
            DbUtil.getLogger().error("doLogout", e);
        }
    }

    private static String getAccessToken(String appToken, Map<String, String> loginInfo) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(loginInfo);
        params.put("apptoken", appToken);
        String json = Json.toString(params, true);
        String url = String.valueOf(ConnectorCallback.getIerpServerURL(loginInfo)) + "/api/login.do";
        Reader reader = NetUtil.httpPost(url, json);
        String text = NetUtil.readText(reader);
        Map res = (Map)Script.parseJson(text);
        Map data = (Map)ConnectorCallback.getData(res);
        String access_token = D.s(data.get("access_token"));
        if (access_token == null) {
            String message = String.valueOf(ResManager.loadKDString("\u901a\u8fc7\u4ee5\u4e0bURL\u548c\u53c2\u6570\u83b7\u53d6\u4e0d\u5230access_token", "ConnectorCallback_11", "isc-iscb-util", new Object[0])) + "\r\n" + "URL=" + url + "\r\n" + String.format(ResManager.loadKDString("\u7ed3\u679c%s", "ConnectorCallback_12", "isc-iscb-util", new Object[0]), text);
            throw new IscBizException(message);
        }
        return access_token;
    }

    private static String getAppToken(Map<String, String> loginInfo) {
        String json = Json.toString(loginInfo, true);
        String url = String.valueOf(ConnectorCallback.getIerpServerURL(loginInfo)) + "/api/getAppToken.do";
        Reader reader = NetUtil.httpPost(url, json);
        String text = NetUtil.readText(reader);
        Map res = null;
        try {
            res = (Map)Script.parseJson(text);
        }
        catch (Throwable throwable) {
            throw new IscBizException("invalid json text : " + text, throwable);
        }
        Map data = (Map)ConnectorCallback.getData(res);
        String appToken = D.s(data.get("app_token"));
        if (appToken == null) {
            String message = String.valueOf(ResManager.loadKDString("\u901a\u8fc7\u4ee5\u4e0bURL\u548c\u53c2\u6570\u65e0\u6cd5\u83b7\u53d6\u5230app_token", "ConnectorCallback_13", "isc-iscb-util", new Object[0])) + "\r\n" + "URL=" + url + "\r\n" + String.format(ResManager.loadKDString("\u7ed3\u679c=%s", "ConnectorCallback_14", "isc-iscb-util", new Object[0]), text);
            throw new IscBizException(message);
        }
        return appToken;
    }

    private static Object getData(Map<String, Object> response) {
        if ("error".equals(response.get("state")) || "false".equals(D.s(response.get("success")))) {
            throw new IscBizException(String.valueOf(D.s(response.get("errorMsg"))) + "\r\n" + String.format(ResManager.loadKDString("\u9519\u8bef\u7801\uff1a%s", "ConnectorCallback_15", "isc-iscb-util", new Object[0]), response.get("errorCode")));
        }
        return response.get("data");
    }

    public static Map<String, String> getIerpLoginInfo(String dataCenter) {
        Map<String, String> map = ierpLoginInfos.get(dataCenter);
        if (map != null) {
            return map;
        }
        throw new IscBizException(String.format(ResManager.loadKDString("\u8d26\u5957\uff08%s\uff09\u6ca1\u6709\u914d\u7f6e\u96c6\u6210\u4e91\u3002", "ConnectorCallback_16", "isc-iscb-util", new Object[0]), dataCenter));
    }

    public static void registerLoginInfo(String dataCenter, Map<String, String> loginInfo) {
        ierpLoginInfos.put(dataCenter, Collections.unmodifiableMap(loginInfo));
    }

    public static void registerLoginInfo(String dataCenter, Map<String, String> loginInfo, String ierp_server_url, String permission_mode) {
        loginInfo.put("ierp_server_url", ierp_server_url);
        loginInfo.put("permission_mode", permission_mode);
        ierpLoginInfos.put(dataCenter, loginInfo);
    }

    public static PermissionMode getPermissionMode(String dataCenter) {
        Map<String, String> loginInfo = ierpLoginInfos.get(dataCenter);
        if (loginInfo == null) {
            return PermissionMode.DENY_ALL;
        }
        String mode = loginInfo.get("permission_mode");
        return mode == null ? PermissionMode.WHITE_LIST : PermissionMode.valueOf(mode);
    }

    private static String getIerpServerURL(Map<String, String> loginInfo) {
        String url = D.s(loginInfo.get("ierp_server_url"));
        if (url == null) {
            url = ConnectionProxy.getIerpServerURL();
        }
        if (url == null) {
            return null;
        }
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String getIscHub(String datacenter) {
        Map<String, String> map = ierpLoginInfos.get(datacenter);
        if (map != null) {
            return map.get("isc_hub");
        }
        return null;
    }

    public static void removeLoginInfo(String dataCenter) {
        ierpLoginInfos.remove(dataCenter);
    }

    public static void clearTokenCache() {
        tokenCache.clear();
    }
}

