/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.runtime;

import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.FlowTrace;
import kd.isc.iscb.util.flow.core.i.runtime.ExecutionImpl;
import kd.isc.iscb.util.flow.core.i.runtime.RuntimeImpl;

public final class ControllerImpl {
    public static void execute(RuntimeImpl runtime) {
        runtime.resetError();
        FlowTrace profile = runtime.getFlowTrace();
        try {
            ControllerImpl.execute(runtime, profile);
            runtime.setStopped(true);
        }
        finally {
            runtime.setStopped(false);
            profile.endFlow();
        }
        ControllerImpl.checkError(runtime);
    }

    private static void checkError(RuntimeImpl runtime) {
        Throwable e = runtime.getError();
        if (e != null) {
            runtime.popError();
            throw D.e(e);
        }
    }

    private static void execute(RuntimeImpl runtime, FlowTrace profile) {
        ExecutionImpl e = runtime.pop();
        while (e != null) {
            boolean interupted = ControllerImpl.execute(runtime, profile, e);
            if (interupted) {
                runtime.setStopped(false);
                break;
            }
            e = runtime.pop();
        }
    }

    private static boolean execute(RuntimeImpl runtime, FlowTrace profile, ExecutionImpl e) {
        while (e.getIp() >= 0) {
            Throwable error = runtime.getError();
            profile.begin(e);
            boolean success = false;
            boolean interupted = false;
            boolean isContinue = false;
            try {
                isContinue = e.execute();
                success = error == runtime.getError();
            }
            finally {
                interupted = profile.end(e, success);
            }
            if (!isContinue) {
                return false;
            }
            if (!interupted) continue;
            return true;
        }
        return false;
    }
}

