/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.network.CheckBean;
import kd.isc.iscb.util.network.CheckNetWorkUtil;
import kd.isc.iscb.util.network.CheckNetwork;
import kd.isc.iscb.util.network.CheckResult;

public class SimpleTelnet
implements CheckNetwork {
    protected static final SimpleTelnet INSTANCE = new SimpleTelnet();

    private SimpleTelnet() {
    }

    @Override
    public CheckResult check(CheckBean checkBean) {
        if (StringUtil.isEmpty(checkBean.getIpOrHostName())) {
            throw new IscBizException(ResManager.loadKDString("ip\u6216\u57df\u540d\u4e3a\u7a7a", "SimpleTelnet_0", "isc-iscb-util", new Object[0]));
        }
        if (checkBean.getPort() <= 0) {
            throw new IscBizException(ResManager.loadKDString("\u7f51\u7edc\u7aef\u53e3\u4e0d\u5408\u6cd5", "SimpleTelnet_1", "isc-iscb-util", new Object[0]));
        }
        long start = System.currentTimeMillis();
        Socket socket = null;
        try {
            socket = new Socket();
            InetSocketAddress address = new InetSocketAddress(checkBean.getIpOrHostName(), checkBean.getPort());
            socket.connect(address, checkBean.getTimeout());
            CheckResult checkResult = new CheckResult(true, start);
            return checkResult;
        }
        catch (Exception e) {
            CheckResult checkResult = new CheckResult(false, CheckNetWorkUtil.toString(e), start);
            return checkResult;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException ignore) {
                    DbUtil.getLogger().error("kd.isc.iscb.util.network.SimpleTelnet.check(CheckBean)", ignore);
                }
            }
        }
    }
}

