/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.common.AttachmentHelper;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.connector.eas.EasSideError;
import kd.isc.connector.eas.Util;
import kd.isc.iscb.util.connector.server.AbstractCommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class RetrieveAttachList
extends AbstractCommandExecutor {
    public String getCommand() {
        return "retrieve_attach_list";
    }

    protected Object exec(ConnectorContext ctx, Map<String, Object> params) {
        Context bosContext = Util.generateBosCtx(ctx, null);
        Map invokeParam = (Map)params.get("invokeParam");
        return RetrieveAttachList.retrieveAttachInfo(bosContext, D.s(invokeParam.get("id")));
    }

    public static List<Map<String, Object>> retrieveAttachInfo(Context context, String id) {
        if (id == null) {
            throw new IscBizException("\u5355\u636eid\u4e3a\u7a7a");
        }
        try {
            return RetrieveAttachList.readAttachInfo(context, id);
        }
        catch (Exception e) {
            throw EasSideError.FILE_META_READ_ERROR.create((Throwable)e, new String[]{id, e.getMessage()});
        }
    }

    private static List<Map<String, Object>> readAttachInfo(Context context, String id) throws BOSException, EASBizException {
        AttachmentServerManager serverManager = AttachmentManagerFactory.getServerManager((Context)context);
        String[] attachmentIDs = serverManager.getAttachmentIDsByBoID(id);
        ArrayList<Map<String, Object>> fileLists = new ArrayList<Map<String, Object>>();
        SelectorItemCollection sic = RetrieveAttachList.getAttachmentSelector();
        String[] stringArray = attachmentIDs;
        int n = attachmentIDs.length;
        int n2 = 0;
        while (n2 < n) {
            String attachmentId = stringArray[n2];
            AttachmentInfo attachmentInfo = AttachmentHelper.getIAttachment((Context)context).getAttachmentInfo((IObjectPK)new ObjectUuidPK(attachmentId), sic);
            HashMap<String, Object> fileInfo = new HashMap<String, Object>();
            fileInfo.put("srcAttachId", attachmentId);
            fileInfo.put("name", attachmentInfo.getName());
            fileInfo.put("type", attachmentInfo.getSimpleName());
            fileInfo.put("bytes", attachmentInfo.getSizeInByte());
            fileInfo.put("desc", attachmentInfo.getDescription());
            UserInfo creator = attachmentInfo.getCreator();
            if (creator != null) {
                fileInfo.put("srcAttachCreator", creator.getId());
                fileInfo.put("srcAttachCreatorNum", creator.getNumber());
            }
            fileInfo.put("srcAttachCreateTime", attachmentInfo.getCreateTime());
            fileLists.add(fileInfo);
            ++n2;
        }
        return fileLists;
    }

    private static SelectorItemCollection getAttachmentSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("type"));
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("size"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("isShared"));
        sic.add(new SelectorItemInfo("isOnlySameBillShare"));
        sic.add(new SelectorItemInfo("sizeInByte"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("createTime"));
        return sic;
    }
}

