/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.e;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.job.util.DbConnector;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.enums.Enum;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.isc.connector.eas.EasSideError;
import kd.isc.connector.eas.TableUtil;
import kd.isc.connector.eas.Util;
import kd.isc.connector.eas.e.RetrieveAttachList;
import kd.isc.iscb.util.connector.server.CommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.Returns;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DataTypeUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;

public class RetrieveData
implements CommandExecutor {
    private static final String LIKE = "like";
    private static final String NOT_LIKE = "not like";
    private static final String FILTER_RIGHT_BRACKET = "filter_right_bracket";
    private static final String FILTER_LEFT_BRACKET = "filter_left_bracket";
    public static final int BATCH_SIZE = 100;

    public void exec(ConnectorContext ctx, Map<String, Object> params, Returns returns) {
        String entity = D.s((Object)params.get("entity"));
        if (!ctx.isValid(entity, ConnectorContext.Operation.READ)) {
            throw EasSideError.OUT_OF_PERMISSION.create(new String[]{entity});
        }
        Context bos_context = Util.generateBosCtx(ctx, null);
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)bos_context);
        EntityObjectInfo en = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)entity));
        if (en == null || en.getType() == null) {
            throw new IscBizException("\u627e\u4e0d\u5230EAS\u5b9e\u4f53:" + entity);
        }
        HashMap<String, String> tableNameToAsName = new HashMap<String, String>();
        tableNameToAsName.put(en.getTable().getName(), "t0");
        StringBuilder sql = new StringBuilder("select t0.fid from " + en.getTable().getName() + " t0 ");
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        String joinAndWhere = this.parseJoinAndWhere(bos_context, en, params, tableNameToAsName, values, types);
        String orderby = this.createOrderBy(en, params);
        sql.append(joinAndWhere);
        sql.append(orderby);
        Connection cn = null;
        ObjectReader reader = null;
        try {
            try {
                bos_context.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                cn = DbConnector.getConnection((Context)bos_context);
                long count = DbUtil.executeCount((Connection)cn, (String)sql.toString(), values, types);
                ICoreBase finder = (ICoreBase)BOSObjectFactory.createBOSObject((Context)bos_context, (BOSObjectType)en.getType());
                Map requires = (Map)params.get("requires");
                SelectorItemCollection selectors = RetrieveData.generateSelector(requires);
                ArrayList<Map<String, Object>> data = new ArrayList<Map<String, Object>>();
                reader = DbUtil.executeQuery((Connection)cn, (String)sql.toString(), values, types);
                long start = System.currentTimeMillis();
                DataRow row = (DataRow)reader.read();
                while (row != null) {
                    String fid = D.s((Object)row.get((Object)"fid"));
                    CoreBaseInfo o = finder.getValue((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)fid)), selectors);
                    Map<String, Object> item = RetrieveData.formatInfo(requires, bos_context, (IObjectValue)o);
                    data.add(item);
                    long timespan = System.currentTimeMillis() - start;
                    if (data.size() >= 100 || timespan > 5000L) {
                        this.output(returns, data, count, true);
                        start = System.currentTimeMillis();
                        data = new ArrayList();
                    }
                    row = (DataRow)reader.read();
                }
                this.output(returns, data, count, false);
            }
            catch (Exception e) {
                throw DatabaseError.SQL_QUERY_FAILURE.wrap((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            bos_context.put((Object)"disablePermissionForKScript", (Object)Boolean.FALSE);
            DbUtil.close(reader);
            DbUtil.close((Connection)cn, (boolean)false);
            throw throwable;
        }
        bos_context.put((Object)"disablePermissionForKScript", (Object)Boolean.FALSE);
        DbUtil.close((ObjectReader)reader);
        DbUtil.close((Connection)cn, (boolean)false);
    }

    public static void handleAttachment(Context bos_context, boolean needAttachment, Map<String, Object> item) {
        if (needAttachment) {
            List<Map<String, Object>> fileList = RetrieveAttachList.retrieveAttachInfo(bos_context, RetrieveData.id(item));
            item.put("$file_list", fileList);
        }
    }

    private static String id(Map<String, Object> item) {
        return D.s((Object)item.get("id"));
    }

    private String parseJoinAndWhere(Context bos_context, EntityObjectInfo en, Map<String, Object> params, Map<String, String> tableNameToAsName, List<Object> values, List<Integer> types) {
        StringBuilder filter = new StringBuilder();
        StringBuilder join = new StringBuilder();
        Collection filters = (Collection)params.get("filter");
        int i = 0;
        for (Map filterItem : filters) {
            Object value;
            if (filterItem.get(FILTER_LEFT_BRACKET) != null) {
                filter.append(filterItem.get(FILTER_LEFT_BRACKET));
            }
            if ("*".equals(value = filterItem.get("filter_value"))) {
                filter.append(" 1=1 ");
            } else {
                String filterColumn = D.s(filterItem.get("filter_column"));
                this.innerParseJoinAndWhere(bos_context, en, tableNameToAsName, values, types, filter, join, filterItem, value, filterColumn);
            }
            if (filterItem.get(FILTER_RIGHT_BRACKET) != null) {
                filter.append(filterItem.get(FILTER_RIGHT_BRACKET));
            }
            if (i < filters.size() - 1) {
                filter.append("OR".equals(filterItem.get("filter_link")) ? " or " : " and ");
            }
            ++i;
        }
        if (filter.length() > 0) {
            return String.valueOf(join.toString()) + " where " + filter.toString();
        }
        return "";
    }

    private void innerParseJoinAndWhere(Context bos_context, EntityObjectInfo en, Map<String, String> tableNameToAsName, List<Object> values, List<Integer> types, StringBuilder filter, StringBuilder join, Map<String, Object> filterItem, Object value, String filterColumn) {
        if (filterColumn.indexOf(".") < 0) {
            String sqlFieldName = this.getSqlFieldName(en, tableNameToAsName, filterColumn);
            filter.append(String.valueOf(sqlFieldName) + " ");
            String filter_compare = (String)filterItem.get("filter_compare");
            this.innerCondition(bos_context, en, values, types, filter, value, filterColumn, filter_compare);
        } else {
            String propName = filterColumn.substring(0, filterColumn.indexOf("."));
            PropertyInfo refprop = en.getPropertyByNameRuntime(propName);
            if (refprop instanceof LinkPropertyInfo) {
                RelationshipInfo rs = ((LinkPropertyInfo)refprop).getRelationship();
                this.parseLinkProperty(bos_context, en, tableNameToAsName, values, types, filter, join, filterItem, value, filterColumn, propName, rs);
            } else {
                throw new IscBizException(en + "\u7684\u5c5e\u6027[" + propName + "]\u4e0d\u662f\u8fde\u63a5\u5c5e\u6027\uff0c\u8bf7\u4e0d\u8981\u4f7f\u7528[.]\u505a\u5206\u9694");
            }
        }
    }

    private void parseLinkProperty(Context bos_context, EntityObjectInfo en, Map<String, String> tableNameToAsName, List<Object> values, List<Integer> types, StringBuilder filter, StringBuilder join, Map<String, Object> filterItem, Object value, String filterColumn, String propName, RelationshipInfo rs) {
        CardinalityType type = rs.getSupplierCardinality();
        EntityObjectInfo supplierObject = rs.getSupplierObject();
        if (type == CardinalityType.ONE || type == CardinalityType.ZERO_TO_ONE) {
            String refTableName = supplierObject.getTable().getName();
            if (!tableNameToAsName.containsKey(refTableName)) {
                tableNameToAsName.put(refTableName, "t" + tableNameToAsName.size());
                join.append(" left join ");
                join.append(refTableName);
                join.append(" " + tableNameToAsName.get(refTableName));
                join.append(" on " + this.getSqlFieldName(en, tableNameToAsName, propName));
                join.append(" = ");
                join.append(this.getSqlFieldName(supplierObject, tableNameToAsName, rs.getSupplierProperty().getName()));
            }
        } else {
            throw new IscBizException("\u4e0d\u652f\u6301\u5206\u5f55\u8fc7\u6ee4\u6761\u4ef6");
        }
        String column = this.getFilterColumn(en, supplierObject, filterColumn, propName);
        this.innerParseJoinAndWhere(bos_context, supplierObject, tableNameToAsName, values, types, filter, join, filterItem, value, column);
    }

    private String getFilterColumn(EntityObjectInfo en, EntityObjectInfo supplierObject, String filterColumn, String propName) {
        String column = filterColumn.substring(filterColumn.indexOf(".") + 1);
        if (en.equals((Object)supplierObject)) {
            if ("id".equalsIgnoreCase(column)) {
                return propName;
            }
            throw new IscBizException("\u5f53\u8fc7\u6ee4\u6761\u4ef6\u5f15\u7528\u7684\u5b9e\u4f53\u4e0e\u4e3b\u5b9e\u4f53\u662f\u76f8\u540c\u7c7b\u578b\u3010" + en.getDisplayName() + ":" + en.getRealFullName() + "\u3011\u65f6\uff0c\u4e0d\u652f\u6301\u4f7f\u7528\u975eid\u7684\u5173\u8054\u5b57\u6bb5\u3002\u5f53\u524d\u8fc7\u6ee4\u6761\u4ef6\u3010" + filterColumn + "\u3011\uff0c\u53ef\u6539\u4e3a\u4f7f\u7528\u3010" + propName + ".id\u3011\u3002");
        }
        return column;
    }

    private void innerCondition(Context bos_context, EntityObjectInfo en, List<Object> values, List<Integer> types, StringBuilder filter, Object outter, String filterColumn, String filter_compare) {
        ColumnInfo columnInfo = en.getPropertyByNameRuntime(filterColumn).getMappingField();
        Table table = TableUtil.getTable(bos_context.getAIS(), en.getTable().getName());
        int sqlType = table.getField(columnInfo.getName().toLowerCase()).getSqlType();
        if (filter_compare.equals("in")) {
            filter.append("in (");
            this.handleInOrNotIn(values, types, filter, outter, filterColumn, sqlType);
            filter.append(")");
        } else if (filter_compare.equals("not in")) {
            filter.append("not in(");
            this.handleInOrNotIn(values, types, filter, outter, filterColumn, sqlType);
            filter.append(")");
        } else {
            Object value = this.getValueForSave(outter, sqlType);
            if (filter_compare.equals("STARTS_WITH")) {
                filter.append(LIKE);
                values.add(value + "%");
                types.add(sqlType);
                filter.append(" ? ");
            } else if (filter_compare.equals("CONTAINS")) {
                filter.append(LIKE);
                values.add("%" + value + "%");
                types.add(sqlType);
                filter.append(" ? ");
            } else if (filter_compare.equals("ENDS_WITH")) {
                filter.append(LIKE);
                values.add("%" + value);
                types.add(sqlType);
                filter.append(" ? ");
            } else if (filter_compare.equals("NOT_STARTS_WITH")) {
                filter.append(NOT_LIKE);
                values.add(value + "%");
                types.add(sqlType);
                filter.append(" ? ");
            } else if (filter_compare.equals("NOT_CONTAINS")) {
                filter.append(NOT_LIKE);
                values.add("%" + value + "%");
                types.add(sqlType);
                filter.append(" ? ");
            } else if (filter_compare.equals("NOT_ENDS_WITH")) {
                filter.append(NOT_LIKE);
                values.add("%" + value);
                types.add(sqlType);
                filter.append(" ? ");
            } else if (filter_compare.equals("IS_NULL")) {
                filter.append("is null");
            } else if (filter_compare.equals("IS_NOT_NULL")) {
                filter.append("is not null");
            } else {
                filter.append(filter_compare);
                filter.append(" ? ");
                values.add(value);
                types.add(sqlType);
            }
        }
    }

    public Object getValueForSave(Object outter, int sqlType) {
        DataType dataType = DataTypeUtil.getDataType((int)sqlType);
        Object inner = dataType.narrow(outter);
        Object value = inner == null ? null : dataType.forSave(inner);
        return value;
    }

    public void handleInOrNotIn(List<Object> values, List<Integer> types, StringBuilder filter, Object value, String filterColumn, int sqlType) {
        if (value instanceof List) {
            this.handleMultiParams(values, types, filter, sqlType, (List)value);
        } else if (this.isArray(value)) {
            List list = (List)JSON.parseObject((String)value.toString(), List.class);
            this.handleMultiParams(values, types, filter, sqlType, list);
        } else {
            throw new IscBizException(String.valueOf(filterColumn) + "\u7684\u503c\u4e0d\u662f\u5217\u8868\u6216\u6570\u7ec4\uff0c\u4e0d\u80fd\u7528in\u6216not in\u3002" + value);
        }
    }

    public void handleMultiParams(List<Object> values, List<Integer> types, StringBuilder filter, int sqlType, List<?> list) {
        int i = 0;
        while (i < list.size()) {
            if (i > 0) {
                filter.append(",");
            }
            filter.append("?");
            types.add(sqlType);
            values.add(this.getValueForSave(list.get(i), sqlType));
            ++i;
        }
    }

    private boolean isArray(Object value) {
        return value instanceof String && value.toString().startsWith("[");
    }

    public String getSqlFieldName(EntityObjectInfo en, Map<String, String> tableNameToAsName, String propName) {
        PropertyInfo property = en.getPropertyByNameRuntime(propName);
        if (property == null) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u3010" + en.getDisplayName() + ":" + en.getRealFullName() + "\u3011\u4e2d\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\u3010" + propName + "\u3011\u7684\u5c5e\u6027\u3002");
        }
        ColumnInfo field = property.getMappingField();
        if (field == null) {
            throw new IllegalArgumentException("\u5b9e\u4f53\u3010" + en.getDisplayName() + ":" + en.getRealFullName() + "\u3011\u7684\u3010" + propName + "\u3011\u5c5e\u6027\u6ca1\u6709\u7ed1\u5b9a\u5b57\u6bb5\u3002");
        }
        String fieldName = field.getName();
        if (field.isMultilingual()) {
            fieldName = String.valueOf(fieldName) + "_l2";
        }
        return String.valueOf(tableNameToAsName.get(en.getTable().getName())) + "." + fieldName;
    }

    private String createOrderBy(EntityObjectInfo en, Map<String, Object> params) {
        StringBuilder sort = new StringBuilder();
        int i = 0;
        for (Map item : (Collection)params.get("order_by")) {
            String sortFieldName;
            PropertyInfo propertyByNameRuntime;
            if (i > 0) {
                sort.append(", ");
            }
            if ((propertyByNameRuntime = en.getPropertyByNameRuntime(sortFieldName = D.s(item.get("sort_field")))) == null) {
                throw new IscBizException("\u5b9e\u4f53\u3010" + en.getAlias() + "\u3011\u4e0d\u5b58\u5728\u6392\u5e8f\u5b57\u6bb5\uff1a" + sortFieldName);
            }
            sort.append("t0." + propertyByNameRuntime.getMappingField().getName());
            sort.append(D.s(item.get("sort_mode")).equals("DESC") ? " desc" : " asc");
            ++i;
        }
        if (sort.length() > 0) {
            return " order by " + sort.toString();
        }
        return "";
    }

    private void output(Returns returns, List<Map<String, Object>> data, long count, boolean hasMore) {
        HashMap<String, Object> meta = new HashMap<String, Object>();
        meta.put("count", count);
        meta.put("data", data);
        returns.setResult(meta, hasMore);
    }

    public String getCommand() {
        return "retrieve_data";
    }

    public static SelectorItemCollection generateSelector(Map<String, Object> requires) {
        SelectorItemCollection selector = new SelectorItemCollection();
        RetrieveData.recurParseSelector("", requires, selector);
        return selector;
    }

    private static void recurParseSelector(String prefix, Map<String, Object> requires, SelectorItemCollection selector) {
        for (Map.Entry<String, Object> entry : requires.entrySet()) {
            if (entry.getKey().startsWith("$")) continue;
            if (entry.getValue() instanceof Map) {
                RetrieveData.handleChildProp(prefix, selector, entry);
                continue;
            }
            selector.add(String.valueOf(prefix) + entry.getKey());
        }
    }

    private static void handleChildProp(String prefix, SelectorItemCollection selector, Map.Entry<String, Object> entry) {
        Map entryVal = (Map)entry.getValue();
        if (entryVal.containsKey("zh_CN") || entryVal.containsKey("zh_TW") || entryVal.containsKey("en_US")) {
            selector.add(String.valueOf(prefix) + entry.getKey());
        } else {
            String newPrefix = prefix.length() == 0 ? String.valueOf(entry.getKey()) + "." : String.valueOf(prefix) + entry.getKey() + ".";
            RetrieveData.recurParseSelector(newPrefix, entryVal, selector);
        }
    }

    public SorterItemCollection generateSorter(Map<String, Object> params) {
        SorterItemCollection sorter = new SorterItemCollection();
        for (Map item : (Collection)params.get("order_by")) {
            SorterItemInfo field = new SorterItemInfo(D.s(item.get("sort_field")));
            field.setSortType(item.get("sort_mode").equals("DESC") ? SortType.DESCEND : SortType.ASCEND);
            sorter.add(field);
        }
        return sorter;
    }

    public FilterInfo generateFilter(Map<String, Object> params) {
        FilterInfo filter = new FilterInfo();
        StringBuilder sb = new StringBuilder();
        int count = 0;
        Collection c = (Collection)params.get("filter");
        for (Map item : c) {
            FilterItemInfo info = new FilterItemInfo();
            info.setPropertyName(D.s(item.get("filter_column")));
            this.setCompare(item, info);
            filter.getFilterItems().add(info);
            count = this.generateMaskString(sb, c, item, count);
        }
        filter.setMaskString(sb.toString());
        return filter;
    }

    private int generateMaskString(StringBuilder sb, Collection<Map<String, Object>> c, Map<String, Object> item, int count) {
        String link;
        String left = D.s((Object)item.get(FILTER_LEFT_BRACKET));
        if (left != null) {
            sb.append(left);
        }
        sb.append("#").append(count);
        String right = D.s((Object)item.get(FILTER_RIGHT_BRACKET));
        if (right != null) {
            sb.append(right);
        }
        String string = link = "OR".equals(item.get("filter_link")) ? "or" : "and";
        if (++count < c.size()) {
            sb.append(" ").append(link).append(" ");
        }
        return count;
    }

    private void setCompare(Map<String, Object> item, FilterItemInfo info) {
        String compare = D.s((Object)item.get("filter_compare"));
        Object compareValue = item.get("filter_value");
        if (compare.equals("CONTAINS")) {
            info.setCompareType(CompareType.LIKE);
            info.setCompareValue((Object)("%" + compareValue + "%"));
        } else if (compare.equals("STARTS_WITH")) {
            info.setCompareType(CompareType.LIKE);
            info.setCompareValue((Object)(compareValue + "%"));
        } else if (compare.equals("ENDS_WITH")) {
            info.setCompareType(CompareType.LIKE);
            info.setCompareValue((Object)("%" + compareValue));
        } else if (compare.equals("<>")) {
            info.setCompareType(CompareType.NOTEQUALS);
            info.setCompareValue(compareValue);
        } else if (compare.equals(">")) {
            info.setCompareType(CompareType.GREATER);
            info.setCompareValue(compareValue);
        } else if (compare.equals(">=")) {
            info.setCompareType(CompareType.GREATER_EQUALS);
            info.setCompareValue(compareValue);
        } else if (compare.equals("<")) {
            info.setCompareType(CompareType.LESS);
            info.setCompareValue(compareValue);
        } else if (compare.equals("<=")) {
            info.setCompareType(CompareType.LESS_EQUALS);
            info.setCompareValue(compareValue);
        } else if (compare.equals("=")) {
            info.setCompareType(CompareType.EQUALS);
            info.setCompareValue(compareValue);
        } else if (compare.equals("in")) {
            info.setCompareType(CompareType.INCLUDE);
            this.setMultiValue(info, compareValue);
        } else if (compare.equals("not in")) {
            info.setCompareType(CompareType.NOTINCLUDE);
            this.setMultiValue(info, compareValue);
        } else if (compare.equals("NOT_CONTAINS")) {
            info.setCompareType(CompareType.NOTLIKE);
            info.setCompareValue((Object)("%" + compareValue + "%"));
        } else if (compare.equals("NOT_STARTS_WITH")) {
            info.setCompareType(CompareType.NOTLIKE);
            info.setCompareValue((Object)(compareValue + "%"));
        } else if (compare.equals("NOT_ENDS_WITH")) {
            info.setCompareType(CompareType.NOTLIKE);
            info.setCompareValue((Object)("%" + compareValue));
        } else if (compare.equals("IS_NULL")) {
            info.setCompareType(CompareType.EQUALS);
            info.setCompareValue(null);
        } else if (compare.equals("IS_NOT_NULL")) {
            info.setCompareType(CompareType.NOTEQUALS);
            info.setCompareValue(null);
        } else {
            throw new IllegalArgumentException("\u975e\u6cd5\u6bd4\u8f83\u8fd0\u7b97\u7b26\uff08" + compare + "\uff09.");
        }
    }

    public void setMultiValue(FilterItemInfo info, Object compareValue) {
        if (compareValue instanceof List) {
            info.setCompareValue(new HashSet((List)compareValue));
        } else if (compareValue instanceof String && compareValue.toString().startsWith("[")) {
            List list = (List)JSON.parseObject((String)compareValue.toString(), List.class);
            info.setCompareValue(new HashSet(list));
        }
    }

    public static Map<String, Object> format(IObjectValue o, Map<String, Object> requires, Context ctx) {
        return RetrieveData.formatInfo(requires, ctx, o);
    }

    public static Map<String, Object> formatInfo(Map<String, Object> requires, Context ctx, IObjectValue o) {
        Set<String> multilang_properties = Util.getMultiLangProperties(ctx, o.getBOSType());
        HashMap<String, Object> item = new HashMap<String, Object>();
        requires.put("id", 1);
        for (Map.Entry<String, Object> e : requires.entrySet()) {
            String key = e.getKey();
            Object value = o.get(key);
            if (key.startsWith("$")) continue;
            if (e.getValue() instanceof Map) {
                if (value instanceof String) {
                    item.put(key, RetrieveData.format(o, key, (Map)e.getValue()));
                    continue;
                }
                item.put(key, RetrieveData.format(value, (Map<String, Object>)((Map)e.getValue()), ctx));
                continue;
            }
            if (multilang_properties.contains(key)) {
                item.put(key, RetrieveData.formatMultiLang(o, key));
                continue;
            }
            item.put(key, RetrieveData.format(value));
        }
        RetrieveData.handleAttachment(ctx, D.x((Object)requires.get("$supports_file_copy")), item);
        item.put("$id", o.get("id"));
        item.put("$pk", "id");
        return item;
    }

    private static Object format(IObjectCollection c, Map<String, Object> requires, Context ctx) {
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>(c.size());
        int i = 0;
        while (i < c.size()) {
            IObjectValue o = c.getObject(i);
            Map<String, Object> item = RetrieveData.format(o, requires, ctx);
            items.add(item);
            ++i;
        }
        return items;
    }

    private static Object format(Object value, Map<String, Object> requires, Context ctx) {
        if (value instanceof IObjectCollection) {
            return RetrieveData.format((IObjectCollection)value, requires, ctx);
        }
        if (value instanceof IObjectValue) {
            return RetrieveData.format((IObjectValue)value, requires, ctx);
        }
        if (value instanceof Enum) {
            return RetrieveData.format((Enum)value);
        }
        return value;
    }

    private static Object format(IObjectValue o, String key, Map<String, Object> requires) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String l : requires.keySet()) {
            map.put(l, o.get(String.valueOf(key) + "_" + RetrieveData.getLocale(l)));
        }
        return map;
    }

    private static String getLocale(String l) {
        if (l.equals("zh_CN")) {
            return "l2";
        }
        if (l.equals("zh_TW")) {
            return "l3";
        }
        if (l.equals("en_US")) {
            return "l1";
        }
        return "l2";
    }

    private static Object formatMultiLang(IObjectValue o, String key) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("en_US", o.get(String.valueOf(key) + "_l1"));
        map.put("zh_CN", o.get(String.valueOf(key) + "_l2"));
        map.put("zh_TW", o.get(String.valueOf(key) + "_l3"));
        return map;
    }

    private static Object format(Object value) {
        if (value instanceof IObjectValue) {
            return RetrieveData.format((IObjectValue)value);
        }
        if (value instanceof Enum) {
            return RetrieveData.format((Enum)value);
        }
        if (value instanceof IObjectCollection) {
            return RetrieveData.format((IObjectCollection)value);
        }
        return value;
    }

    private static Object format(IObjectCollection c) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (IObjectValue obj : c) {
            list.add(obj.get("id"));
        }
        return list;
    }

    private static Object format(Enum o) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("value", o.getName());
        map.put("title", o.getAlias());
        return map;
    }

    private static Object format(IObjectValue o) {
        return o.get("id");
    }
}

