/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.service.job.util.DbConnector;
import java.sql.Connection;
import java.util.Map;
import kd.isc.connector.eas.ACL;
import kd.isc.iscb.util.connector.IscHubConfigUtil;
import kd.isc.iscb.util.connector.PermissionMode;
import kd.isc.iscb.util.connector.server.ConnectorCallback;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.Returns;
import kd.isc.iscb.util.connector.server.SerializableResultManager;
import kd.isc.iscb.util.connector.server.SerializableReturns;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.misc.Json;
import org.apache.log4j.Logger;

public class EasContext
implements ConnectorContext {
    private String dataCenter;
    private String userId;
    private String queryString;
    private String protocal;
    private String hash;
    private String key;
    private static final Logger ERR_LOGGER = Logger.getLogger((String)"com.kingdee.isc.connector.eas.Error");
    private static final Logger SQL_LOGGER = Logger.getLogger((String)"com.kingdee.isc.connector.eas.SQL");

    EasContext(String dataCenter) {
        this.dataCenter = dataCenter;
    }

    EasContext(String dataCenter, String userId, String queryString, String protocal, String hash, String key) {
        this.dataCenter = dataCenter;
        this.userId = userId;
        this.queryString = queryString;
        this.protocal = protocal;
        this.hash = hash;
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public boolean supportsTransaction() {
        return true;
    }

    public String getHash() {
        return this.hash;
    }

    public String getProtocal() {
        return this.protocal;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getDataCenter() {
        return this.dataCenter;
    }

    public String getUserId() {
        return this.userId;
    }

    public Connection getConnection() {
        try {
            return DbConnector.getConnection((String)this.dataCenter);
        }
        catch (BOSException e) {
            throw DatabaseError.CONNECTION_FAILURE.create((Throwable)e, new String[]{this.dataCenter});
        }
    }

    public void dispose(Connection cn) {
        DbUtil.close((Connection)cn, (boolean)false);
    }

    public boolean isValid(String meta, ConnectorContext.Operation op) {
        PermissionMode mode = ConnectorCallback.getPermissionMode((String)this.dataCenter);
        if (PermissionMode.PUBLIC.equals((Object)mode)) {
            return true;
        }
        if (PermissionMode.DENY_ALL.equals((Object)mode)) {
            return false;
        }
        if (ACL.isValid(this.dataCenter, meta, op.name())) {
            return true;
        }
        return IscHubConfigUtil.hasPermission((String)this.dataCenter, (String)meta, (ConnectorContext.Operation)op, (ConnectorContext)this);
    }

    public void logger(String message, Throwable error) {
        ERR_LOGGER.warn((Object)message, error);
    }

    public void logger(String command, String sql, Map<String, Object> params) {
        StringBuilder message = new StringBuilder();
        message.append("Command:").append(command).append("\r\n");
        if (sql != null) {
            message.append("Sql:").append(command).append("\r\n");
        }
        message.append("Params:").append(Json.toString(params));
        SQL_LOGGER.info((Object)message);
    }

    public Returns createReturns(String command) {
        return new SerializableReturns((ConnectorContext)this);
    }

    public void removeResult(String id) {
        SerializableResultManager.removeChunks((ConnectorContext)this, (String)id);
    }

    public Object getResult(String id) {
        return SerializableResultManager.getResult((ConnectorContext)this, (String)id);
    }

    public static Logger getErrLogger() {
        return ERR_LOGGER;
    }
}

