/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterInfo;
import com.kingdee.bos.metadata.entity.CardinalityType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.service.job.util.SQL;
import com.kingdee.bos.service.scheduler.util.SchedulerUtils;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.ep.CoreBillBaseCustomInfo;
import com.kingdee.eas.ep.DataBaseCustomInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBException;
import kd.isc.connector.eas.ACL;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.EasContextFactory;
import kd.isc.connector.eas.EasSideError;
import kd.isc.connector.eas.EasThreadParamUtil;
import kd.isc.connector.eas.TableUtil;
import kd.isc.connector.eas.meta.AbstractSetter;
import kd.isc.connector.eas.meta.EntriesSetter;
import kd.isc.connector.eas.meta.SchemaCache;
import kd.isc.connector.eas.meta.Setter;
import kd.isc.iscb.util.connector.server.ConnectorCallback;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.ReflectionUtil;

public class Util {
    private static List<String> datacenters = new ArrayList<String>();
    private static final Map<String, Map<BOSObjectType, Set<String>>> multilang_properties = new ConcurrentHashMap<String, Map<BOSObjectType, Set<String>>>();

    public static String getLabel(BizEnumValueInfo p) {
        String title = D.s((Object)p.getAlias());
        String title2 = title == null ? D.s((Object)p.getValue()) : title;
        return Util.trim(title2);
    }

    public static String getLabel(PropertyInfo p) {
        String title = D.s((Object)p.getAlias());
        String title2 = title == null ? p.getName() : title;
        return Util.trim(title2);
    }

    public static Object getLabel(ParameterInfo p) {
        String title = D.s((Object)p.getAlias());
        String title2 = title == null ? p.getName() : title;
        return Util.trim(title2);
    }

    public static Object getTitle(BizEnumInfo en) {
        String title = D.s((Object)en.getAlias());
        if (title != null) {
            return Util.trim(title);
        }
        String name = en.getFullName();
        return Util.trim(name.substring(name.lastIndexOf(46) + 1));
    }

    public static Object getTitle(EntityObjectInfo en) {
        EntityObjectInfo master = Util.getMaster(en);
        String title = D.s((Object)en.getAlias());
        if (title != null) {
            if (master != null) {
                title = String.valueOf(D.s((Object)master.getAlias())) + "." + title;
            }
            return Util.trim(title);
        }
        String name = en.getFullName();
        return Util.trim(name.substring(name.lastIndexOf(46) + 1));
    }

    public static Object getTitle(BusinessObjectInfo info, MethodInfo method) {
        String n;
        String s = D.s((Object)info.getAlias());
        if (s == null) {
            s = info.getName();
        }
        if ((n = method.getAlias()) == null) {
            n = method.getRealName();
        }
        return Util.trim(String.valueOf(s) + "-" + n);
    }

    private static EntityObjectInfo getMaster(EntityObjectInfo en) {
        try {
            return Util.innerGetMaster(en);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static EntityObjectInfo innerGetMaster(EntityObjectInfo en) {
        PropertyCollection c = en.getInheritedNoDuplicatedProperties();
        int i = 0;
        while (i < c.size()) {
            RelationshipInfo rs = Util.getRelationshipInfo(c, i);
            if (Util.isEntryEntity(en, rs)) {
                return rs.getClientObject();
            }
            ++i;
        }
        return null;
    }

    private static RelationshipInfo getRelationshipInfo(PropertyCollection c, int i) {
        PropertyInfo p = c.get(i);
        if (p instanceof LinkPropertyInfo) {
            return ((LinkPropertyInfo)p).getRelationship();
        }
        return null;
    }

    private static boolean isEntryEntity(EntityObjectInfo en, RelationshipInfo rs) {
        if (rs == null) {
            return false;
        }
        return CardinalityType.isUnbounded((CardinalityType)rs.getSupplierCardinality()) && en.equals((Object)rs.getSupplierObject());
    }

    public static String trim(String s) {
        if (s.length() <= 30) {
            return s;
        }
        return String.valueOf(s.substring(s.length() - 28)) + "..";
    }

    public static Set<String> getMultiLangProperties(Context ctx, BOSObjectType type) {
        Set<String> properties;
        Map<BOSObjectType, Set<String>> map = multilang_properties.get(ctx.getAIS());
        if (map == null) {
            multilang_properties.put(ctx.getAIS(), new ConcurrentHashMap());
            map = multilang_properties.get(ctx.getAIS());
        }
        if ((properties = map.get(type)) != null) {
            return properties;
        }
        map.put(type, Util.loadMultiLangProperties(ctx, type));
        return map.get(type);
    }

    private static Set<String> loadMultiLangProperties(Context ctx, BOSObjectType type) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        PropertyCollection all_properties = loader.getEntity(type).getInheritedNoDuplicatedProperties();
        HashSet<String> properties = new HashSet<String>(4);
        int i = 0;
        while (i < all_properties.size()) {
            PropertyInfo p = all_properties.get(i);
            if (p instanceof OwnPropertyInfo && ((OwnPropertyInfo)p).isMultilingual()) {
                properties.add(p.getName());
            }
            ++i;
        }
        if (properties.size() == 0) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(properties);
    }

    public static EntityViewInfo generateEntityView(List<String> judgeFields, Map<String, Object> data, Map<String, Setter> schema) {
        EntityViewInfo view = new EntityViewInfo();
        Util.setSelector(schema, view);
        Util.setFilter(judgeFields, data, view);
        return view;
    }

    private static void setSelector(Map<String, Setter> schema, EntityViewInfo view) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        for (String s : schema.keySet()) {
            Setter setter = schema.get(s);
            if (!(setter instanceof EntriesSetter)) continue;
            Util.appendEntrySelectors(selector, s, (EntriesSetter)setter);
        }
        view.setSelector(selector);
    }

    private static void appendEntrySelectors(SelectorItemCollection selector, String s, EntriesSetter entrySetter) {
        selector.add(String.valueOf(s) + ".*");
        Map<String, Setter> entrySchema = SchemaCache.getSchema(EasThreadParamUtil.getCtx().getAIS(), entrySetter.getBostype());
        for (String s2 : entrySchema.keySet()) {
            if (!(entrySchema.get(s2) instanceof EntriesSetter)) continue;
            selector.add(String.valueOf(s) + "." + s2 + ".*");
        }
    }

    private static void setFilter(List<String> judgeFields, Map<String, Object> data, EntityViewInfo view) {
        FilterInfo filter = new FilterInfo();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < judgeFields.size()) {
            FilterItemInfo filterInfo;
            String compareExpr;
            if (i > 0) {
                sb.append(" and ");
            }
            if (data.get(compareExpr = judgeFields.get(i)) instanceof Map) {
                String value;
                Map lanuage = (Map)data.get(compareExpr);
                if (lanuage.get("zh_CN") != null) {
                    value = D.s(lanuage.get("zh_CN"));
                } else if (lanuage.get("zh_TW") != null) {
                    value = D.s(lanuage.get("zh_TW"));
                } else if (lanuage.get("en_US") != null) {
                    value = D.s(lanuage.get("en_US"));
                } else {
                    throw new IscBizException("\u591a\u8bed\u8a00\u5b57\u6bb5 [" + compareExpr + "]\u7684\u503c\u4e3a\u7a7a");
                }
                filterInfo = new FilterItemInfo(compareExpr, (Object)value, CompareType.EQUALS);
            } else {
                filterInfo = new FilterItemInfo(compareExpr, data.get(compareExpr), CompareType.EQUALS);
            }
            filter.getFilterItems().add(filterInfo);
            sb.append("#").append(i);
            ++i;
        }
        filter.setMaskString(sb.toString());
        view.setFilter(filter);
    }

    public static String getOql(List<String> judgeFields, Map<String, Object> data) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < judgeFields.size()) {
            if (i == 0) {
                sb.append("where ");
            }
            if (i > 0) {
                sb.append(" and ");
            }
            String judgeField = judgeFields.get(i);
            sb.append(judgeField);
            sb.append(" = '");
            String judgeValue = D.s((Object)data.get(judgeField));
            if (judgeValue == null) {
                throw new IscBizException("judgeField : " + judgeField + " \u7684\u503c\u4e3a\u7a7a");
            }
            sb.append(judgeValue);
            sb.append("'");
            ++i;
        }
        return sb.toString();
    }

    public static ICoreBase createFinder(Context ctx, String fullName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo en = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)fullName));
        try {
            return (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)en.getType());
        }
        catch (BOSException e) {
            throw EasSideError.META_ERROR.create((Throwable)e, new String[]{fullName, e.getMessage()});
        }
    }

    public static void checkJudgeFields(Map<String, Object> data, Map<String, List<String>> judgeFields) {
        if (judgeFields.get("$").size() == 0) {
            throw new IscBizException("\u5355\u636e\u6ca1\u6709\u914d\u7f6e\u5019\u9009\u952e");
        }
    }

    public static Context generateBosCtx(ConnectorContext ctx, String proxy_user) {
        try {
            return Util.innerGenerateContext(ctx, proxy_user);
        }
        catch (BOSException e) {
            throw EasSideError.UNKNOWN_ERROR.wrap((Throwable)e);
        }
    }

    private static Context innerGenerateContext(ConnectorContext ctx, String proxy_user) throws BOSException {
        EasContext easContext = (EasContext)ctx;
        String dataCenter = easContext.getDataCenter();
        String userId = null;
        String orgId = null;
        if (StringUtils.isEmpty((String)proxy_user)) {
            userId = easContext.getUserId();
        } else {
            if (proxy_user.contains("@")) {
                String[] split = Util.getUserAndOrg(proxy_user);
                proxy_user = split[0];
                orgId = split[1];
            }
            userId = Util.getUserId(proxy_user, dataCenter, userId);
        }
        return Ctx.getContext((String)dataCenter, (String)userId, orgId, null);
    }

    public static String getUserId(String proxy_user, String dataCenter, String userId) throws BOSException {
        String sql = "select fid from T_PM_USER where fnumber=?";
        ArrayList result = SQL.executeQuery((String)dataCenter, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{proxy_user});
        if (result.size() > 0) {
            userId = (String)((Map)result.get(0)).get("fid");
        } else {
            sql = "select fid from T_PM_USER where fid=?";
            result = SQL.executeQuery((String)dataCenter, (String)sql, (int[])new int[]{12}, (Object[])new Object[]{proxy_user});
            if (result.size() > 0) {
                userId = (String)((Map)result.get(0)).get("fid");
            } else {
                throw new BOSException("\u6839\u636e\u4ee3\u7406\u7528\u6237[" + proxy_user + "]\u627e\u4e0d\u5230\u5bf9\u5e94\u7684userId");
            }
        }
        return userId;
    }

    public static String[] getUserAndOrg(String proxy_user) throws BOSException {
        String[] split = proxy_user.split("@");
        if (split.length != 2) {
            throw new BOSException("\u4ee3\u7406\u7528\u6237\u4e0d\u5408\u6cd5\uff1a" + proxy_user);
        }
        return split;
    }

    public static void testCallbackIerp(String dataCenter, String ierpUrl) {
        try {
            ConnectorCallback.call((String)dataCenter, (String)"test", new HashMap());
        }
        catch (Exception e) {
            String message = "EAS\u53cd\u8c03\u82cd\u7a79\u65f6\u62a5\u9519\uff0curl:" + ierpUrl + ",\u9519\u8bef\u5185\u5bb9:" + e.getMessage();
            throw new IscBizException(message, (Throwable)e);
        }
    }

    public static List<String> getDataCenters() {
        String[][] aisInfo;
        if (datacenters.size() == 0 && (aisInfo = SchedulerUtils.getDataCenterInfos()) != null) {
            datacenters = Util.getDataCenters(aisInfo);
        }
        return datacenters;
    }

    private static List<String> getDataCenters(String[][] aisInfo) {
        ArrayList<String> datacenters = new ArrayList<String>();
        int i = 0;
        while (i < aisInfo.length) {
            String jndiUrl = aisInfo[i][2];
            if (jndiUrl == null || !jndiUrl.endsWith("_Query")) {
                String dataCenter = aisInfo[i][0];
                datacenters.add(dataCenter);
            }
            ++i;
        }
        return datacenters;
    }

    public static void checkPermit(Map<String, Object> params, String dataCenter) throws BOSException {
        String key = EasContextFactory.getDeployKey(dataCenter);
        String timeStr = ACL.decrypt(D.s((Object)params.get("secret")), key);
        long now = System.currentTimeMillis();
        if (Long.valueOf(timeStr) < now - 300000L) {
            throw new IscBizException("eas \u5f53\u524d\u670d\u52a1\u5668\u65f6\u95f4\u4e3a: " + now + ",\u800c\u82cd\u7a79\u4f20\u8fc7\u6765\u7684\u65f6\u95f4\u89e3\u5bc6\u540e\u4e3a\uff1a" + timeStr + ",\u8d85\u8fc7\u4e865\u5206\u949f\uff0c\u8bf7\u540c\u6b65\u4e24\u4e2a\u670d\u52a1\u5668\u65f6\u95f4\u6216\u68c0\u67e5\u8f93\u5165\u7684eas\u7ba1\u7406\u5458\u5bc6\u7801\u662f\u5426\u6b63\u786e");
        }
    }

    public static void unPackExceptionAndThrow(Exception e) {
        if (e.getCause() instanceof EJBException && e.getCause().getCause() instanceof UndeclaredThrowableException && e.getCause().getCause().getCause() instanceof InvocationTargetException && e.getCause().getCause().getCause().getCause() instanceof Exception) {
            throw D.e((Throwable)e.getCause().getCause().getCause().getCause());
        }
        if (e.getCause() != null && e.getCause().getCause() != null && e.getCause().getCause().getCause() != null) {
            throw D.e((Throwable)e.getCause().getCause().getCause());
        }
    }

    public static Throwable unpackageEx(Exception e) {
        if (e.getCause() instanceof EJBException && e.getCause().getCause() instanceof UndeclaredThrowableException && e.getCause().getCause().getCause() instanceof InvocationTargetException && e.getCause().getCause().getCause().getCause() instanceof Exception) {
            return D.e((Throwable)e.getCause().getCause().getCause().getCause());
        }
        return e;
    }

    public static void setValues(String dataCenter, CoreBaseInfo info, Map<String, Object> data, boolean addNew, Map<String, IObjectValue> entries) {
        Map<String, Setter> schema = SchemaCache.getSchema(dataCenter, info.getBOSType());
        for (Map.Entry<String, Object> e : data.entrySet()) {
            String property = e.getKey();
            if (!addNew && "id".equals(property)) continue;
            AbstractSetter setter = (AbstractSetter)schema.get(property);
            if (setter != null) {
                setter.setValue((IObjectValue)info, property, e.getValue(), entries);
                continue;
            }
            if (property.startsWith("$") || property.startsWith("#")) continue;
            IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)Ctx.getShadowContext((String)dataCenter));
            EntityObjectInfo en = loader.getEntity(info.getBOSType());
            throw new IscBizException("\u5b9e\u4f53[" + en.getAlias() + "](bostype:" + info.getBOSType() + ",\u5168\u540d:" + en.getFullName() + ")\u4e0d\u5b58\u5728\u540d\u79f0\u4e3a\"" + property + "\"\u7684\u5c5e\u6027");
        }
    }

    public static CoreBaseInfo newInstance(ICoreBase fn) {
        EntityObjectInfo entityObjectInfo = MetaDataLoaderFactory.getMetaDataLoader((Context)fn.getContext()).getEntity(fn.getType());
        String clzObjectValueName = entityObjectInfo.getObjectValueClass();
        CoreBaseInfo info = (CoreBaseInfo)ReflectionUtil.newInstance((String)clzObjectValueName);
        if (info instanceof CoreBillBaseCustomInfo) {
            ((CoreBillBaseCustomInfo)info).setBOSType(fn.getType());
        } else if (info instanceof DataBaseCustomInfo) {
            ((DataBaseCustomInfo)info).setBOSType(fn.getType());
        }
        return info;
    }

    public static CoreBaseInfo constructInfo(Context ctx, String entityName, Map<String, Object> data, List<String> judgeFields) {
        ICoreBase fn = Util.createFinder(ctx, entityName);
        CoreBaseInfo info = Util.retrieveInfoByPk(data, judgeFields, fn);
        if (info == null) {
            info = Util.newInstance(fn);
        }
        HashMap<String, IObjectValue> entries = new HashMap<String, IObjectValue>();
        Util.setValues(ctx.getAIS(), info, data, true, entries);
        return info;
    }

    public static CoreBaseInfo retrieveInfoByPk(Map<String, Object> data, List<String> judgeFields, ICoreBase finder) {
        CoreBaseInfo info;
        Map<String, Setter> schema = SchemaCache.getSchema(finder.getContext().getAIS(), finder.getType());
        EntityViewInfo view = null;
        if (data.containsKey("id")) {
            ArrayList<String> judgeId = new ArrayList<String>();
            judgeId.add("id");
            view = Util.generateEntityView(judgeId, data, schema);
            try {
                info = Util.getCoreBaseInfo(finder, view);
            }
            catch (Exception ignore) {
                info = null;
            }
        } else {
            info = null;
        }
        if (info == null && judgeFields != null && judgeFields.size() > 0) {
            view = Util.generateEntityView(judgeFields, data, schema);
            info = Util.getCoreBaseInfo(finder, view);
        }
        return info;
    }

    private static CoreBaseInfo getCoreBaseInfo(ICoreBase finder, EntityViewInfo view) {
        CoreBaseCollection collection;
        block4: {
            try {
                collection = finder.getCollection(view);
                if (collection.size() != 0) break block4;
                return null;
            }
            catch (BOSException e) {
                throw EasSideError.BIZ_ERROR.wrap((Throwable)e);
            }
        }
        if (collection.size() == 1) {
            return collection.get(0);
        }
        throw new IscBizException("\u6839\u636e\u8fc7\u6ee4\u6761\u4ef6\u201c" + view + "\u201d\u627e\u5230\u4e86\u591a\u6761\u8bb0\u5f55");
    }

    public static boolean isUserTableHasPwdType(String dataCenter) {
        Table table = TableUtil.getTable(dataCenter, "T_PM_USER");
        return table.hasField("fpasswordtype");
    }

    public static String getAlgorithm(String dataCenter, String fid) {
        if (!Util.isUserTableHasPwdType(dataCenter)) {
            return "MD5";
        }
        Connection cn = TableUtil.getConnection(dataCenter);
        try {
            String type = D.s((Object)DbUtil.executeScalar((Connection)cn, (String)("select fpasswordtype from T_PM_USER where fid = '" + fid + "'")));
            String algorithm = null;
            algorithm = "2".equals(type) ? "SHA-256" : ("4".equals(type) ? "SM3" : "MD5");
            String string = algorithm;
            return string;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)false);
        }
    }
}

