/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.connector.eas.meta;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.MetadataCleaner;
import com.kingdee.bos.dao.xml.impl.MetadataClearListener;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.service.job.util.Ctx;
import com.kingdee.bos.util.BOSObjectType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.isc.connector.eas.EasContext;
import kd.isc.connector.eas.e.GetEntityInfo;
import kd.isc.connector.eas.meta.AbstractSetter;
import kd.isc.connector.eas.meta.DataTypeParser;
import kd.isc.connector.eas.meta.Setter;
import kd.isc.iscb.util.except.IscBizException;

public class SchemaCache {
    private static final Map<String, Map<BOSObjectType, Map<String, Setter>>> cache = new ConcurrentHashMap<String, Map<BOSObjectType, Map<String, Setter>>>();

    static {
        MetadataCleaner.registerListener((MetadataClearListener)new MetadataClearListener(){

            public void clearAll() {
                EasContext.getErrLogger().warn((Object)"\u54cd\u5e94dep\u6e05\u9664\u7f13\u5b58\u8c03\u7528");
                cache.clear();
            }

            public void clear(String key) {
                EasContext.getErrLogger().warn((Object)"\u54cd\u5e94dep\u6e05\u9664\u7f13\u5b58\u8c03\u7528");
                cache.clear();
            }
        });
    }

    public static Map<String, Setter> getSchema(String dataCenter, BOSObjectType type) {
        Map<String, Setter> schema;
        Map<BOSObjectType, Map<String, Setter>> map = cache.get(dataCenter);
        if (map == null) {
            map = new ConcurrentHashMap<BOSObjectType, Map<String, Setter>>();
            cache.put(dataCenter, map);
        }
        if ((schema = map.get(type)) == null) {
            schema = SchemaCache.generateSchema(dataCenter, type);
            map.put(type, schema);
        }
        return schema;
    }

    private static Map<String, Setter> generateSchema(String dataCenter, BOSObjectType type) {
        Context ctx = Ctx.newShadowContext((String)dataCenter);
        IMetaDataLoader loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
        EntityObjectInfo en = loader.getEntity(type);
        HashMap<String, Setter> schema = new HashMap<String, Setter>();
        PropertyCollection properties = en.getInheritedNoDuplicatedProperties();
        int i = 0;
        while (i < properties.size()) {
            SchemaCache.findEachPropSetter(en, schema, properties, i);
            ++i;
        }
        return Collections.unmodifiableMap(schema);
    }

    public static void findEachPropSetter(EntityObjectInfo en, Map<String, Setter> schema, PropertyCollection properties, int i) {
        PropertyInfo p = properties.get(i);
        try {
            Map<String, Object> dataType = GetEntityInfo.getDataType(p, en);
            AbstractSetter setter = DataTypeParser.getSetter(dataType, p, en);
            schema.put(p.getName(), setter);
        }
        catch (Exception e) {
            throw new IscBizException("find entity[" + en.toString() + "] property[" + p + "]'s setter caught ex:", (Throwable)e);
        }
    }
}

