/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kd.isc.iscb.util.connector.client.RemoteContext;
import kd.isc.iscb.util.io.AbstractOutputStream;

public class RemoteOutputStream
extends AbstractOutputStream {
    private static final int MAX_SIZE = 0x400000;
    private RemoteContext ctx;
    private Map<String, Object> fileInfo;
    private byte[] buffer;
    private int count;
    private String taskId = UUID.randomUUID().toString().replace("-", "");
    private int index;
    private String attachmentId;
    private boolean isError = false;

    public RemoteOutputStream(RemoteContext ctx, Map<String, Object> fileInfo, int size) {
        this.ctx = ctx;
        this.fileInfo = fileInfo;
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        size = Math.min(0x400000, size);
        this.buffer = new byte[size];
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count >= this.buffer.length) {
            this.flushBuffer();
        }
        this.buffer[this.count++] = (byte)b;
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            this.savePartialContent();
            this.count = 0;
        }
    }

    private void savePartialContent() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", "save_partial_content");
        params.put("taskId", this.taskId);
        ++this.index;
        params.put("index", this.index);
        params.put("chunk", RemoteOutputStream.subBytes(this.buffer, 0, this.count));
        this.ctx.invoke(params);
    }

    private static byte[] subBytes(byte[] src, int begin, int length) {
        if (length == src.length) {
            return src;
        }
        byte[] bs = new byte[length];
        System.arraycopy(src, begin, bs, 0, length);
        return bs;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
    }

    @Override
    public void close() throws IOException {
        if (!this.isError) {
            this.flushBuffer();
            this.attachmentId = this.createAttachment();
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("$id", this.taskId);
            this.ctx.removeResult(params);
        }
    }

    private String createAttachment() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("command", "create_attachment");
        params.put("fileInfo", this.fileInfo);
        params.put("taskId", this.taskId);
        return (String)this.ctx.invoke(params);
    }

    @Override
    public String getAttachmentId() {
        return this.attachmentId;
    }

    @Override
    public void markError() {
        this.isError = true;
    }
}

