/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.client;

import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.connector.client.Field;

class RemoteResultSetMetaData
implements ResultSetMetaData {
    private Field[] fields;
    private Map<String, Integer> index;

    RemoteResultSetMetaData(List<Map<String, Object>> fields) {
        this.fields = new Field[fields.size()];
        this.index = new HashMap<String, Integer>(fields.size() * 2);
        int i = 0;
        while (i < fields.size()) {
            Field f;
            this.fields[i] = f = new Field(fields.get(i));
            this.index.put(f.getName(), i);
            ++i;
        }
    }

    public int getColumn(String columnLabel) {
        Integer i = this.index.get(columnLabel);
        if (i == null) {
            return -1;
        }
        return i + 1;
    }

    @Override
    public int getColumnCount() {
        return this.fields.length;
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return -1;
    }

    public Field getField(int column) {
        return this.fields[column - 1];
    }

    @Override
    public String getColumnLabel(int column) {
        return this.fields[column - 1].getName();
    }

    @Override
    public String getColumnName(int column) {
        return this.fields[column - 1].getName();
    }

    @Override
    public int getColumnType(int column) {
        return this.fields[column - 1].getSqlType();
    }

    @Override
    public int getPrecision(int column) {
        return this.fields[column - 1].getPrecision();
    }

    @Override
    public int getScale(int column) {
        return this.fields[column - 1].getScale();
    }

    @Override
    public int isNullable(int column) {
        return "_id".equals(this.getColumnName(column)) ? 0 : 1;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public String getCatalogName(int column) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public String getColumnClassName(int column) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public String getSchemaName(int column) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public String getColumnTypeName(int column) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public String getTableName(int column) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        return true;
    }

    @Override
    public boolean isCurrency(int column) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean isReadOnly(int column) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean isSearchable(int column) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean isSigned(int column) {
        throw new UnsupportedOperationException("TODO");
    }

    @Override
    public boolean isWritable(int column) {
        throw new UnsupportedOperationException("TODO");
    }
}

