/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.connector.server.e;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.isc.iscb.util.connector.server.CommandExecutor;
import kd.isc.iscb.util.connector.server.ConnectorContext;
import kd.isc.iscb.util.connector.server.Returns;
import kd.isc.iscb.util.connector.server.Util;
import kd.isc.iscb.util.connector.server.e.BinaryEncoder;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.DatabaseError;
import kd.isc.iscb.util.misc.Cipher;

public class ExecuteQuery
implements CommandExecutor {
    private static final int BATCH_BYTES;

    static {
        int batchSize = 1024000;
        try {
            String s = System.getenv("DB_PROXY_BATCH_BYTES");
            if (s != null && s.length() > 0) {
                batchSize = Integer.parseInt(s);
            }
        }
        catch (Throwable e) {
            batchSize = 1024000;
        }
        BATCH_BYTES = Math.max(batchSize, 128000);
    }

    @Override
    public String getCommand() {
        return "execute_query";
    }

    @Override
    public void exec(ConnectorContext ctx, Map<String, Object> params, Returns returns) {
        String text = D.s(params.get("sql"));
        String key = ctx.getKey();
        String sql = Cipher.decrypt(text, key);
        Util.checkPermission(ctx, sql, params, ConnectorContext.Operation.READ);
        Connection cn = ctx.getConnection();
        try {
            try {
                this.execute(cn, sql, params, returns);
            }
            catch (SQLException e) {
                throw DatabaseError.SQL_QUERY_FAILURE.wrap(e);
            }
        }
        finally {
            ctx.dispose(cn);
        }
    }

    private void execute(Connection cn, String sql, Map<String, Object> params, Returns returns) throws SQLException {
        List values = (List)params.get("values");
        if (values != null) {
            ExecuteQuery.execute(cn, sql, returns, values, (List)params.get("types"));
        } else {
            ExecuteQuery.execute(cn, sql, returns);
        }
    }

    private static void execute(Connection cn, String sql, Returns returns) throws SQLException {
        Statement smt = cn.createStatement();
        ResultSet rs = null;
        try {
            rs = smt.executeQuery(sql);
            ExecuteQuery.output(rs, returns);
        }
        finally {
            DbUtil.close(smt, rs);
        }
    }

    private static List<Object> getMeta(ResultSetMetaData meta) throws SQLException {
        ArrayList<Object> fields = new ArrayList<Object>();
        int i = 1;
        int j = meta.getColumnCount();
        while (i <= j) {
            HashMap<String, Object> field = new HashMap<String, Object>();
            field.put("name", ExecuteQuery.getColumnLabel(meta, i));
            field.put("sql_type", meta.getColumnType(i));
            field.put("precision", meta.getPrecision(i));
            field.put("scale", meta.getScale(i));
            field.put("nullable", meta.isNullable(i) != 0);
            fields.add(field);
            ++i;
        }
        return fields;
    }

    private static String getColumnLabel(ResultSetMetaData meta, int i) throws SQLException {
        String label = meta.getColumnLabel(i);
        if (label == null || label.length() == 0) {
            return String.valueOf(i);
        }
        return label;
    }

    private static void execute(Connection cn, String sql, Returns returns, List<Object> values, List<Integer> types) throws SQLException {
        PreparedStatement ps = cn.prepareStatement(sql);
        ResultSet rs = null;
        try {
            DbUtil.ensureParameters(values, types);
            DbUtil.setParameters(ps, values, types);
            ps.setFetchSize(100);
            rs = ps.executeQuery();
            ExecuteQuery.output(rs, returns);
        }
        finally {
            DbUtil.close(ps);
        }
    }

    private static void output(ResultSet rs, Returns returns) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        List<Object> fields = ExecuteQuery.getMeta(meta);
        ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
        int bytes = 0;
        long start_time = System.currentTimeMillis();
        while (rs.next()) {
            long diff = System.currentTimeMillis() - start_time;
            if (diff > 5000L || bytes >= BATCH_BYTES) {
                ExecuteQuery.outputResults(returns, fields, rows, true);
                bytes = 0;
                rows = new ArrayList();
                start_time = System.currentTimeMillis();
            }
            bytes += ExecuteQuery.readRow(rs, meta, rows);
        }
        ExecuteQuery.outputResults(returns, fields, rows, false);
    }

    private static int readRow(ResultSet rs, ResultSetMetaData meta, List<Map<String, Object>> rows) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>(meta.getColumnCount());
        int bytes = 4;
        int i = 1;
        int columnCount = meta.getColumnCount();
        while (i <= columnCount) {
            Object value = DbUtil.read(rs, i);
            String name = ExecuteQuery.getColumnLabel(meta, i);
            if (value instanceof byte[]) {
                BinaryEncoder encoder = BinaryEncoder.IMPL.get().select();
                row.put(name, encoder.encode((byte[])value));
            } else {
                row.put(name, value);
            }
            bytes += DbUtil.calcBytes(name, value);
            ++i;
        }
        rows.add(row);
        return bytes;
    }

    private static void outputResults(Returns returns, List<Object> fields, List<Map<String, Object>> rows, boolean hasMore) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("fields", fields);
        result.put("rows", rows);
        returns.setResult(result, hasMore);
    }
}

