/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Pair;

public final class DualHeapMap<K, V extends Comparable<V>>
implements Map<K, V> {
    private ArrayList<Node<K, V>> asc_heap;
    private ArrayList<Node<K, V>> desc_heap;
    private HashMap<K, Node<K, V>> map;
    private static final Comparator DESC_COMPARATOR = new Comparator(){

        @Override
        public <V extends Comparable<V>> int compareTo(V a, V b) {
            return -a.compareTo(b);
        }

        @Override
        public void setIndex(Node<?, ?> node, int index) {
            ((Node)node).desc_index = index;
        }

        @Override
        public int getIndex(Node<?, ?> node) {
            return ((Node)node).desc_index;
        }
    };
    private static final Comparator ASC_COMPARATOR = new Comparator(){

        @Override
        public <V extends Comparable<V>> int compareTo(V a, V b) {
            return a.compareTo(b);
        }

        @Override
        public void setIndex(Node<?, ?> node, int index) {
            ((Node)node).asc_index = index;
        }

        @Override
        public int getIndex(Node<?, ?> node) {
            return ((Node)node).asc_index;
        }
    };

    public DualHeapMap() {
        this(16);
    }

    public DualHeapMap(int initCapacity) {
        this.asc_heap = new ArrayList(initCapacity);
        this.desc_heap = new ArrayList(initCapacity);
        this.map = new HashMap(initCapacity << 1);
    }

    @Override
    public void clear() {
        this.asc_heap.clear();
        this.desc_heap.clear();
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Node<K, V> node : this.asc_heap) {
            if (!DualHeapMap.equals(((Node)node).value, value)) continue;
            return true;
        }
        return false;
    }

    private static boolean equals(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> set = new HashSet<Map.Entry<K, V>>(this.map.size());
        for (Node<K, V> node : this.asc_heap) {
            set.add(new Pair<Object, Comparable>(((Node)node).key, ((Node)node).value));
        }
        return set;
    }

    @Override
    public V get(Object key) {
        Node<K, V> node = this.map.get(key);
        return (V)(node == null ? null : ((Node)node).value);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), (V)((Comparable)e.getValue()));
        }
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        ArrayList<Comparable> list = new ArrayList<Comparable>(this.asc_heap.size());
        for (Node<K, V> node : this.asc_heap) {
            list.add(((Node)node).value);
        }
        return list;
    }

    private static <K, V extends Comparable<V>> boolean shiftL(ArrayList<Node<K, V>> list, int i, Comparator c) {
        Node<K, V> current = list.get(i);
        int index = i;
        while (index > 0) {
            int j = index - 1 >> 1;
            Node<K, V> node = list.get(j);
            if (c.compareTo(((Node)current).value, ((Node)node).value) > 0) break;
            DualHeapMap.set(list, index, node, c);
            index = j;
        }
        DualHeapMap.set(list, index, current, c);
        return index != i;
    }

    private static <K, V extends Comparable<V>> boolean shiftR(ArrayList<Node<K, V>> list, int i, Comparator c) {
        Node<K, V> current = list.get(i);
        int index = i;
        int j = (index << 1) + 1;
        int size = list.size();
        while (j < size) {
            Node<K, V> node2;
            Node<K, V> node = list.get(j);
            if (j + 1 < size && c.compareTo(((Node)(node2 = list.get(j + 1))).value, ((Node)node).value) < 0) {
                ++j;
                node = node2;
            }
            if (c.compareTo(((Node)current).value, ((Node)node).value) < 0) break;
            DualHeapMap.set(list, index, node, c);
            index = j;
            j = (index << 1) + 1;
        }
        DualHeapMap.set(list, index, current, c);
        return index != i;
    }

    private static <K, V extends Comparable<V>> void set(ArrayList<Node<K, V>> list, int index, Node<K, V> node, Comparator c) {
        list.set(index, node);
        c.setIndex(node, index);
    }

    private static <K, V extends Comparable<V>> int add(ArrayList<Node<K, V>> list, Node<K, V> node, Comparator c) {
        int index = list.size();
        list.add(node);
        c.setIndex(node, index);
        return index;
    }

    @Override
    public V put(K key, V value) {
        Object original = this.remove(key);
        Node<K, V> node = new Node<K, V>(key, value);
        this.map.put(((Node)node).key, node);
        this.push(this.asc_heap, node, ASC_COMPARATOR);
        this.push(this.desc_heap, node, DESC_COMPARATOR);
        return (V)original;
    }

    private void push(ArrayList<Node<K, V>> list, Node<K, V> node, Comparator c) {
        int i = DualHeapMap.add(list, node, c);
        DualHeapMap.shiftL(list, i, c);
    }

    private static <K, V extends Comparable<V>> Node<K, V> removeTail(ArrayList<Node<K, V>> list) {
        int i = list.size() - 1;
        return list.remove(i);
    }

    @Override
    public V remove(Object key) {
        Node<K, V> node = this.map.remove(key);
        if (node == null) {
            return null;
        }
        this.moveTail(this.asc_heap, node, ASC_COMPARATOR);
        this.moveTail(this.desc_heap, node, DESC_COMPARATOR);
        for (Node<K, V> o : this.asc_heap) {
            if (this.desc_heap.contains(o)) continue;
            throw new IscBizException();
        }
        for (Node<K, V> o : this.desc_heap) {
            if (this.asc_heap.contains(o)) continue;
            throw new IscBizException();
        }
        return (V)((Node)node).value;
    }

    private void moveTail(ArrayList<Node<K, V>> list, Node<K, V> removed, Comparator c) {
        Node<K, V> tail = DualHeapMap.removeTail(list);
        int i = c.getIndex(removed);
        if (tail != removed) {
            DualHeapMap.set(list, i, tail, c);
            if (!DualHeapMap.shiftR(list, i, c)) {
                DualHeapMap.shiftL(list, i, c);
            }
        }
    }

    public K ascTop() {
        return (K)((Node)this.asc_heap.get(0)).key;
    }

    public K descTop() {
        return (K)((Node)this.desc_heap.get(0)).key;
    }

    private static interface Comparator {
        public <V extends Comparable<V>> int compareTo(V var1, V var2);

        public void setIndex(Node<?, ?> var1, int var2);

        public int getIndex(Node<?, ?> var1);
    }

    private static class Node<K, V extends Comparable<V>> {
        private K key;
        private V value;
        private int asc_index;
        private int desc_index;

        Node(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return this.key + ":" + this.value + "@" + this.asc_index + "." + this.desc_index;
        }
    }
}

