/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.data;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class SingletonContainer<K, V> {
    private ConcurrentHashMap<K, V> singletons = new ConcurrentHashMap();
    private Factory<K, V> factory;

    public SingletonContainer(Factory<K, V> factory) {
        this.factory = factory;
    }

    public V get(K key) {
        V value = this.singletons.get(key);
        if (value == null) {
            value = this.innerCreate(key);
        }
        return value;
    }

    private synchronized V innerCreate(K key) {
        V value = this.singletons.get(key);
        if (value != null) {
            return value;
        }
        value = this.factory.create(key);
        this.singletons.put(key, value);
        return value;
    }

    public V remove(K key) {
        return this.singletons.remove(key);
    }

    public void visit(Visitor<K, V> visitor) {
        Iterator<Map.Entry<K, V>> it = this.singletons.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<K, V> e = it.next();
            Action a = visitor.visit(e);
            a.afterVisit(it);
        }
    }

    public static enum Action {
        Remove{

            @Override
            void afterVisit(Iterator<?> it) {
                it.remove();
            }
        }
        ,
        NOP{

            @Override
            void afterVisit(Iterator<?> it) {
            }
        };


        abstract void afterVisit(Iterator<?> var1);
    }

    public static interface Factory<K, V> {
        public V create(K var1);
    }

    public static interface Visitor<K, V> {
        public Action visit(Map.Entry<K, V> var1);
    }
}

