/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.db.type;

import java.sql.Connection;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.Table;

public class SqlServerDbType
implements DbType {
    @Override
    public String getDataType(Column c) {
        int length = c.getPrecision();
        switch (c.getOrginalSqlType()) {
            case -6: {
                return "tinyint";
            }
            case 5: {
                return "smallint";
            }
            case 4: {
                return "int";
            }
            case -5: {
                return "bigint";
            }
            case -4: 
            case 2004: {
                return "IMAGE";
            }
            case -1: 
            case 2005: {
                return "TEXT";
            }
            case -16: 
            case 2011: {
                return "NTEXT";
            }
            case -2: {
                if (length <= 4000) {
                    return "BINARY(" + length + ")";
                }
                return "IMAGE";
            }
            case -3: {
                if (length <= 4000) {
                    return "VARBINARY(" + length + ")";
                }
                return "IMAGE";
            }
            case 12: {
                if (length <= 4000) {
                    return "VARCHAR(" + length + ")";
                }
                return "TEXT";
            }
            case -9: {
                if (length <= 4000) {
                    return "NVARCHAR(" + length + ")";
                }
                return "NTEXT";
            }
            case 1: {
                return "CHAR(" + length + ")";
            }
            case -15: {
                return "NCHAR(" + length + ")";
            }
            case -7: {
                return "BIT";
            }
            case 93: {
                return "DATETIME";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 2: 
            case 3: {
                return "decimal(" + length + "," + c.getScale() + ")";
            }
            case 6: 
            case 7: 
            case 8: {
                return "FLOAT";
            }
            case -8: {
                return "BINARY(16)";
            }
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString("\u4e0d\u652f\u6301\u6570\u636e\u7c7b\u578b\uff08%s\uff09", "SqlServerDbType_1", "isc-iscb-util", new Object[0]), c.getOrginalSqlType()));
    }

    @Override
    public String qualifyTableName(String tableName) {
        return tableName;
    }

    @Override
    public String qualifyColumnName(String columnName) {
        return columnName;
    }

    @Override
    public char getQuotChar() {
        return '\"';
    }

    @Override
    public void setBigQuery(Connection src) {
    }

    @Override
    public void unsetBigQuery(Connection src) {
    }

    @Override
    public String emtpyTableTestSQL(Table table) {
        return "SELECT TOP 1 1 FROM " + table.getQuotedName();
    }
}

