/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.isc.iscb.util.dt.DataType;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.VariableScope;
import kd.isc.iscb.util.flow.core.i.model.AbstractElement;
import kd.isc.iscb.util.flow.core.i.model.FlowImpl;
import kd.isc.iscb.util.flow.core.i.model.VariableImpl;
import kd.isc.iscb.util.script.misc.Consts;

public abstract class AbstractVariableScope
extends AbstractElement
implements VariableScope {
    private Map<String, VariableImpl> variables = new HashMap<String, VariableImpl>();
    private Map<String, VariableImpl> var_addr_map = new HashMap<String, VariableImpl>();

    AbstractVariableScope(FlowImpl flow, String id, String title) {
        super(flow, id, title);
    }

    AbstractVariableScope(String id, String title) {
        super(id, title);
    }

    @Override
    public final VariableImpl getVariable(String name) {
        return this.variables.get(name);
    }

    public final Map<String, VariableImpl> getVariables() {
        return this.variables;
    }

    @Override
    public final VariableImpl findVariable(String name) {
        return this.var_addr_map.get(name);
    }

    @Override
    public final VariableImpl retrieveVariable(String name) {
        VariableImpl v = this.var_addr_map.get(name);
        if (v != null) {
            return v;
        }
        throw new IscBizException("Variable '" + name + "' doesn't exist in '" + this + "'!");
    }

    public final VariableImpl addVariable(String id, String title, String name, DataType type) {
        if (this.variables.containsKey(name)) {
            throw new IscBizException("Variable '" + name + "' exists in '" + this + "'!");
        }
        if (title == null || title.length() == 0) {
            title = name;
        }
        VariableImpl var = new VariableImpl(id, title, name, type, this);
        this.variables.put(name, var);
        return var;
    }

    public final void register(VariableImpl v) {
        String name = v.getName();
        if (this.variables.containsKey(name)) {
            throw new IscBizException("Variable '" + name + "' exists in '" + this + "'!");
        }
        this.variables.put(name, v);
    }

    @Override
    void compile() {
        this.calcAvailableVars();
        this.solidifyLocalVars();
    }

    private void calcAvailableVars() {
        Map<String, VariableImpl> other = this.getOtherAvailableVariables();
        if (other != null) {
            this.var_addr_map.putAll(other);
        }
        this.var_addr_map.putAll(this.variables);
        this.var_addr_map = Collections.unmodifiableMap(this.var_addr_map);
    }

    private void solidifyLocalVars() {
        this.variables = this.variables.size() == 0 ? Consts.EMPTY_MAP : Collections.unmodifiableMap(this.variables);
    }

    public final Map<String, VariableImpl> getAvailableVariables() {
        return this.var_addr_map;
    }

    abstract Map<String, VariableImpl> getOtherAvailableVariables();
}

