/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.flow.core.i.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.isc.iscb.util.dt.CollectionDataType;
import kd.isc.iscb.util.flow.core.i.model.FlowImpl;
import kd.isc.iscb.util.flow.core.i.model.VariableImpl;
import kd.isc.iscb.util.flow.core.i.runtime.DataAreaImpl;

public final class Output {
    private VariableImpl[] from;
    private VariableImpl[] to;

    public Output(VariableImpl[] to) {
        this.to = (VariableImpl[])to.clone();
    }

    public Output(VariableImpl[] from, VariableImpl[] to) {
        this.from = (VariableImpl[])from.clone();
        this.to = (VariableImpl[])to.clone();
    }

    public void output(DataAreaImpl mem) {
        DataAreaImpl parent = mem.getParent();
        if (this.from != null) {
            this.outputValuesFromSubNodes(mem, parent);
        } else {
            this.outputValuesFromSubFlow(mem, parent);
        }
    }

    private void outputValuesFromSubNodes(DataAreaImpl mem, DataAreaImpl parent) {
        int i = 0;
        while (i < this.from.length) {
            VariableImpl from = this.from[i];
            VariableImpl to = this.to[i];
            Object value = mem.getAt(from);
            this.put2parent(parent, value, to);
            ++i;
        }
    }

    private void outputValuesFromSubFlow(DataAreaImpl mem, DataAreaImpl parent) {
        FlowImpl subFlow = mem.getFlow();
        List<VariableImpl> from = subFlow.getOutputVariables();
        int i = 0;
        while (i < from.size()) {
            Object value = mem.getAt(from.get(i));
            VariableImpl to = this.to[i];
            parent.setAt(to, value);
            ++i;
        }
    }

    private void put2parent(DataAreaImpl parent, Object value, VariableImpl to) {
        if (to.getType() instanceof CollectionDataType) {
            if (value instanceof Collection) {
                throw new IllegalArgumentException("Value's type is Collection. value = " + value);
            }
            ArrayList<Object> c = (ArrayList<Object>)parent.getAt(to);
            if (c == null) {
                c = new ArrayList<Object>(1);
            }
            c.add(value);
            parent.setAt(to, c);
        } else {
            parent.setAt(to, value);
        }
    }

    public VariableImpl[] getTo() {
        return (VariableImpl[])this.to.clone();
    }

    public VariableImpl[] getFrom() {
        return (VariableImpl[])this.from.clone();
    }
}

