/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.script.encoding.Murmur;

public class StringUtil {
    public static String reverse(String s) {
        if (s == null || s.length() < 2) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length());
        int i = s.length() - 1;
        while (i >= 0) {
            sb.append(s.charAt(i));
            --i;
        }
        return sb.toString();
    }

    public static String trim(Object o, int maxLength) {
        if (o == null) {
            return null;
        }
        if (o instanceof Throwable) {
            return StringUtil.trim(StringUtil.toString((Throwable)o), maxLength);
        }
        return StringUtil.trim(o.toString(), maxLength);
    }

    public static String trim(String s, int maxLength) {
        if (s == null) {
            return s;
        }
        if ((s = s.trim()).length() <= maxLength) {
            return s;
        }
        int i = (s = s.substring(0, maxLength - 3)).lastIndexOf(10);
        if (i < 0) {
            return String.valueOf(s) + "\u2026";
        }
        return String.valueOf(s.substring(0, i).trim()) + " \u2026";
    }

    public static String getMessage(Throwable e) {
        String s = D.s(e.getMessage());
        if (s == null) {
            s = e.getClass().getName();
        } else if (e instanceof UnknownHostException) {
            s = String.format(ResManager.loadKDString("\u65e0\u6cd5\u786e\u5b9a\u4e3b\u673a\uff08%s\uff09\u7684IP\u5730\u5740\u3002", "StringUtil_3", "isc-iscb-util", new Object[0]), s);
        }
        return StringUtil.replaceZeroChar(s);
    }

    public static byte[] utf8(String s) {
        return s.getBytes(D.UTF_8);
    }

    public static String utf8(byte[] bytes) {
        return new String(bytes, D.UTF_8);
    }

    public static boolean isEmpty(String s) {
        return kd.isc.iscb.util.script.misc.StringUtil.isEmpty(s);
    }

    public static String trim(String s, String defaultValue) {
        return kd.isc.iscb.util.script.misc.StringUtil.trim(s, defaultValue);
    }

    public static String rtrim(String s, char c) {
        return kd.isc.iscb.util.script.misc.StringUtil.rtrim(s, c);
    }

    public static String join(Collection<?> c) {
        return kd.isc.iscb.util.script.misc.StringUtil.join(c);
    }

    public static String join(Collection<?> c, String seperator) {
        return kd.isc.iscb.util.script.misc.StringUtil.join(c, seperator);
    }

    public static String join(Object[] c) {
        return kd.isc.iscb.util.script.misc.StringUtil.join(c);
    }

    public static String join(Object[] c, String seperator) {
        return kd.isc.iscb.util.script.misc.StringUtil.join(c, seperator);
    }

    public static boolean equals(String s1, String s2) {
        return kd.isc.iscb.util.script.misc.StringUtil.equals(s1, s2);
    }

    public static boolean endsWith(CharSequence sb, char c) {
        return kd.isc.iscb.util.script.misc.StringUtil.endsWith(sb, c);
    }

    public static int count(String text, String str) {
        return kd.isc.iscb.util.script.misc.StringUtil.count(text, str);
    }

    public static String[] split(String s, char c) {
        return kd.isc.iscb.util.script.misc.StringUtil.split(s, c);
    }

    public static Map<String, Object> parse(String queryString) {
        return kd.isc.iscb.util.script.misc.StringUtil.parse(queryString);
    }

    public static String toLowerCase(String s) {
        return kd.isc.iscb.util.script.misc.StringUtil.toLowerCase(s);
    }

    public static String toUpperCase(String s) {
        return kd.isc.iscb.util.script.misc.StringUtil.toUpperCase(s);
    }

    public static String toString(Throwable e) {
        if (e == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            String code;
            PrintStream ps = new PrintStream((OutputStream)baos, true, "UTF-8");
            if (e instanceof IscBizException && (code = ((IscBizException)e).getCode()) != null) {
                ps.append("\r\n").append(ResManager.loadKDString("\u9519\u8bef\u7801\uff1a", "StringUtil_4", "isc-iscb-util", new Object[0])).append(code).append("\r\n");
            }
            e.printStackTrace(ps);
            ps.flush();
            String s = baos.toString("utf-8");
            String msg = String.valueOf(StringUtil.getCascadeMessage(e)) + "\r\n\r\n" + Thread.currentThread().getName() + "\r\n" + s.replace(StringUtil.getMessage(e), "");
            return StringUtil.replaceZeroChar(msg);
        }
        catch (UnsupportedEncodingException err) {
            throw D.e(err);
        }
    }

    public static byte[] toBytes(UUID uuid) {
        if (uuid == null) {
            return null;
        }
        byte[] bytes = new byte[16];
        long mst = uuid.getMostSignificantBits();
        int i = 7;
        while (i >= 0) {
            bytes[i] = (byte)(0xFFL & mst);
            mst >>>= 8;
            --i;
        }
        long lst = uuid.getLeastSignificantBits();
        int i2 = 15;
        while (i2 >= 8) {
            bytes[i2] = (byte)(0xFFL & lst);
            lst >>>= 8;
            --i2;
        }
        return bytes;
    }

    public static String getCascadeMessage(Throwable err) {
        StringBuilder s = new StringBuilder();
        HashSet<Throwable> visited = new HashSet<Throwable>();
        Throwable e = err;
        while (e != null && visited.add(e)) {
            String message;
            if ((e.getMessage() != null || !(e instanceof UndeclaredThrowableException) && !(e instanceof InvocationTargetException)) && s.indexOf(message = StringUtil.getMessage(e)) < 0) {
                if (s.length() > 0) {
                    s.append("\u3000\n// \u539f\u56e0\uff1a");
                }
                s.append(message);
            }
            e = e.getCause();
        }
        String msg = s.toString();
        return StringUtil.replaceZeroChar(msg);
    }

    public static String replaceZeroChar(String s) {
        if (s == null) {
            return s;
        }
        if (s.indexOf(0) < 0) {
            return s;
        }
        return s.replace('\u0000', ' ');
    }

    public static String hashMask(String s, int suffixLen) {
        if (s == null || s.length() < suffixLen) {
            return s;
        }
        return String.valueOf(Murmur.calc32(s)) + "_" + s.substring(s.length() - suffixLen);
    }
}

