/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.misc.mem.c;

import java.lang.reflect.Array;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.misc.mem.ClassSizeInfo;
import kd.isc.iscb.util.misc.mem.ObjectSizeCalculator;

public class ArrayClassSizeInfo
implements ClassSizeInfo {
    private final Class<?> clazz;
    private final Class<?> componentType;
    private final boolean isPrimitive;
    private final long elementSize;

    public ArrayClassSizeInfo(Class<?> clazz) {
        if (clazz.isArray()) {
            this.clazz = clazz;
            this.componentType = clazz.getComponentType();
            this.isPrimitive = this.componentType.isPrimitive();
            this.elementSize = this.isPrimitive ? ObjectSizeCalculator.getPrimitiveFieldSize(this.componentType) : (long)ObjectSizeCalculator.REFERENCE_SIZE;
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString("\u7c7b\uff08%s\uff09\u4e0d\u662f\u6570\u7ec4\u7c7b\u578b\u3002", "ArrayClassSizeInfo_2", "isc-iscb-util", new Object[0]), clazz.getName()));
        }
    }

    @Override
    public Class<?> forClass() {
        return this.clazz;
    }

    @Override
    public void visit(Object array, ObjectSizeCalculator calc, int level) {
        int length = Array.getLength(array);
        long arraySize = (long)ObjectSizeCalculator.ARRAY_HEADER_SIZE + (long)length * this.elementSize;
        calc.increaseSize(ObjectSizeCalculator.roundTo(arraySize, ObjectSizeCalculator.OBJECT_PADDING));
        if (!this.componentType.isPrimitive()) {
            this.visitComponents(array, length, calc, level + 1);
        }
    }

    private void visitComponents(Object array, int length, ObjectSizeCalculator calc, int level) {
        calc.checkLevel(level);
        switch (length) {
            case 0: {
                break;
            }
            case 1: {
                calc.visit(Array.get(array, 0), level);
                break;
            }
            default: {
                Object[] objectArray = (Object[])array;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object obj = objectArray[n2];
                    calc.visit(obj, level);
                    ++n2;
                }
                break block0;
            }
        }
    }
}

