/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.encoding;

import kd.isc.iscb.util.script.encoding.Encoding;

public class Hex
extends Encoding {
    private static byte[] hexChar = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static int[] bits = new int[256];

    static {
        int i = 0;
        while (i < 256) {
            Hex.bits[i] = 255;
            ++i;
        }
        i = 0;
        while (i <= 9) {
            Hex.bits[48 + i] = i;
            ++i;
        }
        i = 0;
        int j = 10;
        while (i <= 5) {
            Hex.bits[97 + i] = j;
            Hex.bits[65 + i] = j++;
            ++i;
        }
    }

    public static boolean isHexString(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f')) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isNumber(String s) {
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public byte[] encode(byte[] data) {
        byte[] buffer = new byte[data.length << 1];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            buffer[j++] = hexChar[data[i] >> 4 & 0xF];
            buffer[j++] = hexChar[data[i] & 0xF];
            ++i;
        }
        return buffer;
    }

    @Override
    public byte[] decode(byte[] data) {
        if ((data.length & 1) != 0) {
            throw new IllegalArgumentException("Invalid hex string!");
        }
        byte[] buffer = new byte[data.length >> 1];
        int i = 0;
        int j = 0;
        while (i < buffer.length) {
            int k = bits[data[j++]] << 4;
            if ((k += bits[data[j++]]) > 255) {
                throw new IllegalArgumentException("Invalid hex string!");
            }
            buffer[i] = (byte)k;
            ++i;
        }
        return buffer;
    }
}

