/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.advanced;

import java.util.Set;
import javax.script.ScriptContext;
import kd.isc.iscb.util.debugger.DebugCoordinator;
import kd.isc.iscb.util.script.LifeScriptContext;
import kd.isc.iscb.util.script.feature.control.advanced.Debuggable;
import kd.isc.iscb.util.script.parser.Program;

public final class DebugTrap {
    private final DebugCoordinator debugCoordinator;
    private final int _line;
    private boolean enabled;
    private final Object e;

    public DebugTrap(Object e, int line) {
        this.e = e;
        this._line = line;
        this.debugCoordinator = DebugCoordinator.REF.get();
    }

    public final Object get(ScriptContext ctx) {
        if (this.enabled && this.debugCoordinator.isDebuggerEnabled()) {
            this.handleBreakpoint(ctx);
        }
        return this.e;
    }

    final void handleBreakpoint(ScriptContext ctx) {
        LifeScriptContext xctx = (LifeScriptContext)ctx;
        Program p = xctx.getProgram();
        if (p != null) {
            Set<Integer> breakpoints = p.collectBreakpoints();
            this.debugCoordinator.handleBreakpoint(xctx, this._line, breakpoints);
        }
    }

    public Object directGetElement() {
        return this.e;
    }

    public boolean attachBreakpoint(int line) {
        if (this._line == line) {
            this.enabled = true;
            return true;
        }
        if (this.e instanceof Debuggable) {
            return ((Debuggable)this.e).attachBreakpoint(line);
        }
        return false;
    }

    public void detachBreakpoint(int line) {
        if (this._line == line) {
            this.enabled = false;
        }
        if (this.e instanceof Debuggable) {
            ((Debuggable)this.e).detachBreakpoint(line);
        }
    }

    public void collectBreakpoints(Set<Integer> breakpoints) {
        if (this.enabled) {
            breakpoints.add(this._line);
        }
        if (this.e instanceof Debuggable) {
            ((Debuggable)this.e).collectBreakpoints(breakpoints);
        }
    }

    public String toString() {
        return this.e == null ? "null" : this.e.toString();
    }

    public int line() {
        return this._line;
    }
}

