/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.loop;

import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json2;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.NotExpression;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.core.StopAnalyzeElements;
import kd.isc.iscb.util.script.misc.Const;

public class Throw
implements Constructor,
Identifier,
NotExpression,
StopAnalyzeElements {
    public static final Const<Boolean> DISABLE_CODED_MESSAGE = new Const<Boolean>(Boolean.FALSE);

    public String toString() {
        return this.name();
    }

    @Override
    public String name() {
        return "throw";
    }

    @Override
    public Object analyze(Statement statement, Constructor.Position pos) throws ScriptException {
        Object result = Util.getTail(statement, pos, 0);
        return this.createEvaluator(result);
    }

    private Object createEvaluator(final Object result) {
        return new Evaluator(){

            @Override
            public Object eval(ScriptContext ctx) {
                Object value = Util.eval(ctx, result);
                if (value instanceof Exception) {
                    throw CommonError.SCRIPT_RUNTIME_ERROR.wrap((Throwable)value);
                }
                if (value == null || value instanceof CharSequence) {
                    String message = D.s(value);
                    if (message == null) {
                        throw new NullPointerException("{Message is empty.}");
                    }
                    throw new IscBizException(message);
                }
                throw new IscBizException(Throw.toMessage(value));
            }

            public String toString() {
                return "throw " + result;
            }
        };
    }

    public static String toMessage(Object value) {
        String message = value instanceof CharSequence ? value.toString() : Json2.toString(value);
        return message;
    }
}

