/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.loop;

import java.util.Iterator;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.analyzer.expr.ListConstructor;
import kd.isc.iscb.util.script.analyzer.expr.MapConstructor;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.feature.control.loop.For;

class Visit {
    Visit() {
    }

    public static Object analyze(Statement statement, Constructor.Position pos) throws ScriptException {
        MapConstructor map = (MapConstructor)Util.getElement(statement, pos, 0);
        final ListConstructor alias = (ListConstructor)map.getKey(0);
        final ListConstructor stub = (ListConstructor)map.getValue(0);
        Object tmp = pos.getOperand(statement, 1);
        final Object body = For.createBody(statement, pos, tmp);
        final Object next = For.handleNextStatement(statement, pos, tmp);
        return new Evaluator(){

            @Override
            public Object eval(ScriptContext ctx) {
                Visit.visitMultiLists(ctx, stub, alias, body);
                return Util.eval(ctx, next);
            }
        };
    }

    private static void visitMultiLists(ScriptContext ctx, ListConstructor stub, ListConstructor alias, Object body) {
        if (stub.length() != alias.length()) {
            throw new IllegalArgumentException(ResManager.loadKDString("\u522b\u540d\u4e2a\u6570\u4e0e\u5217\u8868\u4e2a\u6570\u4e0d\u4e00\u81f4\uff01", "Visit_0", "isc-iscb-util", new Object[0]));
        }
        Object[] lists = Visit.getLists(ctx, stub);
        if (Visit.isNull(lists)) {
            return;
        }
        String[] names = Visit.getNames(alias);
        Object[] bak = Visit.getContext(ctx, names);
        try {
            Visit.visit(ctx, names, lists, body);
            return;
        }
        finally {
            Visit.setContext(ctx, names, bak);
        }
    }

    private static boolean isNull(Object[] lists) {
        int flag = -1;
        Object[] objectArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            if (flag == -1) {
                flag = e == null ? 1 : 0;
            } else if (flag != (e == null ? 1 : 0)) {
                throw new IllegalArgumentException(ResManager.loadKDString("\u679a\u4e3e\u96c6\u7c7b\u578b\u4e0d\u4e00\u81f4\uff01", "Visit_1", "isc-iscb-util", new Object[0]));
            }
            ++n2;
        }
        return flag == 1;
    }

    private static void visit(ScriptContext ctx, String[] names, Object[] lists, Object body) {
        Iterator<?>[] its = Visit.createIterator(lists);
        while (Visit.hasNext(its)) {
            Object[] elements = Visit.next(its);
            Visit.setContext(ctx, names, elements);
            Util.eval(ctx, body);
        }
    }

    private static Object[] next(Iterator<?>[] its) {
        Object[] elements = new Object[its.length];
        int i = 0;
        while (i < its.length) {
            elements[i] = its[i].next();
            ++i;
        }
        return elements;
    }

    private static boolean hasNext(Iterator<?>[] its) {
        int flag = -1;
        Iterator<?>[] iteratorArray = its;
        int n = its.length;
        int n2 = 0;
        while (n2 < n) {
            Iterator<?> i = iteratorArray[n2];
            if (flag == -1) {
                flag = i.hasNext() ? 1 : 0;
            } else if (flag != (i.hasNext() ? 1 : 0)) {
                throw new IllegalArgumentException(ResManager.loadKDString("\u679a\u4e3e\u6210\u5458\u4e2a\u6570\u4e0d\u5339\u914d\uff01", "Visit_2", "isc-iscb-util", new Object[0]));
            }
            ++n2;
        }
        return flag == 1;
    }

    private static Iterator<?>[] createIterator(Object[] lists) {
        Iterator[] its = new Iterator[lists.length];
        int i = 0;
        while (i < its.length) {
            its[i] = Visit.createIterator(lists[i]);
            ++i;
        }
        return its;
    }

    private static void setContext(ScriptContext ctx, String[] names, Object[] values) {
        int i = 0;
        while (i < names.length) {
            Util.set(ctx, names[i], values[i]);
            ++i;
        }
    }

    private static Object[] getContext(ScriptContext ctx, String[] names) {
        Object[] bak = new Object[names.length];
        int i = 0;
        while (i < bak.length) {
            bak[i] = Util.get(ctx, names[i]);
            ++i;
        }
        return bak;
    }

    private static Object[] getLists(ScriptContext ctx, ListConstructor stub) {
        Object[] lists = new Object[stub.length()];
        int i = 0;
        while (i < lists.length) {
            lists[i] = Util.eval(ctx, stub.get(i));
            ++i;
        }
        return lists;
    }

    private static String[] getNames(ListConstructor alias) {
        String[] names = new String[alias.length()];
        int i = 0;
        while (i < names.length) {
            names[i] = alias.get(i).toString();
            ++i;
        }
        return names;
    }

    private static Iterator<?> createIterator(Object set) {
        if (set instanceof Iterable) {
            return ((Iterable)set).iterator();
        }
        if (set instanceof Iterator) {
            return (Iterator)set;
        }
        throw new IllegalArgumentException(set.getClass().getName());
    }
}

