/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.control.stream;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.script.Util;
import kd.isc.iscb.util.script.analyzer.expr.ConstructorProxy;
import kd.isc.iscb.util.script.core.Constructor;
import kd.isc.iscb.util.script.core.Evaluator;
import kd.isc.iscb.util.script.core.Identifier;
import kd.isc.iscb.util.script.core.Reference;
import kd.isc.iscb.util.script.core.Statement;
import kd.isc.iscb.util.script.feature.control.stream.ValueGetter;
import kd.isc.iscb.util.script.feature.op.compare.Equals;
import kd.isc.iscb.util.script.feature.op.compare.Less;

public class Sort
implements Constructor {
    private static final Reference $ = Reference.create("$");
    private static final Reference THIS = Reference.create("this");

    @Override
    public String name() {
        return "sort";
    }

    public String toString() {
        return this.name();
    }

    @Override
    public Object analyze(Statement s, Constructor.Position pos) throws ScriptException {
        Mode mode;
        ValueGetter expr;
        Object stub;
        if (s.get(0) instanceof ConstructorProxy) {
            if (s.length() == 4) {
                stub = pos.getOperand(s, 2);
                expr = this.getComparizonGetter(pos.getOperand(s, 0));
                mode = Mode.valueOf(pos.getOperand(s, 1).toString());
            } else if (s.length() == 3) {
                stub = pos.getOperand(s, 1);
                expr = this.getComparizonGetter(pos.getOperand(s, 0));
                mode = Mode.ASC;
            } else {
                stub = pos.getOperand(s, 0);
                expr = ValueGetter.CURRENT;
                mode = Mode.ASC;
            }
        } else {
            stub = pos.getOperand(s, 0);
            if (s.length() == 4) {
                expr = this.getComparizonGetter(pos.getOperand(s, 1));
                mode = Mode.valueOf(pos.getOperand(s, 2).toString());
            } else if (s.length() == 3) {
                expr = this.getComparizonGetter(pos.getOperand(s, 1));
                mode = Mode.ASC;
            } else {
                expr = ValueGetter.CURRENT;
                mode = Mode.ASC;
            }
        }
        return new Evaluator(){

            @Override
            public Object eval(ScriptContext ctx) {
                Object c = Util.eval(ctx, stub);
                if (c == null) {
                    return null;
                }
                Collection<?> cc = this.toCollection(c);
                List list = Sort.this.toList(cc, ctx, expr);
                Collections.sort(list, mode);
                return this.compositeReturns(list);
            }

            private List<Object> compositeReturns(List<Pair<Object, Object>> list) {
                ArrayList<Object> result = new ArrayList<Object>(list.size());
                for (Pair<Object, Object> p : list) {
                    result.add(p.getValue());
                }
                return result;
            }

            private Collection<?> toCollection(Object c) {
                if (c instanceof Collection) {
                    return (Collection)c;
                }
                if (c instanceof Map) {
                    return ((Map)c).entrySet();
                }
                if (c instanceof Object[]) {
                    return Arrays.asList((Object[])c);
                }
                if (c instanceof Iterable) {
                    return this.toCollection((Iterable)c);
                }
                throw new UnsupportedOperationException(String.format(ResManager.loadKDString("%1$s \u7684\u5b9e\u9645\u7c7b\u578b\u662f\uff1a%2$s", "Sort_5", "isc-iscb-util", new Object[0]), stub, c.getClass().getName()));
            }

            private Collection<?> toCollection(Iterable<?> c) {
                ArrayList list = new ArrayList();
                Iterator<?> it = c.iterator();
                while (it.hasNext()) {
                    list.add(it.next());
                }
                return list;
            }

            public String toString() {
                return stub + ".sort(" + expr + "," + mode + ")";
            }
        };
    }

    public ValueGetter getComparizonGetter(Object e) {
        return $.equals(e) || THIS.equals(e) ? ValueGetter.CURRENT : new ValueGetter.ExprGetter(e);
    }

    private List<Pair<Object, Object>> toList(Collection<?> c, ScriptContext ctx, ValueGetter expr) {
        ArrayList<Pair<Object, Object>> list = new ArrayList<Pair<Object, Object>>(c.size());
        for (Object value : c) {
            Object comp = expr.eval(ctx, value);
            list.add(new Pair(comp, value));
        }
        return list;
    }

    public static enum Mode implements Identifier,
    Comparator<Pair<Object, Object>>
    {
        ASC{

            @Override
            public int compare(Pair<Object, Object> a, Pair<Object, Object> b) {
                if (Equals.equals(a.getKey(), b.getKey()).booleanValue()) {
                    return 0;
                }
                if (Less.isLess(a.getKey(), b.getKey())) {
                    return -1;
                }
                return 1;
            }
        }
        ,
        DESC{

            @Override
            public int compare(Pair<Object, Object> a, Pair<Object, Object> b) {
                if (Equals.equals(a.getKey(), b.getKey()).booleanValue()) {
                    return 0;
                }
                if (Less.isLess(a.getKey(), b.getKey())) {
                    return 1;
                }
                return -1;
            }
        };

    }
}

