/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.op.arith;

import java.math.BigDecimal;
import java.math.BigInteger;
import kd.isc.iscb.util.script.core.NativeFunction;
import kd.isc.iscb.util.script.feature.op.arith.CalcBase;
import kd.isc.iscb.util.script.feature.op.arith.Util;

public final class Divide
extends CalcBase {
    public static final Divide INS = new Divide();

    private Divide() {
    }

    @Override
    public String name() {
        return "/";
    }

    @Override
    protected Object calc(int a, int b) {
        Util.checkZero(b);
        return (double)a / (double)b;
    }

    @Override
    protected Object calc(long a, long b) {
        Util.checkZero(b);
        return (double)a / (double)b;
    }

    @Override
    protected Object calc(double a, double b) {
        Util.checkZero(b);
        return a / b;
    }

    @Override
    protected Object calc(BigInteger a, BigInteger b) {
        Util.checkZero(b);
        return a.doubleValue() / b.doubleValue();
    }

    @Override
    protected Object calc(BigDecimal a, BigDecimal b) {
        Util.checkZero(b);
        return a.doubleValue() / b.doubleValue();
    }

    @Override
    protected Object calc(Object[] args) {
        if (args[0] == null || args[1] == null) {
            return null;
        }
        return Util.calc(args[0], args[1], (NativeFunction)this);
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public int priority() {
        return 3;
    }
}

