/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.data.sls;

import java.util.Map;
import kd.isc.iscb.util.script.feature.tool.data.sls.Element;
import kd.isc.iscb.util.script.feature.tool.data.sls.Feature;

class Util {
    Util() {
    }

    private static boolean[][] GenerateMatrix(Object group, Map<Feature, Integer> features, Element[] elements) {
        boolean[][] classes = new boolean[features.size()][];
        int i = 0;
        while (i < classes.length) {
            classes[i] = new boolean[elements.length];
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            Feature[] featureArray = elements[i].getFeatures(group);
            int n = featureArray.length;
            int n2 = 0;
            while (n2 < n) {
                Feature f = featureArray[n2];
                int j = features.get(f);
                classes[j][i] = true;
                ++n2;
            }
            ++i;
        }
        return classes;
    }

    private static long[][] createMatrix(int m) {
        long[][] matrix = new long[m][];
        int i = 0;
        while (i < matrix.length) {
            matrix[i] = new long[m];
            ++i;
        }
        return matrix;
    }

    static long gcd(long a, long b) {
        long r = b;
        do {
            b = r;
            r = a % b;
            a = b;
        } while (r != 0L);
        return b;
    }

    static void CalcWeights(Object group, Map<Feature, Integer> features, Element[] elements) {
        boolean[][] classes = Util.GenerateMatrix(group, features, elements);
        double[] propertions = new double[features.size()];
        for (Map.Entry<Feature, Integer> entry : features.entrySet()) {
            double p;
            propertions[entry.getValue().intValue()] = p = entry.getKey().getProportion();
        }
        int m = classes.length + 1;
        int n = classes[0].length;
        long[][] matrix = Util.createMatrix(m);
        double[] b = new double[m];
        int i = 0;
        while (i < m) {
            int j = 0;
            while (j < m) {
                matrix[i][j] = 0L;
                ++j;
            }
            ++i;
        }
        System.arraycopy(propertions, 0, b, 0, m - 1);
        b[m - 1] = 1.0;
        i = 0;
        while (i < m - 1) {
            int j = 0;
            while (j < n) {
                if (classes[i][j]) {
                    long[] lArray = matrix[i];
                    int n2 = m - 1;
                    lArray[n2] = lArray[n2] + 1L;
                    int k = 0;
                    while (k < m - 1) {
                        if (classes[k][j]) {
                            long[] lArray2 = matrix[i];
                            int n3 = k;
                            lArray2[n3] = lArray2[n3] + 1L;
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < m - 1) {
            matrix[m - 1][i] = matrix[i][i];
            ++i;
        }
        matrix[m - 1][m - 1] = n;
        i = 0;
        while (i < m - 1) {
            if (matrix[i][i] != 0L) {
                int j = i + 1;
                while (j < m) {
                    if (matrix[j][i] != 0L) {
                        long gcd = Util.gcd(matrix[i][i], matrix[j][i]);
                        long p = matrix[j][i] / gcd;
                        long q = matrix[i][i] / gcd;
                        matrix[j][i] = 0L;
                        b[j] = b[j] * (double)q - b[i] * (double)p;
                        int k = j;
                        while (k < m) {
                            matrix[j][k] = matrix[j][k] * q - matrix[i][k] * p;
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = m - 1;
        while (i >= 0) {
            if (matrix[i][i] == 0L) {
                b[i] = 0.0;
            } else {
                int j = m - 1;
                while (j > i) {
                    int n4 = i;
                    b[n4] = b[n4] - b[j] * (double)matrix[i][j];
                    --j;
                }
                int n5 = i;
                b[n5] = b[n5] / (double)matrix[i][i];
            }
            --i;
        }
        int j = 0;
        while (j < n) {
            double w = b[m - 1];
            i = 0;
            while (i < m - 1) {
                if (classes[i][j]) {
                    w += b[i];
                }
                ++i;
            }
            Element candidate = elements[j];
            if (w <= 0.0) {
                throw new IllegalArgumentException("A weight value is less than zero. w = " + w);
            }
            candidate.setWeight(candidate.getWeight() * w);
            ++j;
        }
    }

    boolean[][] GenerateMatrix(Map<Feature, Integer> features, Element[] elements) {
        boolean[][] classes = new boolean[features.size()][];
        int i = 0;
        while (i < classes.length) {
            classes[i] = new boolean[elements.length];
            ++i;
        }
        i = 0;
        while (i < elements.length) {
            for (Feature f : elements[i].getFeatures()) {
                int j = features.get(f);
                classes[j][i] = true;
            }
            ++i;
        }
        return classes;
    }
}

