/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.math;

import java.math.BigDecimal;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.core.NativeFunction;

public class Min
implements NativeFunction {
    @Override
    public String name() {
        return "min";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Number a = (Number)args[0];
        Number b = (Number)args[1];
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a instanceof Integer) {
            return Math.min(a.intValue(), b.intValue());
        }
        if (a instanceof Double) {
            return Math.min(a.doubleValue(), b.doubleValue());
        }
        if (a instanceof Long) {
            return Math.min(a.longValue(), b.longValue());
        }
        if (a instanceof Float) {
            return Float.valueOf(Math.min(a.floatValue(), b.floatValue()));
        }
        if (a instanceof BigDecimal) {
            return ((BigDecimal)a).min((BigDecimal)b);
        }
        throw new UnsupportedOperationException(a.getClass().getName());
    }
}

