/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.feature.tool.number;

import java.math.BigDecimal;
import javax.script.ScriptContext;
import kd.isc.iscb.util.script.core.NativeFunction;

public class Split
implements NativeFunction {
    @Override
    public String name() {
        return "split";
    }

    @Override
    public Object call(ScriptContext ctx, Object[] args) {
        Number value = (Number)args[0];
        int count = ((Number)args[1]).intValue();
        if (count <= 1) {
            return new Object[]{value};
        }
        if (value == null) {
            return new Object[count];
        }
        if (value instanceof Integer) {
            return this.split(((Integer)value).intValue(), count);
        }
        if (value instanceof Long) {
            return this.split((Long)value, count);
        }
        if (value instanceof BigDecimal) {
            return this.split((BigDecimal)value, count);
        }
        throw new UnsupportedOperationException("Can't split " + value.getClass() + " value.");
    }

    private Object split(BigDecimal value, int count) {
        BigDecimal scale = new BigDecimal((int)Math.pow(10.0, value.scale()));
        Object[] tmp = this.split(value.multiply(scale).longValue(), count);
        int i = 0;
        while (i < count) {
            tmp[i] = new BigDecimal((Long)tmp[i]).divide(scale);
            ++i;
        }
        return tmp;
    }

    private Object[] split(long value, int count) {
        boolean isNegative;
        boolean bl = isNegative = value < 0L;
        if (isNegative) {
            value = -value;
        }
        long avg = value / (long)count;
        int rem = (int)(value % (long)count);
        Object[] array = new Object[count];
        int i = 0;
        while (i < rem) {
            array[i] = avg + 1L;
            ++i;
        }
        i = rem;
        while (i < count) {
            array[i] = avg;
            ++i;
        }
        if (isNegative) {
            i = 0;
            while (i < array.length) {
                array[i] = -((Long)array[i]).longValue();
                ++i;
            }
        }
        return array;
    }
}

