/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.util.script.misc;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.util.err.CommonError;

public class HttpUtil {
    private static final String UTF_8 = "UTF-8";

    public static String xFormEncode(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof CharSequence) {
            return data.toString();
        }
        if (data instanceof Map) {
            StringBuilder s = new StringBuilder();
            for (Map.Entry e : ((Map)data).entrySet()) {
                if (s.length() > 0) {
                    s.append('&');
                }
                String key = (String)e.getKey();
                s.append(HttpUtil.encode(key));
                s.append('=');
                Object v = e.getValue();
                String value = v == null ? "" : v.toString();
                s.append(HttpUtil.encode(value));
            }
            return s.toString();
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString("\u53c2\u6570\u503c\u8981\u6c42\u662f\u5b57\u7b26\u4e32\uff0c\u4f46\u5b9e\u9645\u4e0a\u662f%s\uff01", "HttpUtil_1", "isc-iscb-util", new Object[0]), data.getClass().getName()));
    }

    private static String encode(String key) {
        try {
            return URLEncoder.encode(key, UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw CommonError.INVALID_CHARSET.create(e, UTF_8);
        }
    }

    public static String mergeToURL(String url, String data) {
        if (data == null || data.length() == 0) {
            return url;
        }
        if (url.indexOf(63) >= 0) {
            return String.valueOf(url) + '&' + data;
        }
        return String.valueOf(url) + '?' + data;
    }

    public static Object compositeReturns(Map<String, Object> cookies, Map<String, Object> headers, Object result) {
        return HttpUtil.compositeReturns(-1, cookies, headers, result);
    }

    public static Object compositeReturns(int responseCode, Map<String, Object> cookies, Map<String, Object> headers, Object result) {
        HashMap<String, Object> returns = new HashMap<String, Object>(4);
        returns.put("cookies", cookies);
        returns.put("headers", headers);
        returns.put("result", result);
        returns.put("responseCode", responseCode);
        return returns;
    }
}

