/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.extscheme.mailApprove;

import com.kingdee.bos.workflow.extscheme.mailApprove.MailApproveHtmlDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class MailTextArea {
    private static final String textAreaHtml = "<div id=\"{{titleArea}}\"  class=\"subArea\" style=\"padding-top:10px\">\n  <span style=\"color: #5582F3;\" class=\"c_titleDiv\">|</span>\n  <span id = \"{{textAreaTitleId}}\" class=\"c_titleDiv\" > {{textAreaTitle}}</span>\n  <p id = \"{{textAreaContentId}}\" style=\"font-size: 10px;\">{{textAreaContent}}</p>\n</div>";
    private static final String textAreaTableHtml = "   <tr id=\"{{titleArea}}\">\n    <td colspan=\"{{td_col_count_}}\"><span style=\"{{textArea_titleStyle_1}}\">|</span><span style=\"{{textArea_titleStyle_2}}\"> {{textAreaTitle}}</span></td>\n   </tr>\n   <tr>    <td colspan=\"{{td_col_count_}}\"><span style=\"{{textAreaContent_style_}}\">{{textAreaContent}}</span><td>  </tr>";
    private static final String textAreaTableHtmlWithNoTitle = "   <tr id=\"{{titleArea}}\">\n    <td colspan=\"{{td_col_count_}}\"><span style=\"{{textAreaContent_style_}}\">{{textAreaContent}}</span><td>  </tr>";
    private String divId;
    private String textAreaTitle;
    private String titleStyle;
    private String textAreaContent;
    private String contentStyle;
    private String preElementId;

    public String getDivId() {
        return this.divId;
    }

    public MailTextArea setDivId(String divId) {
        this.divId = divId;
        return this;
    }

    public String getTextAreaTitle() {
        return this.textAreaTitle;
    }

    public MailTextArea setTextAreaTitle(String textAreaTitle) {
        this.textAreaTitle = textAreaTitle;
        return this;
    }

    public String getTitleStyle() {
        return this.titleStyle;
    }

    public MailTextArea setTitleStyle(String titleStyle) {
        this.titleStyle = titleStyle;
        return this;
    }

    public String getTextAreaContent() {
        return this.textAreaContent;
    }

    public MailTextArea setTextAreaContent(String textAreaContent) {
        this.textAreaContent = textAreaContent;
        return this;
    }

    public String getContentStyle() {
        return this.contentStyle;
    }

    public MailTextArea setContentStyle(String contentStyle) {
        this.contentStyle = contentStyle;
        return this;
    }

    public String getPreElementId() {
        return this.preElementId;
    }

    public MailTextArea setPreElementId(String preElementId) {
        this.preElementId = preElementId;
        return this;
    }

    public static String buildTextArea(MailTextArea textArea) {
        Element content;
        String html = textAreaHtml;
        html = html.replace("{{textAreaTitle}}", MailApproveHtmlDTO.replaceNullStr(textArea.getTextAreaTitle()));
        Document document = Jsoup.parse((String)(html = html.replace("{{textAreaContent}}", MailApproveHtmlDTO.replaceNullStr(textArea.getTextAreaContent()))));
        Element title = document.getElementById("{{textAreaTitleId}}");
        if (title != null && textArea.getTitleStyle() != null && !"".equals(textArea.getTitleStyle())) {
            title.removeAttr("style");
            title.attr("style", textArea.getTitleStyle());
        }
        if ((content = document.getElementById("{{textAreaContentId}}")) != null && textArea.getContentStyle() != null && !"".equals(textArea.getContentStyle())) {
            content.removeAttr("style");
            content.attr("style", textArea.getContentStyle());
        }
        return document.html();
    }

    public static Map<String, String> buildTextArea(MailApproveHtmlDTO mailApproveHtmlDTO) {
        List<MailTextArea> textAreas = mailApproveHtmlDTO.getMailTextAreas();
        HashMap<String, String> idHtmlMap = new HashMap<String, String>();
        int i = 0;
        while (i < textAreas.size()) {
            MailTextArea textArea = textAreas.get(i);
            String singleHtml = "DIV".equals(mailApproveHtmlDTO.getModelStyle()) ? MailTextArea.buildTextArea(textArea) : MailTextArea.buildTextAreaWithTable(textArea, mailApproveHtmlDTO);
            String extName = "";
            if (i > 0) {
                extName = "_" + i;
            }
            String divId = "titleArea" + extName;
            if (textArea.getDivId() != null && !"".equals(textArea.getDivId())) {
                divId = textArea.getDivId();
            }
            singleHtml = singleHtml.replace("{{titleArea}}", divId);
            singleHtml = singleHtml.replace("{{textAreaTitleId}}", "textAreaTitle" + extName);
            singleHtml = singleHtml.replace("{{textAreaContentId}}", "textAreaContent" + extName);
            idHtmlMap.put(divId, singleHtml);
            ++i;
        }
        return idHtmlMap;
    }

    public static String buildTextAreaWithTable(MailTextArea textArea, MailApproveHtmlDTO approveHtmlDTO) {
        String html = textAreaTableHtml;
        html = textArea.getTextAreaTitle() == null || "".equals(textArea.getTextAreaTitle()) ? textAreaTableHtmlWithNoTitle : html.replace("{{textAreaTitle}}", MailApproveHtmlDTO.replaceNullStr(textArea.getTextAreaTitle()));
        html = html.replace("{{td_col_count_}}", MailApproveHtmlDTO.calColCount(approveHtmlDTO).toString());
        html = html.replace("{{td_col_count_}}", MailApproveHtmlDTO.calColCount(approveHtmlDTO).toString());
        html = html.replace("{{textAreaContent}}", MailApproveHtmlDTO.replaceNullStr(textArea.getTextAreaContent()));
        if (textArea.getTitleStyle() != null && !"".equals(textArea.getTitleStyle())) {
            html = html.replace("{{textArea_titleStyle_1}}", textArea.getTitleStyle());
            html = html.replace("{{textArea_titleStyle_2}}", textArea.getTitleStyle());
        } else {
            html = html.replace("{{textArea_titleStyle_1}}", "color: #5582F3;font-weight: 800;font-family: MicrosoftYaHeiSemibold;font-size: 14px;");
            html = html.replace("{{textArea_titleStyle_2}}", "font-weight: 800;font-family: MicrosoftYaHeiSemibold;font-size: 14px;");
        }
        html = textArea.getContentStyle() != null && !"".equals(textArea.getContentStyle()) ? html.replace("{{textAreaContent_style_}}", textArea.getContentStyle()) : html.replace("{{textAreaContent_style_}}", "font-size:10px;");
        return html;
    }
}

