/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.imports;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.Genders;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.base.ConstellationInfo;
import com.kingdee.eas.hr.base.EmployeeTypeCollection;
import com.kingdee.eas.hr.base.EmployeeTypeFactory;
import com.kingdee.eas.hr.base.EnrollSourceInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.hr.base.ZodiacInfo;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.base.util.IDCardCommonUtil;
import com.kingdee.eas.hr.emp.EmployeeBizException;
import com.kingdee.eas.hr.emp.app.util.EMPhelper;
import com.kingdee.eas.hr.emp.app.util.SHREmpImportTool;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptBizManageTool;
import com.kingdee.eas.hr.emp.app.util.SHREmpPreEntryCheckTool;
import com.kingdee.eas.hr.org.JobGradeCollection;
import com.kingdee.eas.hr.org.JobGradeFactory;
import com.kingdee.eas.hr.org.JobGradeInfo;
import com.kingdee.eas.hr.org.OrgnizationImportBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.affair.web.handler.util.EmployeeUtil;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.app.io.fileImport.BaseColumnInfo;
import com.kingdee.shr.base.syssetting.app.io.fileImport.BaseRowInfo;
import com.kingdee.shr.base.syssetting.app.io.fileImport.ImportException;
import com.kingdee.shr.base.syssetting.app.io.impl.PreEntryPersonImportService;
import com.kingdee.shr.base.syssetting.app.io.impl.util.EmpEnrollImportCheck;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.ml.SHRWebResource;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.preentry.PreEntryInfo;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PreEntryPersonImport
extends PreEntryPersonImportService {
    private static Pattern pattern = Pattern.compile("[\u4e00-\u9fa5]");
    Context ctx = SHRContext.getInstance().getContext();

    protected void importNew(BaseRowInfo row) throws ImportException {
        try {
            PositionCollection coll;
            HROrgUnitInfo hrOrgUnitInfo;
            String importCheckEffectPermission;
            PreEntryPersonInfo preEntryPersonInfo;
            PreEntryInfo preEntryInfo;
            Context ctx;
            block46: {
                String nameOrEmailSql;
                IRowSet emailRow;
                JobGradeInfo jobGrade;
                ctx = this.getContext();
                HashMap modelMap = this.beforeImport(row);
                preEntryInfo = (PreEntryInfo)modelMap.get("PreEntryInfo");
                preEntryPersonInfo = (PreEntryPersonInfo)modelMap.get("PreEntryPersonInfo");
                String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
                String hrOrgIdsString = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)userId, (String)this.getPermItemId());
                String localName = preEntryInfo.getString("localname");
                String surname = preEntryInfo.getString("surname");
                boolean allUpperCase = PreEntryPersonImport.isEnglishAndSpaceOnly(surname);
                if (!allUpperCase) {
                    throw new ImportException("The first name must be in English");
                }
                preEntryInfo.put("surname", (Object)surname.toUpperCase());
                String givenName = preEntryInfo.getString("givenname");
                String middleNames = preEntryInfo.getString("middlenames");
                preEntryInfo.put("middlenames", (Object)middleNames);
                Date preEnterDate = preEntryInfo.getDate("preenterdate");
                int tryMonth = preEntryInfo.getInt("trymonth");
                String userName = String.valueOf(givenName) + "." + surname;
                if (userName.length() > 20 && (userName = String.valueOf(givenName) + "." + surname.substring(0, 1)).length() > 20) {
                    int startLength = userName.length() - 20;
                    userName = userName.substring(startLength, userName.length());
                }
                userName = userName.toLowerCase();
                preEntryInfo.put("userName", (Object)userName);
                String name = String.valueOf(givenName) + " " + surname.toUpperCase() + " " + localName;
                String workemail = String.valueOf(userName) + "@gtiit.edu.cn";
                preEntryInfo.put("workemail", (Object)workemail);
                preEntryInfo.put("trialStartDate", (Object)preEnterDate);
                Calendar instance = Calendar.getInstance();
                instance.setTime(preEnterDate);
                instance.add(2, tryMonth);
                java.util.Date time = instance.getTime();
                preEntryInfo.put("transferDate", (Object)time);
                String employeeTypeNumber = "";
                employeeTypeNumber = tryMonth > 0 ? "002" : "001";
                EmployeeTypeCollection employeeTypeColl = EmployeeTypeFactory.getLocalInstance((Context)ctx).getEmployeeTypeCollection("where number = '" + employeeTypeNumber + "'");
                if (employeeTypeColl != null && employeeTypeColl.size() > 0) {
                    preEntryInfo.put("empType", (Object)employeeTypeColl.get(0).getId().toString());
                }
                EmployeeUtil employee = new EmployeeUtil();
                int number = employee.getFnumber();
                preEntryInfo.put("empNumber", (Object)number);
                java.util.Date birthday = preEntryPersonInfo.getBirthday();
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                String dateBirthday = formatter.format(birthday);
                LocalDate now = LocalDate.now();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(birthday);
                calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
                ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId());
                LocalDate lobirthday = zonedDateTime.toLocalDate();
                long daysBetween = ChronoUnit.DAYS.between(lobirthday, now);
                if ((double)daysBetween / 365.25 < 18.0) {
                    throw new ImportException("Onboarding is not allowed for persons under 18 years old");
                }
                String cardno = preEntryPersonInfo.getIdCardNO();
                String checkSql = "select FIDCardNO,FPASSPORTNO from t_bd_person where to_char(FBirthday,'yyyy-MM-dd') = '" + dateBirthday + "' and UPPER(FName_L1) = UPPER('" + name + "') or FIDCardNO = '" + cardno + "'";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                if (rs.next()) {
                    if (!StringUtils.isEmpty((String)rs.getString("FIDCardNO"))) {
                        throw new ImportException("Employee is re-entry employee, ID number\uff1a" + rs.getString("FIDCardNO"));
                    }
                    if (!StringUtils.isEmpty((String)rs.getString("FPASSPORTNO"))) {
                        throw new ImportException("Employee is re-entry employee, passport number\uff1a" + rs.getString("FPASSPORTNO"));
                    }
                }
                if ((jobGrade = (JobGradeInfo)preEntryInfo.get("jobGrade")) != null) {
                    jobGrade = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeInfo((IObjectPK)new ObjectUuidPK(jobGrade.getId().toString()));
                    String errorMsg = this.checkJobGrade(ctx, preEntryInfo.getPosition().getId().toString(), jobGrade);
                    if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)errorMsg)) {
                        throw new ImportException(errorMsg);
                    }
                }
                if ((emailRow = DbUtil.executeQuery((Context)ctx, (String)(nameOrEmailSql = "select fid from t_bd_person where Upper(CFUserName) = Upper('" + userName + "') or Upper(FEMail) = Upper('" + workemail + "')  union  select fid from T_HR_PreEntry where Upper(CFUserName_l1) = Upper('" + userName + "') or Upper(CFWorkemail) = Upper('" + workemail + "')"))).next()) {
                    throw new ImportException("The username: " + userName + " or email: " + workemail + " already exists");
                }
                if (!hrOrgIdsString.contains(preEntryInfo.getHrOrgUnit().getId().toString())) {
                    EmployeeBizException e = new EmployeeBizException(EmployeeBizException.ENTRY_POSI_ORG_NOT_IN);
                    throw new ImportException(e.getMessage(), (Throwable)e);
                }
                this.checkBlackList(ctx, preEntryPersonInfo);
                String empName = "";
                String l = LocaleUtils.getShortCode((Context)ctx);
                boolean isNecessary = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_FULLNAME_SUBFIELD", null);
                List languageMapping = this.getLanguageMappingList();
                Matcher m1 = null;
                Matcher m2 = null;
                String firstNameLocal = null;
                String lastNameLocal = null;
                String curLang = null;
                HashMap<String, String> curLangs = new HashMap<String, String>();
                curLangs.put("l1", "l1");
                curLangs.put("l2", "l2");
                curLangs.put("l3", "l3");
                if (isNecessary) {
                    Iterator<Object> var18 = languageMapping.iterator();
                    while (true) {
                        if (!var18.hasNext()) {
                            if (curLangs.size() > 0) {
                                for (String orgId : curLangs.keySet()) {
                                    curLang = (String)curLangs.get(orgId);
                                    preEntryInfo.setFirstName(preEntryInfo.getFirstName(com.kingdee.util.LocaleUtils.getLocale((String)l)), com.kingdee.util.LocaleUtils.getLocale((String)curLang));
                                    preEntryInfo.setLastName(preEntryInfo.getLastName(com.kingdee.util.LocaleUtils.getLocale((String)l)), com.kingdee.util.LocaleUtils.getLocale((String)curLang));
                                    preEntryPersonInfo.setFirstName(preEntryPersonInfo.getFirstName(com.kingdee.util.LocaleUtils.getLocale((String)l)), com.kingdee.util.LocaleUtils.getLocale((String)curLang));
                                    preEntryPersonInfo.setLastName(preEntryPersonInfo.getLastName(com.kingdee.util.LocaleUtils.getLocale((String)l)), com.kingdee.util.LocaleUtils.getLocale((String)curLang));
                                }
                            }
                            break block46;
                        }
                        Map map = (Map)var18.next();
                        firstNameLocal = row.getValueOfString(MessageFormat.format("{0}.{1}", "firstName", map.get("locale")));
                        lastNameLocal = row.getValueOfString(MessageFormat.format("{0}.{1}", "lastName", map.get("locale")));
                        curLang = (String)map.get("lang");
                        preEntryInfo.setFirstName(firstNameLocal, com.kingdee.util.LocaleUtils.getLocale((String)curLang));
                        preEntryInfo.setLastName(lastNameLocal, com.kingdee.util.LocaleUtils.getLocale((String)curLang));
                        preEntryPersonInfo.setFirstName(firstNameLocal, com.kingdee.util.LocaleUtils.getLocale((String)curLang));
                        preEntryPersonInfo.setLastName(lastNameLocal, com.kingdee.util.LocaleUtils.getLocale((String)curLang));
                        m1 = pattern.matcher(firstNameLocal);
                        m2 = pattern.matcher(lastNameLocal);
                        empName = !m1.find() && !m2.find() ? String.valueOf(firstNameLocal) + " " + lastNameLocal : String.valueOf(lastNameLocal) + firstNameLocal;
                    }
                }
                for (Map map : languageMapping) {
                    curLang = (String)map.get("lang");
                    empName = row.getValueOfString(MessageFormat.format("{0}.{1}", "name", map.get("locale")));
                    preEntryInfo.setName(name, com.kingdee.util.LocaleUtils.getLocale((String)curLang));
                    preEntryPersonInfo.setName(name, com.kingdee.util.LocaleUtils.getLocale((String)curLang));
                    curLangs.remove(curLang);
                    curLangs.remove(curLang);
                }
                if (curLangs.size() > 0) {
                    for (String orgId : curLangs.keySet()) {
                        curLang = (String)curLangs.get(orgId);
                    }
                }
            }
            if (SHREmpImportTool.SPECIAL_AREA_CODE.equals(preEntryInfo.getGlobalRoaming())) {
                preEntryInfo.setCellPhone(preEntryInfo.getNCell());
            } else {
                preEntryInfo.setCellPhone(String.valueOf(preEntryInfo.getGlobalRoaming()) + "-" + preEntryInfo.getNCell());
            }
            preEntryInfo.setIsSSC(false);
            preEntryInfo.setBillState(HRBillStateEnum.SAVED);
            if (StringUtils.isEmpty((String)preEntryInfo.getNumber())) {
                ICodingRuleManager iCodingRuleManager;
                String orgId;
                OrgUnitInfo mainOrg = (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
                String string = orgId = mainOrg == null ? "" : mainOrg.getString("id");
                if (orgId == null || orgId.trim().length() == 0) {
                    orgId = "00000000-0000-0000-0000-000000000000CCE7AED4";
                }
                if (!(iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).isExist((IObjectValue)preEntryInfo, orgId)) {
                    EmployeeBizException e = new EmployeeBizException(EmployeeBizException.BILL_NUM_NULL_NO_COD_RULE);
                    throw new ImportException(e.getMessage(), (Throwable)e);
                }
            } else {
                preEntryInfo.put("isNeedCoding", (Object)"true");
            }
            if (!StringUtils.isEmpty((String)(importCheckEffectPermission = this.importCheckEffectPermission(ctx, "/dynamic.do?method=submitEffect#uri=emp.PreEntry.form", (OrgUnitInfo)(hrOrgUnitInfo = SHREmpOptBizManageTool.getManageHROByAdminOrg((Context)ctx, (String)(coll = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection("where id = '" + preEntryInfo.getPosition().getId().toString() + "'")).get(0).getAdminOrgUnit().getId().toString())))))) {
                throw new ImportException(importCheckEffectPermission);
            }
            if (hrOrgUnitInfo == null) {
                EmployeeBizException e = new EmployeeBizException(EmployeeBizException.CANNOT_GET_TARGET, new Object[]{preEntryInfo.getPosition().getName()});
                throw new ImportException(e.getMessage(), (Throwable)e);
            }
            String IDCardNo = row.getValueOfString("IDCardNO");
            String constellationName = row.getValueOfString("constellation");
            String zodiacName = row.getValueOfString("zodiac");
            Map resultMap = null;
            ConstellationInfo cInfo = new ConstellationInfo();
            ZodiacInfo zInfo = new ZodiacInfo();
            IDCardCommonUtil iDCardCommonUti = null;
            if (StringUtils.isEmpty((String)constellationName)) {
                if (!StringUtils.isEmpty((String)row.getValueOfString("birthday"))) {
                    resultMap = EMPhelper.getConZocByBirthDay((Context)ctx, (Object)preEntryPersonInfo.getBirthday());
                } else if (!StringUtils.isEmpty((String)IDCardNo)) {
                    iDCardCommonUti = new IDCardCommonUtil(IDCardNo, HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_IDCARD_VERIFY", (String)hrOrgUnitInfo.getId().toString()));
                    resultMap = EMPhelper.getConZocByBirthDay((Context)ctx, (Object)iDCardCommonUti.getBirthday());
                }
                if (resultMap != null && resultMap.containsKey("constellationId")) {
                    cInfo.setId(BOSUuid.read((String)((String)resultMap.get("constellationId"))));
                    cInfo.setName((String)resultMap.get("constellation"));
                }
            } else {
                cInfo = EMPhelper.getConstellationByName((Context)ctx, (String)constellationName);
            }
            preEntryPersonInfo.setConstellation(cInfo);
            if (StringUtils.isEmpty((String)zodiacName)) {
                if (!StringUtils.isEmpty((String)row.getValueOfString("birthday"))) {
                    resultMap = EMPhelper.getConZocByBirthDay((Context)ctx, (Object)preEntryPersonInfo.getBirthday());
                } else if (!StringUtils.isEmpty((String)IDCardNo)) {
                    iDCardCommonUti = new IDCardCommonUtil(IDCardNo, HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_IDCARD_VERIFY", (String)hrOrgUnitInfo.getId().toString()));
                    resultMap = EMPhelper.getConZocByBirthDay((Context)ctx, (Object)iDCardCommonUti.getBirthday());
                }
                if (resultMap != null && resultMap.containsKey("zodiacId")) {
                    zInfo.setId(BOSUuid.read((String)((String)resultMap.get("zodiacId"))));
                    zInfo.setName((String)resultMap.get("zodiac"));
                }
            } else {
                zInfo = EMPhelper.getZodiacByName((Context)ctx, (String)zodiacName);
            }
            preEntryPersonInfo.setZodiac(zInfo);
            EnrollSourceInfo baseItemInfo = preEntryInfo.getEnrollSource();
            if (baseItemInfo != null && !this.isAvailableBaseItem(hrOrgUnitInfo.getId().toString(), baseItemInfo.getId().toString(), "com.kingdee.eas.hr.base.app.EnrollSource")) {
                EmployeeBizException e1 = new EmployeeBizException(EmployeeBizException.INVITE_SOURCE_BASE, new Object[]{baseItemInfo.getName(), hrOrgUnitInfo.getName()});
                throw new ImportException(e1.getMessage(), (Throwable)e1);
            }
            preEntryInfo.put("legalemployer", (Object)preEntryInfo.getString("legalemployer"));
            this.setWorkFlow((CoreBaseInfo)preEntryInfo);
            super.addnewModel(preEntryInfo, preEntryPersonInfo);
        }
        catch (EASBizException var30) {
            throw new ImportException(var30.getMessage(), (Throwable)var30);
        }
        catch (BOSException var31) {
            throw new ImportException(var31.getMessage(), (Throwable)var31);
        }
        catch (SHRWebException var32) {
            var32.printStackTrace();
        }
        catch (ParseException var33) {
            var33.printStackTrace();
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
    }

    public static boolean checkGrade(Context ctx, String positionId, JobGradeInfo jobGradeInfo) throws BOSException, SQLException {
        String sql = "SELECT a.FHIGHJOBGRADEID,a.FLOWJOBGRADEID,b.FINDEX highIndex,c.FINDEX lowIndex,c.FJOBGRADEMODULEID FROM T_ORG_Position a left join T_HR_JobGrade b on a.FHIGHJOBGRADEID = b.FID left join T_HR_JobGrade c on a.FLOWJOBGRADEID = c.fid where a.FID = '" + positionId + "'";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String highJobGradeId = "";
        String lowJobGradeId = "";
        String highIndex = "";
        String lowIndex = "";
        String jobGradeModuleId = "";
        if (rs.next()) {
            highJobGradeId = rs.getString("FHIGHJOBGRADEID") == null ? "" : rs.getString("FHIGHJOBGRADEID");
            lowJobGradeId = rs.getString("FLOWJOBGRADEID") == null ? "" : rs.getString("FLOWJOBGRADEID");
            highIndex = rs.getString("highIndex") == null ? "" : rs.getString("highIndex");
            lowIndex = rs.getString("lowIndex") == null ? "" : rs.getString("lowIndex");
            String string = jobGradeModuleId = rs.getString("FJOBGRADEMODULEID") == null ? "" : rs.getString("FJOBGRADEMODULEID");
        }
        if (highJobGradeId != "" && lowJobGradeId != "") {
            String gradeIndex = String.valueOf(jobGradeInfo.getIndex());
            String gradeJobModuleId = jobGradeInfo.getJobGradeModule().getId().toString();
            if (gradeIndex.compareTo(lowIndex) >= 0 && gradeIndex.compareTo(highIndex) <= 0 && jobGradeModuleId.equals(gradeJobModuleId)) {
                return false;
            }
        }
        return true;
    }

    public String checkJobGrade(Context ctx, String positionId, JobGradeInfo jobGradeInfo) throws BOSException {
        String errorMsg = "";
        String jobGradeId = jobGradeInfo.getId().toString();
        if (StringUtils.isEmpty((String)jobGradeId)) {
            return errorMsg;
        }
        StringBuffer sql = new StringBuffer().append("select id,name,number,index,jobGradeModule.state,jobGradeModule.name,jobGradeModule.id").append(" where id = '").append(jobGradeId).append("')").append(" and state = 1");
        JobGradeCollection jgColl = JobGradeFactory.getLocalInstance((Context)ctx).getJobGradeCollection(sql.toString());
        if (jgColl.size() > 0) {
            JobGradeInfo jgInfo = jgColl.get(0);
            if (jgInfo.getJobGradeModule() == null || jgInfo.getJobGradeModule().getState() != BaseItemStateEnum.ENABLE) {
                errorMsg = MessageFormat.format(SHRWebResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeBizResource", (String)"label153", (Context)ctx), jgInfo.getJobGradeModule().getName());
                return errorMsg;
            }
            int index = jgInfo.getIndex();
            String oql = "select id,lowJobGrade.name,lowJobGrade.number,lowJobGrade.index,highJobGrade.name,highJobGrade.number,highJobGrade.index,lowJobGrade.jobGradeModule.id where id ='" + positionId + "'";
            PositionInfo pInfo = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(oql).get(0);
            if (pInfo.getLowJobGrade() != null && pInfo.getHighJobGrade() != null) {
                if (pInfo.getLowJobGrade().getJobGradeModule() == null) {
                    errorMsg = SHRWebResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeBizResource", (String)"label160", (Context)ctx);
                    return errorMsg;
                }
                if (!jgInfo.getJobGradeModule().getId().toString().equals(pInfo.getLowJobGrade().getJobGradeModule().getId().toString())) {
                    errorMsg = SHRWebResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeBizResource", (String)"label162", (Context)ctx);
                    return errorMsg;
                }
                if (index >= pInfo.getLowJobGrade().getIndex() && index <= pInfo.getHighJobGrade().getIndex()) {
                    return errorMsg;
                }
                errorMsg = SHRWebResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeBizResource", (String)"label151", (Context)ctx);
                return errorMsg;
            }
            errorMsg = SHRWebResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeBizResource", (String)"label158", (Context)ctx);
            return errorMsg;
        }
        return errorMsg;
    }

    protected void verifyRow(BaseRowInfo row) throws ImportException {
        String value;
        Map columnInfoMap = row.getMapColumnInfo();
        Iterator iterator = columnInfoMap.entrySet().iterator();
        Context ctx = this.getContext();
        HashMap<String, String> validMap = new HashMap<String, String>();
        EmpEnrollImportCheck eeic = new EmpEnrollImportCheck();
        while (iterator.hasNext()) {
            BaseColumnInfo columnInfo = (BaseColumnInfo)iterator.next().getValue();
            if (columnInfo == null) continue;
            value = row.getValueOfStringByIndex(columnInfo.getColumnIndex());
            if (columnInfo.getPropName().equals("PreEntry.adminOrg")) {
                validMap.put("adminOrg", value);
                continue;
            }
            if (columnInfo.getPropName().equals("PreEntry.position")) {
                validMap.put("position", value);
                continue;
            }
            validMap.put(columnInfo.getPropName(), value);
        }
        try {
            value = eeic.checkPositionAndOrgAndCompany(ctx, validMap);
            if (!StringUtils.isEmpty((String)value)) {
                throw new ImportException(value);
            }
        }
        catch (BOSException var9) {
            var9.printStackTrace();
        }
        super.verifyRow(row);
    }

    public boolean verifyModelData(HashMap<String, Object> map) throws BOSException, EASBizException {
        String errorInfo;
        PreEntryInfo preEntryInfo;
        boolean verifyType;
        block16: {
            verifyType = true;
            preEntryInfo = (PreEntryInfo)map.get("PreEntryInfo");
            PreEntryPersonInfo preEntryPersonInfo = (PreEntryPersonInfo)map.get("PreEntryPersonInfo");
            if (!StringUtils.isEmpty((String)preEntryPersonInfo.getIdCardNO()) && preEntryInfo.getHrOrgUnit() != null && preEntryInfo.getHrOrgUnit().getId() != null) {
                IDCardCommonUtil iDCardCommonUtil = null;
                boolean isIDCardVerify = false;
                try {
                    isIDCardVerify = HRParamUtil.getParamOfHR((Context)this.getContext(), (String)"IS_IDCARD_VERIFY", (String)preEntryInfo.getHrOrgUnit().getId().toString());
                    iDCardCommonUtil = new IDCardCommonUtil(preEntryPersonInfo.getIdCardNO(), isIDCardVerify);
                    errorInfo = iDCardCommonUtil.getBirthday();
                    Genders gender = iDCardCommonUtil.getGenders();
                    java.util.Date birthday = DateTimeUtils.parseDate((String)errorInfo);
                    if (preEntryPersonInfo.getGender() == null) {
                        preEntryPersonInfo.setGender(gender);
                    }
                    if (preEntryPersonInfo.getBirthday() == null) {
                        preEntryPersonInfo.setBirthday(birthday);
                    }
                }
                catch (BaseException var12) {
                    throw new ImportException(var12.getMessage(), (Throwable)var12);
                }
                catch (ParseException var13) {
                    if (!isIDCardVerify) break block16;
                    BaseException e1 = new BaseException(BaseException.IDCARD_NUMERROR);
                    throw new ImportException(e1.getMessage(), (Throwable)e1);
                }
            }
        }
        if (!StringUtils.isEmpty((String)preEntryInfo.getNCell()) && !StringUtils.isEmpty((String)preEntryInfo.getGlobalRoaming())) {
            if (SHREmpImportTool.SPECIAL_AREA_CODE.equals(preEntryInfo.getGlobalRoaming())) {
                preEntryInfo.setCellPhone(preEntryInfo.getNCell());
            } else {
                preEntryInfo.setCellPhone(String.valueOf(preEntryInfo.getGlobalRoaming()) + "-" + preEntryInfo.getNCell());
            }
            Context ctx = this.getContext();
            try {
                String email;
                String preEntryID = preEntryInfo.getId() != null ? preEntryInfo.getId().toString() : "";
                errorInfo = "";
                if (preEntryInfo.getCellPhone() != null) {
                    email = preEntryInfo.getCellPhone();
                    HRUtilExtend.verifyCellPhoneNumber((Context)ctx, (String)email);
                    errorInfo = SHREmpPreEntryCheckTool.checkPreEntryCellPhone((Context)ctx, (String)email, (String)preEntryID);
                    if (!errorInfo.equals("")) {
                        throw new ImportException(errorInfo);
                    }
                }
                if (preEntryInfo.getEmail() != null) {
                    email = preEntryInfo.getEmail();
                    HRUtilExtend.verifyMail((Context)ctx, (String)email);
                    errorInfo = SHREmpPreEntryCheckTool.checkPreEntryEmail((Context)ctx, (String)email, (String)preEntryID);
                    if (!errorInfo.equals("")) {
                        throw new ImportException(errorInfo);
                    }
                }
            }
            catch (BOSException var10) {
                var10.printStackTrace();
            }
            catch (SQLException var11) {
                var11.printStackTrace();
            }
            return verifyType;
        }
        EmployeeBizException e = new EmployeeBizException(EmployeeBizException.TEL_IS_NULL);
        throw new ImportException(e.getMessage(), (Throwable)e);
    }

    public static boolean isEnglishAndSpaceOnly(String str) {
        String pattern = "^[a-zA-Z\\s]*$";
        return str.matches(pattern);
    }

    public List<BaseColumnInfo> getDynamicColumn() {
        Context ctx = this.getContext();
        ArrayList<BaseColumnInfo> list = new ArrayList<BaseColumnInfo>();
        boolean isNecessary = false;
        try {
            isNecessary = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_FULLNAME_SUBFIELD", null);
        }
        catch (EASBizException var9) {
            OrgnizationImportBizException e1 = new OrgnizationImportBizException(OrgnizationImportBizException.EXCEPTION116, (Throwable)var9, new Object[]{var9.getMessage()});
            throw new ImportException(e1.getMessage(), (Throwable)e1);
        }
        catch (BOSException var10) {
            OrgnizationImportBizException e1 = new OrgnizationImportBizException(OrgnizationImportBizException.EXCEPTION116, (Throwable)var10, new Object[]{var10.getMessage()});
            throw new ImportException(e1.getMessage(), (Throwable)e1);
        }
        List languageMapping = this.getLanguageMappingList();
        int i = 1;
        BaseColumnInfo columnInfo = null;
        String columnName = null;
        if (isNecessary) {
            int j = 0;
            while (j < languageMapping.size()) {
                columnName = MessageFormat.format("{0}.{1}", "lastName", ((Map)languageMapping.get(j)).get("locale"));
                columnInfo = BaseColumnInfo.createDynamicColumn((String)columnName, (String)"", (boolean)isNecessary);
                columnInfo.setName(MessageFormat.format("{0}.{1}", SHRWebResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource", (String)"EMP_LASTNAME", (Context)ctx), ((Map)languageMapping.get(j)).get("text")));
                columnInfo.setColumnIndex(i);
                columnInfo.setDataType(1);
                columnInfo.setMultiLanFieldSupport(true);
                list.add(columnInfo);
                ++i;
                ++j;
            }
            j = 0;
            while (j < languageMapping.size()) {
                columnName = MessageFormat.format("{0}.{1}", "firstName", ((Map)languageMapping.get(j)).get("locale"));
                columnInfo = BaseColumnInfo.createDynamicColumn((String)columnName, (String)"", (boolean)isNecessary);
                columnInfo.setName(MessageFormat.format("{0}.{1}", SHRWebResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource", (String)"EMP_FIRSTNAME", (Context)ctx), ((Map)languageMapping.get(j)).get("text")));
                columnInfo.setColumnIndex(i);
                columnInfo.setDataType(1);
                columnInfo.setMultiLanFieldSupport(true);
                list.add(columnInfo);
                ++i;
                ++j;
            }
        } else {
            int j = 0;
            while (j < languageMapping.size()) {
                columnName = MessageFormat.format("{0}.{1}", "name", ((Map)languageMapping.get(j)).get("locale"));
                columnInfo = BaseColumnInfo.createDynamicColumn((String)columnName, (String)"", (boolean)false);
                columnInfo.setName(MessageFormat.format("{0}.{1}", SHRWebResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource", (String)"EMP_NAME", (Context)ctx), ((Map)languageMapping.get(j)).get("text")));
                columnInfo.setColumnIndex(i);
                columnInfo.setDataType(1);
                columnInfo.setMultiLanFieldSupport(true);
                list.add(columnInfo);
                ++i;
                ++j;
            }
        }
        return list;
    }
}

