/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.customer.gtiit.rpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.form.json.JSONException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.customer.gtiit.entity.VacationInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONObject;
import org.springframework.ui.ModelMap;

public class FacultyAbsenceSummaryListHandler
extends ListHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.customer.gtiit.rpt.FacultyAbsenceSummaryListHandler");
    Context ctx = SHRContext.getInstance().getContext();
    private int totalCount;

    public String getGridColModelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException, BOSException, SQLException {
        ArrayList<String> colNames = this.getcolNamesAction();
        List<Map<String, Object>> colModel = this.getcolModelAction();
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>();
        map.put("colNames", colNames);
        map.put("colModel", colModel);
        JSONUtils.writeJson((HttpServletResponse)response, map);
        return null;
    }

    public void getGridDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SQLException, SHRWebException, JSONException {
        logger.info((Object)">>> FacultyAbsenceSummaryReportHandler...getGridDataAction");
        int rows = Integer.parseInt(request.getParameter("rows"));
        int page = Integer.parseInt(request.getParameter("page"));
        String fastFilterItems = request.getParameter("fastFilterItems");
        JSONObject tofastFilterItems = new JSONObject(fastFilterItems);
        JSONObject queryTime = tofastFilterItems.getJSONObject("queryTime");
        String pvalues = queryTime.getString("values");
        String startDate = null;
        String endDate = null;
        if (ObjectUtils.isNotEmpty((Object)pvalues)) {
            JSONObject periodEmploymentValues = queryTime.getJSONObject("values");
            startDate = periodEmploymentValues.getString("startDate");
            endDate = periodEmploymentValues.getString("endDate");
        }
        String approvedSql = this.approvedSql(startDate, endDate);
        String searchFilterItems = request.getParameter("searchFilterItems");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{searchFilterItems})) {
            String filterItmes = this.getSearchFilterItems(searchFilterItems);
            approvedSql = String.valueOf(approvedSql) + " and " + filterItmes;
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)approvedSql);
        List<String> workDaysList = this.workDays(startDate, endDate);
        Map<String, VacationInfo> approvedlMap = this.executeMethod(rs, startDate, endDate, workDaysList);
        int num = 0;
        ArrayList maplist = new ArrayList();
        rs.beforeFirst();
        HashSet<String> numberSet = new HashSet<String>();
        while (rs.next()) {
            if (!numberSet.contains(rs.getString("staffid")) && ++num >= rows * (page - 1) + 1 && num <= rows * page) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                VacationInfo vacationInfo = approvedlMap.get(rs.getString("staffid"));
                map.put("StaffID", rs.getString("staffid"));
                map.put("Name", rs.getString("name"));
                map.put("Title", rs.getString("title"));
                map.put("AcademicTitle", rs.getString("academictitle"));
                map.put("Program", rs.getString("program"));
                map.put("AnnualLeave(Days)", vacationInfo.getAnnualLeave());
                map.put("BusinessTrip(Days)", vacationInfo.getBusinessTrip());
                map.put("OtherLeave(Days)", vacationInfo.getOtherLeave());
                map.put("InCampus(Days)", vacationInfo.getInCampus());
                map.put("AnnualLeave(%)", vacationInfo.getPercentageAnnualLeave());
                map.put("BusinessTrip(%)", vacationInfo.getPercentageBusinessTrip());
                map.put("OtherLeave(%)", vacationInfo.getPercentageOtherLeave());
                map.put("InCampus(%)", vacationInfo.getPercentageInCampus());
                maplist.add(map);
            }
            numberSet.add(rs.getString("staffid"));
        }
        System.out.print("num\u662f" + num);
        this.totalCount = num;
        LinkedHashMap<String, Serializable> gridDataMap = new LinkedHashMap<String, Serializable>();
        if (this.totalCount % rows == 0) {
            gridDataMap.put("total", Integer.valueOf(this.totalCount / rows));
        } else {
            gridDataMap.put("total", Integer.valueOf(this.totalCount / rows + 1));
        }
        gridDataMap.put("page", Integer.valueOf(page));
        gridDataMap.put("records", Integer.valueOf(this.totalCount));
        gridDataMap.put("rows", maplist);
        JSONUtils.writeJson((HttpServletResponse)response, gridDataMap);
    }

    public Map<String, VacationInfo> executeMethod(IRowSet rs, String startDate, String endDate, List<String> list) {
        Set<String> policySet = this.getPolicy();
        Set<String> businessIdSet = this.getBusinessId();
        Set<String> otherIdSet = this.otherId();
        Map<String, VacationInfo> calcuteVacationMap = this.calcuteVacation(rs, policySet, otherIdSet, businessIdSet, list);
        Map<String, VacationInfo> percentageLeavelMap = this.percentageLeavel(calcuteVacationMap, new BigDecimal(list.size()));
        return percentageLeavelMap;
    }

    public ArrayList<String> getcolNamesAction() throws SHRWebException {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Staff ID");
        list.add("Name");
        list.add("Title");
        list.add("Academic Title");
        list.add("Program");
        list.add("Annual Leave (Days)");
        list.add("Business Trip (Days)");
        list.add("Other Leave (Days)");
        list.add("In Campus (Days)");
        list.add("Annual Leave (%)");
        list.add("Business Trip (%)");
        list.add("Other Leave (%)");
        list.add("In Campus (%)");
        return list;
    }

    public List<Map<String, Object>> getcolModelAction() {
        ArrayList<Map<String, Object>> modelColList = new ArrayList<Map<String, Object>>();
        modelColList.add(this.buildColModelMap("StaffID", "Staff ID", 120));
        modelColList.add(this.buildColModelMap("Name", "Name", 120));
        modelColList.add(this.buildColModelMap("Title", "Title", 120));
        modelColList.add(this.buildColModelMap("AcademicTitle", "Academic Title", 120));
        modelColList.add(this.buildColModelMap("Program", "Program", 120));
        modelColList.add(this.buildColModelMap("AnnualLeave(Days)", "Annual Leave (Days)", 120));
        modelColList.add(this.buildColModelMap("BusinessTrip(Days)", "Business Trip (Days)", 120));
        modelColList.add(this.buildColModelMap("OtherLeave(Days)", "Other Leave (Days)", 120));
        modelColList.add(this.buildColModelMap("InCampus(Days)", "In Campus (Days)", 120));
        modelColList.add(this.buildColModelMap("AnnualLeave(%)", "Annual Leave (%)", 120));
        modelColList.add(this.buildColModelMap("BusinessTrip(%)", "Business Trip (%)", 120));
        modelColList.add(this.buildColModelMap("OtherLeave(%)", "Other Leave (%)", 120));
        modelColList.add(this.buildColModelMap("InCampus(%)", "In Campus (%)", 120));
        return modelColList;
    }

    private Map<String, Object> buildColModelMap(String index, String label, int width) {
        return this.buildColModelMap(index, label, width, false, false, false);
    }

    private Map<String, Object> buildColModelMap(String index, String label, int width, boolean rowspan, boolean isKey, boolean isHedden) {
        LinkedHashMap<String, Object> gridIdMap = new LinkedHashMap<String, Object>();
        gridIdMap.put("index", index);
        gridIdMap.put("name", index);
        gridIdMap.put("label", label);
        gridIdMap.put("width", width);
        if (rowspan) {
            gridIdMap.put("rowspan", rowspan);
        }
        if (isKey) {
            gridIdMap.put("key", isKey);
        }
        if (isHedden) {
            gridIdMap.put("hidden", isHedden);
        }
        return gridIdMap;
    }

    public String approvedSql(String startDate, String endDate) {
        Date nowDate = new Date();
        String nowdate = this.getDate(nowDate);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT g.fnumber as staffid,d.fname_l1 as title,d.cflongname_l1 as AcademicTitle , e.fname_l1 as Program,g.fname_l1 as name,g.fid,j.toleavelenth as leavelenth,j.fpolicyid as cfpolicy,g.fid,j.fleavedate\r\n FROM T_HR_EmpOrgRelation a \r\nleft join T_ORG_Position d on d.fid  = a.fpositionid  left join T_ORG_BaseUnit e on e.fid = a.FAdminOrgID left join T_ORG_Job f on f.fid=d.fjobid\r\nleft join t_bd_person g on g.fid=a.fpersonid\r\nleft join T_HR_EmpLaborRelationHis i on i.fpersonid=g.fid\r\nleft join  T_HR_BDEmployeeType  h on h.fid=i.flaborrelationstateid\r\nleft join (SELECT case when a.fleaveunit=2 then ROUND(a.fleavelength / 7.5, 2) else a.fleavelength end as toleavelenth,a.* FROM T_HR_ATS_LeaveBillDetail a where a.fleavedate >='" + startDate + "' and a.fleavedate <='" + endDate + "')j\r\n" + "on j.fproposerid=a.fpersonid\r\n" + "where f.fnumber='114'and d.fname_l1 not LIKE '%Visiting%'\r\n" + "and i.feffdt<='" + nowdate + "' and i.fleffdt>='" + nowdate + "'\r\n" + "and a.feffdt<='" + nowdate + "' and a.fleffdt>='" + nowdate + "'\r\n" + "and h.finservice='1'");
        System.out.print("summary\u5ba1\u6279\u901a\u8fc7\u7684sql" + sql.toString());
        return sql.toString();
    }

    public Set<String> getPolicy() {
        HashSet<String> policySet = new HashSet<String>();
        String sql = "SELECT cfpolicy FROM CT_ATS_AtsLeaveBillDetailSame where cfpolicy in(select fid from T_HR_ATS_HolidayPolicy where fholidaytypeid in (select fid from T_HR_ATS_HolidayType where fnumber  in('JQLX000001Y')));";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                policySet.add(rs.getString("cfpolicy"));
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
        return policySet;
    }

    public Set<String> otherId() {
        HashSet<String> otherSet = new HashSet<String>();
        String sql = "SELECT cfpolicy FROM CT_ATS_AtsLeaveBillDetailSame where cfpolicy in(select fid from T_HR_ATS_HolidayPolicy where fholidaytypeid in (select fid from T_HR_ATS_HolidayType where fnumber not in('JQLX000020Y','JQLX000001Y')));";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                otherSet.add(rs.getString("cfpolicy"));
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
        return otherSet;
    }

    public Set<String> getBusinessId() {
        HashSet<String> businessSet = new HashSet<String>();
        String sql = "SELECT cfpolicy FROM CT_ATS_AtsLeaveBillDetailSame where cfpolicy in(select fid from T_HR_ATS_HolidayPolicy where fholidaytypeid in (select fid from T_HR_ATS_HolidayType where fnumber  in('JQLX000020Y')));";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (rs.next()) {
                businessSet.add(rs.getString("cfpolicy"));
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
        return businessSet;
    }

    public Map<String, VacationInfo> calcuteVacation(IRowSet rs, Set<String> policySet, Set<String> otherSet, Set<String> businessSet, List<String> dateList) {
        HashMap<String, VacationInfo> vacationMap = new HashMap<String, VacationInfo>();
        try {
            while (rs.next()) {
                VacationInfo vaction = new VacationInfo();
                String stattId = rs.getString("staffid");
                String leavedate = this.getDate(rs.getDate("fleavedate"));
                BigDecimal leavelenth = rs.getBigDecimal("leavelenth") == null ? new BigDecimal("0.00") : rs.getBigDecimal("leavelenth").setScale(2, RoundingMode.HALF_UP);
                String cfpolicy = rs.getString("cfpolicy");
                if (!vacationMap.containsKey(stattId)) {
                    if (policySet.contains(cfpolicy)) {
                        vaction.setAnnualLeave(leavelenth);
                        vaction.setBusinessTrip(new BigDecimal("0.00"));
                        vaction.setOtherLeave(new BigDecimal("0.00"));
                    }
                    if (businessSet.contains(cfpolicy)) {
                        if (dateList.contains(leavedate)) {
                            vaction.setBusinessTrip(leavelenth);
                        }
                        vaction.setAnnualLeave(new BigDecimal("0.00"));
                        vaction.setOtherLeave(new BigDecimal("0.00"));
                    }
                    if (otherSet.contains(cfpolicy)) {
                        vaction.setOtherLeave(leavelenth);
                        vaction.setBusinessTrip(new BigDecimal("0.00"));
                        vaction.setAnnualLeave(new BigDecimal("0.00"));
                    }
                    vacationMap.put(stattId, vaction);
                    continue;
                }
                VacationInfo vacationInfo = (VacationInfo)vacationMap.get(stattId);
                if (policySet.contains(cfpolicy)) {
                    BigDecimal annualLeave = vacationInfo.getAnnualLeave();
                    if (annualLeave != null) {
                        vacationInfo.setAnnualLeave(annualLeave.add(leavelenth));
                    } else {
                        vacationInfo.setAnnualLeave(new BigDecimal(0).add(leavelenth));
                    }
                }
                if (businessSet.contains(cfpolicy)) {
                    BigDecimal businessTrip = vacationInfo.getBusinessTrip();
                    if (dateList.contains(leavedate)) {
                        if (businessTrip != null) {
                            vacationInfo.setBusinessTrip(businessTrip.add(leavelenth));
                        } else {
                            vacationInfo.setBusinessTrip(new BigDecimal(0).add(leavelenth));
                        }
                    }
                }
                if (otherSet.contains(cfpolicy)) {
                    BigDecimal otherLeave = vacationInfo.getOtherLeave();
                    vacationInfo.setOtherLeave(otherLeave.add(leavelenth));
                }
                vacationMap.put(stattId, vacationInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return vacationMap;
    }

    public Map<String, VacationInfo> percentageLeavel(Map<String, VacationInfo> vacationMap, BigDecimal intAsBigDecimal) {
        System.out.print("\u5de5\u4f5c\u65e5\u5929\u6570" + intAsBigDecimal);
        HashMap<String, VacationInfo> peracentageMap = new HashMap<String, VacationInfo>();
        for (String key : vacationMap.keySet()) {
            VacationInfo vacationInfo = vacationMap.get(key);
            BigDecimal annualLeave = vacationInfo.getAnnualLeave() == null ? new BigDecimal("0.00") : vacationInfo.getAnnualLeave();
            BigDecimal businessTrip = vacationInfo.getBusinessTrip() == null ? new BigDecimal("0.00") : vacationInfo.getBusinessTrip();
            BigDecimal otherLeave = vacationInfo.getOtherLeave() == null ? new BigDecimal("0.00") : vacationInfo.getOtherLeave();
            BigDecimal inCampus = intAsBigDecimal.subtract(annualLeave).subtract(businessTrip).subtract(otherLeave);
            vacationInfo.setInCampus(inCampus);
            BigDecimal percentageAnnualeave = annualLeave.divide(intAsBigDecimal, 4, RoundingMode.HALF_UP);
            BigDecimal percentagebusinessTrip = businessTrip.divide(intAsBigDecimal, 4, RoundingMode.HALF_UP);
            BigDecimal percentageotherLeave = otherLeave.divide(intAsBigDecimal, 4, RoundingMode.HALF_UP);
            BigDecimal one = new BigDecimal(1);
            BigDecimal percentageinCampus = one.subtract(percentageAnnualeave).subtract(percentagebusinessTrip).subtract(percentageotherLeave);
            vacationInfo.setPercentageAnnualLeave(percentageAnnualeave.multiply(new BigDecimal(100)));
            vacationInfo.setPercentageBusinessTrip(percentagebusinessTrip.multiply(new BigDecimal(100)));
            vacationInfo.setPercentageOtherLeave(percentageotherLeave.multiply(new BigDecimal(100)));
            vacationInfo.setPercentageInCampus(percentageinCampus.multiply(new BigDecimal(100)));
            vacationInfo.setAnnualLeave(annualLeave);
            vacationInfo.setOtherLeave(otherLeave);
            vacationInfo.setBusinessTrip(businessTrip);
            peracentageMap.put(key, vacationInfo);
        }
        return peracentageMap;
    }

    public List<String> workDays(String startDate, String endDate) {
        ArrayList<String> workList = new ArrayList<String>();
        String sql = "SELECT * FROM  T_HR_ATS_WorkCalendarItem where fdaytype='0' and fdate>='" + startDate + "' and  fdate<='" + endDate + "'";
        try {
            IRowSet executeQuery = DbUtil.executeQuery((Context)this.ctx, (String)sql);
            while (executeQuery.next()) {
                workList.add(this.getDate(executeQuery.getDate("fdate")));
            }
        }
        catch (BOSException | SQLException e) {
            e.printStackTrace();
        }
        return workList;
    }

    public String toExcelAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws BOSException, SQLException, SHRWebException {
        String fastFilterItems = request.getParameter("fastFilterItems");
        JSONObject tofastFilterItems = new JSONObject(fastFilterItems);
        JSONObject queryTime = tofastFilterItems.getJSONObject("queryTime");
        String pvalues = queryTime.getString("values");
        String startDate = null;
        String endDate = null;
        if (ObjectUtils.isNotEmpty((Object)pvalues)) {
            JSONObject periodEmploymentValues = queryTime.getJSONObject("values");
            startDate = periodEmploymentValues.getString("startDate");
            endDate = periodEmploymentValues.getString("endDate");
        }
        String approvedSql = this.approvedSql(startDate, endDate);
        String searchFilterItems = request.getParameter("searchFilterItems");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{searchFilterItems})) {
            String filterItmes = this.getSearchFilterItems(searchFilterItems);
            approvedSql = String.valueOf(approvedSql) + " and " + filterItmes;
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)approvedSql);
        List<String> workDaysList = this.workDays(startDate, endDate);
        Map<String, VacationInfo> approvedlMap = this.executeMethod(rs, startDate, endDate, workDaysList);
        LinkedHashMap<String, String> selectFieldsTypeMap = new LinkedHashMap<String, String>();
        String stringType = "String_@";
        String numberType = "Number_.";
        selectFieldsTypeMap.put("staffid", stringType);
        selectFieldsTypeMap.put("name", stringType);
        selectFieldsTypeMap.put("title", stringType);
        selectFieldsTypeMap.put("academictitle", stringType);
        selectFieldsTypeMap.put("Program", stringType);
        selectFieldsTypeMap.put("AnnualLeaveDays", numberType);
        selectFieldsTypeMap.put("BusinessTripDays", numberType);
        selectFieldsTypeMap.put("OtherLeaveDays", numberType);
        selectFieldsTypeMap.put("InCampusDays", numberType);
        selectFieldsTypeMap.put("AnnualLeave", numberType);
        selectFieldsTypeMap.put("BusinessTrip", numberType);
        selectFieldsTypeMap.put("OtherLeave", numberType);
        selectFieldsTypeMap.put("InCampus", numberType);
        ArrayList<String> list = this.getcolNamesAction();
        FacultyAbsenceSummaryListHandler.exportData(response, rs, "FacultyAbsenceSummaryReport.xlsx", selectFieldsTypeMap, list, approvedlMap);
        return null;
    }

    public String getSearchFilterItems(String searchFilterItems) {
        String filter = null;
        if (StringUtils.isNotBlank((CharSequence)searchFilterItems)) {
            if (searchFilterItems.indexOf("name") != -1) {
                filter = searchFilterItems.replaceAll("name", "g.fname_l1");
            }
            if (searchFilterItems.indexOf("number") != -1) {
                filter = searchFilterItems.replaceAll("number", "g.fnumber");
            }
        }
        if (filter != null) {
            return filter.replace("(", "").replace(")", "");
        }
        return filter;
    }

    public static void exportData(HttpServletResponse response, Object resource, String fileName, LinkedHashMap<String, String> selectFieldsTypeMap, List<String> list, Map<String, VacationInfo> percentageLeavelMap) throws SQLException {
        XSSFWorkbook workBook = new XSSFWorkbook();
        XSSFSheet sheet = workBook.createSheet("Sheet1");
        XSSFDataFormat format = workBook.createDataFormat();
        if (resource != null && resource instanceof IRowSet) {
            IRowSet rs = (IRowSet)resource;
            int numColumns = selectFieldsTypeMap.entrySet().size();
            int i = 0;
            XSSFRow titleRow = sheet.createRow(i);
            List keyList = selectFieldsTypeMap.keySet().stream().collect(Collectors.toList());
            XSSFFont font = workBook.createFont();
            font.setFontName("\u5b8b\u4f53");
            font.setFontHeightInPoints((short)11);
            font.setColor(IndexedColors.BLACK.getIndex());
            font.setBold(true);
            XSSFCellStyle cellStyle = workBook.createCellStyle();
            cellStyle.setFont((Font)font);
            if (i == 0) {
                int j = 0;
                while (j < numColumns) {
                    XSSFCell cell = titleRow.createCell(j);
                    cell.setCellValue(list.get(j));
                    sheet.setColumnWidth(j, 5000);
                    titleRow.getCell(j).setCellStyle((CellStyle)cellStyle);
                    ++j;
                }
            }
            ++i;
            HashSet<String> staffSet = new HashSet<String>();
            rs.beforeFirst();
            while (rs.next()) {
                System.out.print("\u8fdb\u6765\u4e86while\u5faa\u73af");
                try {
                    if (!staffSet.contains(rs.getString("staffid"))) {
                        VacationInfo vacationInfo = percentageLeavelMap.get(rs.getString("staffid"));
                        XSSFRow dateRow = sheet.createRow(i);
                        System.out.print("IIIII\u662f" + i);
                        int j = 0;
                        while (j < numColumns) {
                            XSSFCell cell = dateRow.createCell(j);
                            String column = (String)keyList.get(j);
                            String fieldTypeAndcellStyleType = selectFieldsTypeMap.get(column);
                            int indexOf = fieldTypeAndcellStyleType.indexOf("_");
                            String fieldType = fieldTypeAndcellStyleType.substring(0, indexOf);
                            String cellStyleType = fieldTypeAndcellStyleType.substring(indexOf + 1, fieldTypeAndcellStyleType.length());
                            if ("AnnualLeaveDays".equals(column)) {
                                cell.setCellValue(vacationInfo.getAnnualLeave().toString());
                            } else if ("BusinessTripDays".equals(column)) {
                                cell.setCellValue(vacationInfo.getBusinessTrip().toString());
                            } else if ("OtherLeaveDays".equals(column)) {
                                cell.setCellValue(vacationInfo.getOtherLeave().toString());
                            } else if ("InCampusDays".equals(column)) {
                                cell.setCellValue(vacationInfo.getInCampus().toString());
                            } else if ("AnnualLeave".equals(column)) {
                                cell.setCellValue(vacationInfo.getPercentageAnnualLeave().setScale(2).toString());
                            } else if ("BusinessTrip".equals(column)) {
                                cell.setCellValue(vacationInfo.getPercentageBusinessTrip().setScale(2).toString());
                            } else if ("OtherLeave".equals(column)) {
                                cell.setCellValue(vacationInfo.getPercentageOtherLeave().setScale(2).toString());
                            } else if ("InCampus".equals(column)) {
                                cell.setCellValue(vacationInfo.getPercentageInCampus().setScale(2).toString());
                            } else {
                                cell.setCellValue(rs.getString(column));
                            }
                            ++j;
                        }
                        ++i;
                    }
                    staffSet.add(rs.getString("staffid"));
                }
                catch (Exception e) {
                    logger.info((Object)("Excel file was created Error!" + e.getMessage()));
                }
            }
            try {
                FacultyAbsenceSummaryListHandler.setResponseHeader(response, fileName);
                ServletOutputStream os = response.getOutputStream();
                workBook.write((OutputStream)os);
                workBook.close();
                os.flush();
                os.close();
                logger.info((Object)"Excel file was created successfully!");
            }
            catch (IOException e) {
                logger.info((Object)("Error while writing to file " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }

    public static void setResponseHeader(HttpServletResponse response, String fileName) {
        try {
            try {
                fileName = URLEncoder.encode(fileName, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            response.setContentType("application/octet-stream;charset=UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + fileName);
            response.addHeader("Pargam", "no-cache");
            response.addHeader("Cache-Control", "no-cache");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (date == null) {
            return null;
        }
        return sdf.format(date);
    }
}

