/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.workflow.event;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.define.ProcessType;
import com.kingdee.bos.workflow.define.Resource;
import com.kingdee.bos.workflow.enactment.WfEngine;
import com.kingdee.bos.workflow.enactment.message.WfMessage;
import com.kingdee.bos.workflow.event.WfEventType;
import com.kingdee.bos.workflow.util.ApplicationUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mobile.msg.IMobileAppMsgFacade;
import com.kingdee.eas.mobile.msg.MobileAppMsgFacadeFactory;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class WfEvent {
    private static final Logger logger = Logger.getLogger(WfEvent.class);
    public static final String EVENT_MESSAGE_DOMAIN = "kingdee.bos.workflow.event";
    public static final String HEADER_NAME_PROCESSDEFID = "processDefId";
    public static final String HEADER_NAME_PROCESSDEFVERSION = "processDefVersion";
    public static final String HEADER_NAME_ACTDEFID = "actDefId";
    public static final String HEADER_NAME_PROCESSID = "processId";
    public static final String HEADER_NAME_ACTIVITYID = "activityId";
    public static final String HEADER_NAME_EVENTTYPE = "eventType";
    private int eventId;
    private String processDefId;
    private int processDefVersion;
    private String actDefId;
    private String processId;
    private Resource processName;
    private String activityId;
    private WfEventType eventType;
    private HashMap parameters;
    private String receiverList;
    private String sourceids;
    private WfEngine engine;
    private ProcessType wfType;

    public WfEvent(WfEngine engine) {
        this.engine = engine;
    }

    public int getEventId() {
        return this.eventId;
    }

    public Map getParameters() {
        return (Map)this.parameters.clone();
    }

    public void setParameters(HashMap map) {
        this.parameters = map;
    }

    public Object getParameters(Object key) {
        return this.parameters.get(key);
    }

    public WfEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(WfEventType type) {
        this.eventType = type;
    }

    public String getActDefId() {
        return this.actDefId;
    }

    public void setActDefId(String actDefId) {
        this.actDefId = actDefId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public String getProcessDefId() {
        return this.processDefId;
    }

    public void setProcessDefId(String processDefId) {
        this.processDefId = processDefId;
    }

    public int getProcessDefVersion() {
        return this.processDefVersion;
    }

    public void setProcessDefVersion(int processDefVersion) {
        this.processDefVersion = processDefVersion;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setWfType(ProcessType wfType) {
        this.wfType = wfType;
    }

    public ProcessType getWfType() {
        return this.wfType;
    }

    private String getEventName(Locale locale) {
        if (locale == null) {
            return this.eventType.getName();
        }
        if (!ProcessType.BACKGROUNDJOB.equals((Object)this.wfType)) {
            return this.eventType.getName(locale);
        }
        if ("l2".equalsIgnoreCase(locale.toString())) {
            if (this.eventType.equals((Object)WfEventType.PROCESS_STARTED)) {
                return "\u540e\u53f0\u4e8b\u52a1\u5df2\u7ecf\u542f\u52a8";
            }
            if (this.eventType.equals((Object)WfEventType.PROCESS_COMPLETED)) {
                return "\u540e\u53f0\u4e8b\u52a1\u5df2\u7ecf\u5b8c\u6210";
            }
            if (this.eventType.equals((Object)WfEventType.DEADLINE)) {
                return "\u540e\u53f0\u4e8b\u52a1\u5df2\u7ecf\u5230\u8fbe\u671f\u9650";
            }
            if (this.eventType.equals((Object)WfEventType.PROCESS_SUSPENDED)) {
                return "\u540e\u53f0\u4e8b\u52a1\u5df2\u7ecf\u6302\u8d77";
            }
        }
        if ("l3".equalsIgnoreCase(locale.toString())) {
            if (this.eventType.equals((Object)WfEventType.PROCESS_STARTED)) {
                return "\u5f8c\u81fa\u4e8b\u52d9\u5df2\u7d93\u555f\u52d5";
            }
            if (this.eventType.equals((Object)WfEventType.PROCESS_COMPLETED)) {
                return "\u5f8c\u81fa\u4e8b\u52d9\u5df2\u7d93\u5b8c\u6210";
            }
            if (this.eventType.equals((Object)WfEventType.DEADLINE)) {
                return "\u5f8c\u81fa\u4e8b\u52d9\u5df2\u7d93\u5230\u9054\u671f\u9650";
            }
            if (this.eventType.equals((Object)WfEventType.PROCESS_SUSPENDED)) {
                return "\u5f8c\u81fa\u4e8b\u52d9\u5df2\u7d93\u639b\u8d77";
            }
        }
        return this.eventType.getName();
    }

    public Message toMessage() {
        String content;
        WfMessage message = null;
        message = new WfMessage();
        ProcessInstInfo procInfo = null;
        String code = "";
        String title = "";
        String topic = "";
        try {
            procInfo = this.engine.getProcessInst(this.processId).getData();
            code = procInfo.getCode();
        }
        catch (WfException var10) {
            logger.error((Object)"\u83b7\u53d6procInfo\u62a5\u9519", (Throwable)var10);
        }
        Locale[] locales = ApplicationUtil.getContextLocales((Context)this.engine.context());
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            topic = procInfo.getMeta().getProcInstTopic(locale);
            title = topic != null ? topic : "process name" + this.getProcessName().getValue(locale) + this.getEventName(locale);
            if ("BACKGROUNDJOB".equals(procInfo.getMeta().getProcdefType())) {
                message.addContent("\u8bf7\u901a\u8fc7 \u201c \u7cfb\u7edf\u529f\u80fd -> \u540e\u53f0\u4e8b\u52a1 -> \u540e\u53f0\u4e8b\u52a1\u76d1\u63a7\u201d \u67e5\u770b \u201c\u7f16\u7801\u201d \u4e3a{ " + code + " }\u7684\u540e\u53f0\u4e8b\u52a1\u7684\u9519\u8bef\u65e5\u5fd7\uff0c\u4e86\u89e3\u6302\u8d77\u539f\u56e0\u6216\u4fee\u590d\u6b64\u4e8b\u52a1\u3002", locale);
            } else {
                content = String.valueOf(title) + " was aborted due to an error. For details, please contact IT (itsupport@gtiit.edu.cn) and HR(hr@gtiit.edu.cn) for help.";
                message.addContent(content, locale);
            }
            message.addSubject(title, locale);
            message.addInitiatorName(procInfo.getInitiatorName(locale), locale);
            ++i;
        }
        message.setInitiatorId(procInfo.getInitiatorId());
        message.setContext(this.engine.context());
        message.setReceiver(this.receiverList);
        message.setProcessDefHashValue(procInfo.getProcDefHashValue());
        message.setProcessDefId(this.getProcessDefId());
        message.setProcessInstId(this.getProcessId());
        message.setActivityDefId(this.getActDefId());
        message.setActivityInstId(this.getActivityId());
        message.setSourceIds(this.getSourceIds());
        String suspend = null;
        if (this.parameters != null) {
            suspend = (String)this.parameters.get("suspendValue");
        }
        if (suspend != null) {
            message.setIsParamSuspend(Boolean.valueOf(true));
        }
        if (WfEventType.PROCESS_SUSPENDED.equals((Object)this.getEventType())) {
            String isEmail = String.valueOf(this.getParameters("suspendEmail"));
            content = String.valueOf(this.getParameters("suspendSms"));
            if ("true".equals(isEmail) && "true".equals(content)) {
                message.setContentType(7);
            } else if ("true".equals(isEmail)) {
                message.setContentType(3);
            }
        }
        message.fillMessage();
        return message.getMessage();
    }

    public void sendEmailWhenSuspend() throws EASBizException, BOSException {
        IMobileAppMsgFacade iMsg = MobileAppMsgFacadeFactory.getLocalInstance((Context)this.engine.context());
        iMsg.mobileAppListener(this.toMessage());
    }

    public static WfEvent FromMessage(WfEngine engine, Message message) {
        WfEvent event = new WfEvent(engine);
        event.processDefId = message.getStringHeader(HEADER_NAME_PROCESSDEFID);
        event.processDefVersion = message.getIntHeader(HEADER_NAME_PROCESSDEFVERSION);
        event.actDefId = message.getStringHeader(HEADER_NAME_ACTDEFID);
        event.processId = message.getStringHeader(HEADER_NAME_PROCESSID);
        event.activityId = message.getStringHeader(HEADER_NAME_ACTIVITYID);
        event.eventType = WfEventType.getEnum((String)message.getStringHeader(HEADER_NAME_EVENTTYPE));
        return event;
    }

    public String dump() {
        StringBuffer dest = new StringBuffer();
        dest.append("eventType = ");
        dest.append(this.eventType.getName());
        dest.append("\n");
        dest.append("processDefId = ");
        dest.append(this.processDefId);
        dest.append("\n");
        dest.append("processDefVersion = ");
        dest.append(this.processDefVersion);
        dest.append("\n");
        dest.append("actDefId = ");
        dest.append(this.actDefId);
        dest.append("\n");
        dest.append("processId = ");
        dest.append(this.processId);
        dest.append("\n");
        dest.append("activityId = ");
        dest.append(this.activityId);
        dest.append("\n");
        return dest.toString();
    }

    public String getReceiverList() {
        return this.receiverList;
    }

    public void setReceiverList(String string) {
        this.receiverList = string;
    }

    public Resource getProcessName() {
        return this.processName;
    }

    public void setProcessName(Resource resource) {
        this.processName = resource;
    }

    public String getSourceIds() {
        return this.sourceids;
    }

    public void setSourceIds(String sourceids) {
        this.sourceids = sourceids;
    }
}

