/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.erp.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.custom.erp.util.HttpsReqUtil;
import com.kingdee.eas.custom.erp.util.SynPublicUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SynSalaryFromErpUtils {
    private static Logger log = LoggerFactory.getLogger(SynSalaryFromErpUtils.class);
    private static String ierp = "https://sites.gtiit.edu.cn/kderpdev/ierp";
    private static String appId = "gtiit_sq";
    private static String appSecret = "Kingdee@2024Kingdee@2024";
    private static String tenantid = "ierp-client";
    private static String accountId = "1917417602120941568";
    private static String user = "jiekouyonghu";
    private static String usertype = "UserName";
    private static final List<String> sList = new ArrayList<String>(){
        {
            this.add("Value1");
            this.add("Value2");
            this.add("Value3");
        }
    };

    public static String getAllAppTokenUrl() {
        Properties config = SynPublicUtils.getConfig();
        ierp = (String)config.get("ierp");
        return new StringBuffer().append(ierp).append("/api/getAppToken.do").toString();
    }

    public static String getAllGt15_save_paydetailUrl() {
        Properties config = SynPublicUtils.getConfig();
        ierp = (String)config.get("ierp");
        return new StringBuffer().append(ierp).append("/kapi/v2/gt15/em/gt15_paydetail/gt15_save_paydetail").toString();
    }

    public static String getAllAccessTokenUrl(String apptoken) {
        Properties config = SynPublicUtils.getConfig();
        ierp = (String)config.get("ierp");
        return new StringBuffer().append(ierp).append("/api/login.do").toString();
    }

    public static String getAppToken(Context ctx) throws Exception {
        String appToken = "";
        String allAppTokenUrl = SynSalaryFromErpUtils.getAllAppTokenUrl();
        log.info("getAppToken.allAppTokenUrl :" + allAppTokenUrl);
        Properties config = SynPublicUtils.getConfig();
        appId = (String)config.get("appId");
        appSecret = (String)config.get("appSecret");
        tenantid = (String)config.get("tenantid");
        accountId = (String)config.get("accountId");
        JSONObject jo = new JSONObject();
        jo.put("appId", (Object)appId);
        jo.put("appSecret", (Object)appSecret);
        jo.put("tenantid", (Object)tenantid);
        jo.put("accountId", (Object)accountId);
        String param = jo.toString();
        log.info("getAppToken.param :" + param);
        String appTokenResult = HttpsReqUtil.postByHttps(allAppTokenUrl, param);
        log.info("getAppToken.appTokenResult :" + appTokenResult);
        if (StringUtils.isEmpty((String)appTokenResult)) {
            log.info("\u83b7\u53d6appTokenResult\u5f02\u5e38\uff1a" + appTokenResult);
            return appToken;
        }
        JSONObject json = JSON.parseObject((String)appTokenResult);
        String state = json.getString("state");
        boolean status = json.getBoolean("status");
        if (!"success".equals(state)) {
            log.info("\u83b7\u53d6appTokenResult.state\u72b6\u6001\u4e3a\uff1a" + state);
            return appToken;
        }
        if (!status) {
            log.info("\u83b7\u53d6appTokenResult.status\u72b6\u6001\u4e3a\uff1a" + status);
            return appToken;
        }
        JSONObject dataObjec = json.getJSONObject("data");
        if (dataObjec == null) {
            log.info("\u83b7\u53d6appTokenResult.dataObjec\u4e3a\uff1a" + dataObjec);
            return appToken;
        }
        appToken = dataObjec.getString("app_token");
        return appToken;
    }

    public static String getAccessToken(String appToken) throws Exception {
        String allAccessTokenUrl = SynSalaryFromErpUtils.getAllAccessTokenUrl(appToken);
        log.info("getAccessToken.allAccessTokenUrl :" + allAccessTokenUrl);
        String accessToken = "";
        String param = "";
        Properties config = SynPublicUtils.getConfig();
        tenantid = (String)config.get("tenantid");
        accountId = (String)config.get("accountId");
        user = (String)config.get("user");
        usertype = (String)config.get("usertype");
        JSONObject jo = new JSONObject();
        jo.put("user", (Object)user);
        jo.put("apptoken", (Object)appToken);
        jo.put("tenantid", (Object)tenantid);
        jo.put("accountId", (Object)accountId);
        jo.put("usertype", (Object)usertype);
        param = jo.toString();
        log.info("getAccessToken.param :" + param);
        String accessTokenResult = HttpsReqUtil.postByHttps(allAccessTokenUrl, param);
        log.info("getAccessToken.accessTokenResult :" + accessTokenResult);
        if (StringUtils.isEmpty((String)accessTokenResult)) {
            log.info("accessTokenResult\uff1a" + accessTokenResult);
            return accessToken;
        }
        JSONObject json = JSON.parseObject((String)accessTokenResult);
        String state = json.getString("state");
        boolean status = json.getBoolean("status");
        if (!"success".equals(state)) {
            log.info("\u83b7\u53d6getAccessToken.state\u72b6\u6001\u4e3a\uff1a" + state);
            return accessToken;
        }
        if (!status) {
            log.info("\u83b7\u53d6getAccessToken.status\u72b6\u6001\u4e3a\uff1a" + status);
            return accessToken;
        }
        JSONObject dataObjec = json.getJSONObject("data");
        if (dataObjec == null) {
            log.info("\u83b7\u53d6getAccessToken.dataObjec\u4e3a\uff1a" + dataObjec);
            return accessToken;
        }
        accessToken = dataObjec.getString("access_token");
        return accessToken;
    }

    public static String savePaydetail2(String accessToken) throws Exception {
        String paydetailUrl = SynSalaryFromErpUtils.getAllGt15_save_paydetailUrl();
        JSONObject entryEntityJO = new JSONObject();
        entryEntityJO.put("staffNo", (Object)"ID-000043");
        entryEntityJO.put("currencyNumber", (Object)"CNY");
        entryEntityJO.put("orgNumber", (Object)"D0001");
        entryEntityJO.put("idNo", (Object)"410323");
        entryEntityJO.put("positionName", (Object)"\u5f00\u53d1");
        entryEntityJO.put("userTypeNumber", (Object)"PT01");
        entryEntityJO.put("wokerTypeNumber", (Object)"001");
        entryEntityJO.put("positionNumber", (Object)"IT-2016008");
        entryEntityJO.put("projectNumber", (Object)"A01");
        entryEntityJO.put("rate", (Object)"1.80");
        entryEntityJO.put("originalAmount", (Object)"104.04");
        entryEntityJO.put("remark", (Object)"\u5907\u6ce8");
        JSONArray entryentitys = new JSONArray();
        entryentitys.add((Object)entryEntityJO);
        JSONObject data = new JSONObject();
        data.put("period", (Object)"2024-04");
        data.put("fullOrPart", (Object)"FULL");
        data.put("entryentity", (Object)entryentitys);
        JSONArray datas = new JSONArray();
        datas.add((Object)data);
        JSONObject paramJO = new JSONObject();
        paramJO.put("data", (Object)datas);
        log.info("savePaydetail.paramJOStr:" + paramJO.toString());
        log.info("savePaydetail.paydetailUrl:" + paydetailUrl);
        log.info("savePaydetail.accessToken:" + accessToken);
        String paramJOStr = paramJO.toString();
        String responseMsg = HttpsReqUtil.postByHttps(paydetailUrl, paramJOStr, accessToken);
        return responseMsg;
    }

    public static String savePaydetail(Context ctx, String accessToken, String yearMonth) throws Exception {
        int year = 0;
        int month = 0;
        if (StringUtils.isEmpty((String)yearMonth)) {
            Calendar calendar = Calendar.getInstance();
            year = calendar.get(1);
            month = calendar.get(2) + 1;
        } else {
            String[] ym = yearMonth.split("-");
            String yearStr = ym[0];
            String monthStr = ym[1];
            year = Integer.parseInt(yearStr);
            month = Integer.parseInt(monthStr);
        }
        log.info("savePaydetail.year:" + year + ",month:" + month);
        String paydetailUrl = SynSalaryFromErpUtils.getAllGt15_save_paydetailUrl();
        String responseMsg = "";
        String paramJOStrFull = SynSalaryFromErpUtils.getFixDetailEntry(ctx, year, month, "FULL", "pgQuAkV5SAislUptF1qRWv/N8rE=");
        log.info("savePaydetail.full.paramJOStrFull:" + paramJOStrFull);
        if (!StringUtils.isEmpty((String)paramJOStrFull)) {
            responseMsg = HttpsReqUtil.postByHttps(paydetailUrl, paramJOStrFull, accessToken);
        }
        String paramJOStrPart = SynSalaryFromErpUtils.getFixDetailEntry(ctx, year, month, "PART", "lKaL/CRQTwahZivNPmnhRP/N8rE=");
        log.info("savePaydetail.part.paramJOStrPart:" + paramJOStrPart);
        if (!StringUtils.isEmpty((String)paramJOStrPart)) {
            responseMsg = HttpsReqUtil.postByHttps(paydetailUrl, paramJOStrPart, accessToken);
        }
        return responseMsg;
    }

    private static List<String> getSCmpCalTableFidFullList(Context ctx, int periodyear, int periodmonth) throws BOSException, SQLException {
        String sql = "select fid as id from T_HR_SCmpCalTable where fcalschemeid = 'pgQuAkV5SAislUptF1qRWv/N8rE=' and fcalstate = 12 and fperiodyear = " + periodyear + " and fperiodmonth =" + periodmonth;
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> SCmpCalTableFullFids = new ArrayList<String>();
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                String id = executeQuery.getString("id");
                SCmpCalTableFullFids.add(id);
            }
        }
        log.info("getSCmpCalTableFidFullList.SCmpCalTableFids.size:" + SCmpCalTableFullFids.size());
        return SCmpCalTableFullFids;
    }

    private static List<String> getSCmpCalTableFidPartList(Context ctx, int periodyear, int periodmonth) throws BOSException, SQLException {
        String sql = "select fid as id from T_HR_SCmpCalTable where fcalschemeid = 'lKaL/CRQTwahZivNPmnhRP/N8rE=' and fcalstate = 12 and fperiodyear = " + periodyear + " and fperiodmonth =" + periodmonth;
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> SCmpCalTablePartFids = new ArrayList<String>();
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                String id = executeQuery.getString("id");
                SCmpCalTablePartFids.add(id);
            }
        }
        log.info("getSCmpCalTableFidPartList.SCmpCalTableFids.size:" + SCmpCalTablePartFids.size());
        return SCmpCalTablePartFids;
    }

    private static String getFixDetailEntry(Context ctx, int periodyear, int periodmonth, String fullOrPart, String calschemeId) throws SQLException, BOSException {
        String staffNo = "";
        String staffName = "";
        String currencyNumber = "";
        String orgNumber = "";
        String idNo = "";
        String positionName = "";
        String userTypeNumber = "";
        String wokerTypeNumber = "";
        String positionNumber = "";
        Object rate = null;
        String remark = "";
        String paramJOStr = "";
        Map<String, List<String>> keyFieldSnListNumberMap = SynSalaryFromErpUtils.getFieldsnList(ctx);
        List<String> fieldSnList = keyFieldSnListNumberMap.get("fieldsnList");
        List<String> numberList = keyFieldSnListNumberMap.get("numberList");
        log.info("getFixDetailEntry.fieldSnList.size:" + fieldSnList.size());
        log.info("getFixDetailEntry.numberList.size:" + numberList.size());
        String fieldSnStr = SynSalaryFromErpUtils.getFildSnListStr(fieldSnList);
        HashMap<String, BigDecimal> snValue = new HashMap<String, BigDecimal>();
        String sql = " select scct.S272 as staffNo ,person2.fname_l2 as staffName ,scct.S62 as currencyNumber,baseUnit.fnumber as orgNumber,scct.S277 as idNo ,position.fnumber as positionName ,employeeClassify.fnumber as userTypeNumber, workerCategory.fnumber as wokerTypeNumber, t1.positionNumber as positionNumber, scct.S259 as remark,scct.S63 as rate, " + fieldSnStr + " from T_HR_SCmpCalTable scct " + " left join T_ORG_Position position on position.fid = scct.fpositionid " + " left join t_bd_Person person2 on person2.fid = scct.fpersonid " + " left join  (select op.fnumber as positionNumber ,pp.fpersonId as ppPersonId from T_HR_PersonPosition  pp\n" + " left join T_ORG_Position  op on op.fid = pp.fprimarypositionid " + " ) t1 on t1.ppPersonId = scct.fpersonId  " + " LEFT JOIN T_BD_Currency currency on currency.fid = scct.fcurrencyid " + " left join T_ORG_BaseUnit baseUnit on baseUnit.fid =  scct.fadminorgunitid " + " LEFT JOIN  T_BD_Person person on person.fid = scct.fpersonId  " + " left join  T_HR_EmployeeClassify employeeClassify on employeeClassify.fid = person.CFPersontypeID " + " left join   T_HR_EmpOrgRelation a  on a.fid=person.fid  AND TO_CHAR(a.FLEFFDT,'YYYY-MM-DD')='2199-12-31' AND a.FASSIGNTYPE=1 " + " left join ( " + " select x.fid as personId,c.fnumber as dpt_number,c.fname_l1 as dpt_name,b.fnumber as post_number,b.fname_l1 as  " + " post_name,b.fisrespposition as isincharge,d.fnumber as ispartjob,e.fnumber as superior_number,e.fname_l1 as superior_name, " + " f.fnumber as  position_number,f.fname_l1 as position_l1,f.fname_l2 as position_l2,f.fname_l3 as  " + " position_l3,a.CFWorkercategoryID as workercategoryId from t_BD_person x  " + " left join   T_HR_EmpOrgRelation a  on x.fid=a.fpersonid  AND TO_CHAR(a.FLEFFDT,'YYYY-MM-DD')='2199-12-31' AND a.FASSIGNTYPE=1  " + " left join t_org_position b on a.fpositionid=b.fid " + " left join t_org_baseunit c on b.fadminorgunitid=c.fid " + " left join CT_MP_Fullorpart d on d.fid = a.CFFtorptID " + "  left join  T_BD_Person e on e.fid = a.CFLineManagerNameI " + "  left join T_ORG_Job f on f.fid = b.FJobID " + "  ) temp on temp.personId = person.fid  " + " left join  CT_MP_WorkerCategory workerCategory on workerCategory.fid = temp.workercategoryId  " + " where scct.fperiodyear=" + periodyear + " and  scct.fperiodmonth = " + periodmonth + " and  scct.fcalschemeid = '" + calschemeId + "' and fcalstate = 12";
        log.info("getFixDetailEntry.sql:" + sql);
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        JSONArray entryentitys = new JSONArray();
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                staffNo = executeQuery.getString("staffNo");
                staffName = executeQuery.getString("staffName");
                currencyNumber = executeQuery.getString("currencyNumber");
                orgNumber = executeQuery.getString("orgNumber");
                idNo = executeQuery.getString("idNo");
                positionName = executeQuery.getString("positionName");
                userTypeNumber = executeQuery.getString("userTypeNumber");
                wokerTypeNumber = executeQuery.getString("wokerTypeNumber");
                positionNumber = executeQuery.getString("positionNumber");
                remark = executeQuery.getString("remark");
                rate = executeQuery.getObject("rate");
                int i = 0;
                while (i < fieldSnList.size()) {
                    String fieldSn = fieldSnList.get(i);
                    BigDecimal fieldSnB = executeQuery.getBigDecimal(fieldSn);
                    String number = numberList.get(i);
                    fieldSnB = fieldSnB == null ? BigDecimal.ZERO : fieldSnB;
                    snValue.put(number, fieldSnB);
                    ++i;
                }
                for (Map.Entry entry : snValue.entrySet()) {
                    log.info("Key = " + (String)entry.getKey() + ", Value = " + entry.getValue());
                    String projectNumber = (String)entry.getKey();
                    Object originalAmount = entry.getValue();
                    JSONObject entryEntityJO = new JSONObject();
                    entryEntityJO.put("staffNo", (Object)staffNo);
                    entryEntityJO.put("staffName", (Object)staffName);
                    if ("RMB".equals(currencyNumber)) {
                        currencyNumber = "CNY";
                    }
                    entryEntityJO.put("currencyNumber", (Object)currencyNumber);
                    entryEntityJO.put("orgNumber", (Object)orgNumber);
                    entryEntityJO.put("idNo", (Object)idNo);
                    entryEntityJO.put("positionName", (Object)positionNumber);
                    entryEntityJO.put("userTypeNumber", (Object)userTypeNumber);
                    entryEntityJO.put("wokerTypeNumber", (Object)wokerTypeNumber);
                    entryEntityJO.put("positionNumber", (Object)positionNumber);
                    entryEntityJO.put("projectNumber", (Object)projectNumber);
                    entryEntityJO.put("rate", rate);
                    if (originalAmount.equals(BigDecimal.ZERO)) continue;
                    entryEntityJO.put("originalAmount", originalAmount);
                    entryEntityJO.put("remark", (Object)remark);
                    entryentitys.add((Object)entryEntityJO);
                }
            }
            JSONObject data = new JSONObject();
            if (periodmonth > 9) {
                data.put("period", (Object)(String.valueOf(periodyear) + "-" + periodmonth));
            } else {
                data.put("period", (Object)(String.valueOf(periodyear) + "-0" + periodmonth));
            }
            data.put("fullOrPart", (Object)fullOrPart);
            data.put("entryentity", (Object)entryentitys);
            JSONArray datas = new JSONArray();
            datas.add((Object)data);
            JSONObject paramJO = new JSONObject();
            paramJO.put("data", (Object)datas);
            paramJOStr = paramJO.toString();
        }
        return paramJOStr;
    }

    private static Map<String, List<String>> getFieldsnList(Context ctx) throws BOSException, SQLException {
        String sql = "select item.fieldsn as fieldsn ,item.fnumber as number from  CT_COM_SynSalarySchemeEntry entry left join T_HR_SCmpItem item on item.fid = entry.cfcmpitemid";
        log.info("getFieldsnList.sql:" + sql);
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
        String fieldsn = "";
        String number = "";
        ArrayList<String> fieldsnList = new ArrayList<String>();
        ArrayList<String> numberList = new ArrayList<String>();
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                fieldsn = executeQuery.getString("fieldsn");
                fieldsnList.add("S" + fieldsn);
                number = executeQuery.getString("number");
                numberList.add(number);
            }
        }
        HashMap<String, List<String>> keyFieldSnListNumberMap = new HashMap<String, List<String>>();
        keyFieldSnListNumberMap.put("fieldsnList", fieldsnList);
        keyFieldSnListNumberMap.put("numberList", numberList);
        return keyFieldSnListNumberMap;
    }

    private static String getFildSnListStr(List<String> fieldsnList) {
        String fildSnListStr = "";
        int i = 0;
        while (i < fieldsnList.size()) {
            if (i != 0) {
                fildSnListStr = String.valueOf(fildSnListStr) + ",";
            }
            fildSnListStr = String.valueOf(fildSnListStr) + fieldsnList.get(i);
            ++i;
        }
        return fildSnListStr;
    }

    public static String synSalaryToErp(Context ctx, String yearMonth) throws Exception {
        String appToken = SynSalaryFromErpUtils.getAppToken(ctx);
        log.info("\u83b7\u53d6synSalaryToErp.appToken\uff1a" + appToken);
        String accessToken = SynSalaryFromErpUtils.getAccessToken(appToken);
        log.info("\u83b7\u53d6synSalaryToErp.accessToken\u72b6\u6001\u4e3a\uff1a" + accessToken);
        String responseMsg = SynSalaryFromErpUtils.savePaydetail(ctx, accessToken, yearMonth);
        log.info("\u83b7\u53d6synSalaryToErp.responseMsg\uff1a" + accessToken);
        return null;
    }
}

