/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.affair.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.affair.IPluralityAddBizBillEntry;
import com.kingdee.eas.hr.affair.IPluralityDelBizBill;
import com.kingdee.eas.hr.affair.PluralityAddBizBillEntryFactory;
import com.kingdee.eas.hr.affair.PluralityAddBizBillEntryInfo;
import com.kingdee.eas.hr.affair.PluralityDelBizBillEntryCollection;
import com.kingdee.eas.hr.affair.PluralityDelBizBillEntryInfo;
import com.kingdee.eas.hr.affair.PluralityDelBizBillFactory;
import com.kingdee.eas.hr.affair.PluralityDelBizBillInfo;
import com.kingdee.eas.hr.affair.app.PluralityDelBizBillControllerBean;
import com.kingdee.eas.hr.base.EmpInfoSinglePageInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.IEmpPosOrgRelation;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.CmpEmpORelationFactory;
import com.kingdee.shr.compensation.CmpEmpORelationInfo;
import com.kingdee.shr.compensation.ICmpEmpORelation;
import java.sql.Date;
import java.sql.SQLException;

public class PluralityDelBizBillControllerBeanEx
extends PluralityDelBizBillControllerBean {
    protected IObjectPK _submitEffect(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        IObjectPK objectPk = super._submitEffect(ctx, model);
        this.updateEndDate(ctx, (IObjectValue)model);
        return objectPk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK objectPk = super._submit(ctx, model);
        this.updateEndDate(ctx, model);
        return objectPk;
    }

    public void updateEndDate(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        PluralityDelBizBillInfo billInfo = (PluralityDelBizBillInfo)model;
        String billId = billInfo.getId().toString();
        PluralityDelBizBillEntryCollection entrys = billInfo.getEntrys();
        if (entrys != null && entrys.size() > 0) {
            int i = 0;
            while (i < entrys.size()) {
                PluralityDelBizBillEntryInfo entryInfo = entrys.get(i);
                this.checkAddBill(ctx, entryInfo.getId().toString(), 1);
                this.checkRelation(ctx, entryInfo.getId().toString(), null, 1);
                ++i;
            }
        }
    }

    private Date checkAddBill(Context ctx, String entryId, int type) throws BOSException, EASBizException {
        StringBuilder sbu = new StringBuilder();
        sbu.append(" select  bill.fid addId  , entry.fid  addEnId ,entry.fendDate addEndDate  ");
        sbu.append(" ,entry.cfoldEndDate oldAddEDate  , delen.fbizDate  newEDate  ");
        sbu.append(" from T_HR_PluralityAddBizBill  bill ");
        sbu.append(" left join  T_HR_PluralityAddBizBillEntry  entry on bill.FId = entry.fbillid ");
        sbu.append(" left join  T_HR_PluralityDelBizBillEntry  delen   ");
        sbu.append(" on  entry.fpersonid = delen.fpersonid   ");
        sbu.append(" and  entry.FBizDate = delen.FBeginDate  ");
        sbu.append(" and  entry.fpositionid = delen.FOldPositionID  ");
        sbu.append(" and   (   ");
        sbu.append(" entry.cfpthwage = delen.cfpthwage   ");
        sbu.append(" OR  ( entry.cfpthwage IS NULL AND delen.cfpthwage IS NULL  ) ");
        sbu.append("  )   ");
        sbu.append(" and   (   ");
        sbu.append(" entry.cfptlmanagerid = delen.cfptlmanagerid   ");
        sbu.append(" OR  ( entry.cfptlmanagerid IS NULL AND delen.cfptlmanagerid IS NULL  ) ");
        sbu.append("  )   ");
        sbu.append(" where  bill.fbillstate = '3'  ");
        sbu.append(" and  delen.fid = '" + entryId + "'");
        if (type == 0) {
            return this.restoreAddBillEndDate(ctx, sbu.toString());
        }
        if (type == 1) {
            return this.updateAddBillEndDate(ctx, sbu.toString());
        }
        return null;
    }

    private Date checkRelation(Context ctx, String entryId, Date newDate, int type) throws BOSException, EASBizException {
        StringBuilder sbu = new StringBuilder();
        sbu.append(" select   bill.fid  billId   ");
        sbu.append(" , cmpBill.FID  cmpBillId  ");
        sbu.append(" , delen.fbizDate  newEDate  ");
        sbu.append(" from T_HR_EmpOrgRelation  bill ");
        sbu.append(" left join T_HR_SCmpEmpORelation  cmpBill ");
        sbu.append(" on  bill.FID = cmpBill.femporgrelationid   ");
        sbu.append(" left join  T_HR_PluralityDelBizBillEntry  delen   ");
        sbu.append(" on  bill.fpersonid = delen.fpersonid   ");
        sbu.append(" and  bill.feffdt = delen.FBeginDate  ");
        sbu.append(" and  bill.fpositionid = delen.FOldPositionID  ");
        sbu.append(" and   (   ");
        sbu.append(" bill.CFLineManagerNameI = delen.cfptlmanagerid   ");
        sbu.append(" OR  ( bill.CFLineManagerNameI IS NULL AND delen.cfptlmanagerid IS NULL  ) ");
        sbu.append("  )   ");
        sbu.append(" where    ");
        sbu.append(" delen.fid = '" + entryId + "'");
        if (type == 0) {
            return this.updateRelationEndDate(ctx, sbu.toString(), newDate, type);
        }
        if (type == 1) {
            return this.updateRelationEndDate(ctx, sbu.toString(), null, type);
        }
        return null;
    }

    private Date updateRelationEndDate(Context ctx, String sqlStr, Date newEDate, int opType) {
        CoreBaseCollection addEnCol = new CoreBaseCollection();
        try {
            IEmpPosOrgRelation billIns = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx);
            ICmpEmpORelation cmpBillIns = CmpEmpORelationFactory.getLocalInstance((Context)ctx);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            while (rowSet.next()) {
                String billId = rowSet.getString("billId");
                String cmpBillId = rowSet.getString("cmpBillId");
                if (opType == 1) {
                    newEDate = rowSet.getDate("newEDate");
                }
                EmpPosOrgRelationInfo billInfo = billIns.getEmpPosOrgRelationInfo((IObjectPK)new ObjectUuidPK(billId));
                CmpEmpORelationInfo cmpInfo = cmpBillIns.getCmpEmpORelationInfo((IObjectPK)new ObjectUuidPK(cmpBillId));
                if (newEDate != null) {
                    billInfo.setLEFFDT((java.util.Date)newEDate);
                    billInfo.setEndDateTime((java.util.Date)newEDate);
                    cmpInfo.setLeffectDate((java.util.Date)newEDate);
                }
                billIns.update((IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)billInfo);
                cmpBillIns.update((IObjectPK)new ObjectUuidPK(cmpBillId), (EmpInfoSinglePageInfo)cmpInfo);
            }
        }
        catch (BOSException | EASBizException | SQLException e) {
            e.printStackTrace();
        }
        return newEDate;
    }

    private Date updateAddBillEndDate(Context ctx, String sqlStr) {
        Date newEDate = null;
        CoreBaseCollection addEnCol = new CoreBaseCollection();
        try {
            IPluralityAddBizBillEntry addEnIns = PluralityAddBizBillEntryFactory.getLocalInstance((Context)ctx);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            while (rowSet.next()) {
                String addEnId = rowSet.getString("addEnId");
                Date oldAddEDate = rowSet.getDate("oldAddEDate");
                Date addEndDate = rowSet.getDate("addEndDate");
                newEDate = rowSet.getDate("newEDate");
                PluralityAddBizBillEntryInfo addInfo = addEnIns.getPluralityAddBizBillEntryInfo((IObjectPK)new ObjectUuidPK(addEnId));
                if (oldAddEDate == null) {
                    addInfo.put("oldEndDate", (Object)addEndDate);
                }
                addInfo.put("endDate", (Object)newEDate);
                addEnCol.add((CoreBaseInfo)addInfo);
            }
            addEnIns.update(addEnCol);
        }
        catch (BOSException | EASBizException | SQLException e) {
            e.printStackTrace();
        }
        return newEDate;
    }

    protected void _untiCheckBizBill(Context ctx, String billId) throws BOSException, EASBizException {
        super._untiCheckBizBill(ctx, billId);
        IPluralityDelBizBill delIns = PluralityDelBizBillFactory.getLocalInstance((Context)ctx);
        PluralityDelBizBillInfo delInfo = delIns.getPluralityDelBizBillInfo((IObjectPK)new ObjectUuidPK(billId));
        PluralityDelBizBillEntryCollection entrys = delInfo.getEntrys();
        int i = 0;
        while (i < entrys.size()) {
            PluralityDelBizBillEntryInfo entryInfo = entrys.get(i);
            Date newDate = this.checkAddBill(ctx, entryInfo.getId().toString(), 0);
            this.checkRelation(ctx, entryInfo.getId().toString(), newDate, 0);
            ++i;
        }
    }

    private Date restoreAddBillEndDate(Context ctx, String sqlStr) {
        Date oldAddEDate = null;
        CoreBaseCollection addEnCol = new CoreBaseCollection();
        try {
            IPluralityAddBizBillEntry addEnIns = PluralityAddBizBillEntryFactory.getLocalInstance((Context)ctx);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlStr);
            while (rowSet.next()) {
                String addEnId = rowSet.getString("addEnId");
                oldAddEDate = rowSet.getDate("oldAddEDate");
                PluralityAddBizBillEntryInfo addInfo = addEnIns.getPluralityAddBizBillEntryInfo((IObjectPK)new ObjectUuidPK(addEnId));
                if (oldAddEDate != null) {
                    addInfo.put("endDate", (Object)oldAddEDate);
                }
                addEnCol.add((CoreBaseInfo)addInfo);
            }
            addEnIns.update(addEnCol);
        }
        catch (BOSException | EASBizException | SQLException e) {
            e.printStackTrace();
        }
        return oldAddEDate;
    }
}

