/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.task;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gemdale.gdgateway.util.MD5Utils;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.custom.task.AbstractSyncZYEmpFacadeControllerBean;
import com.kingdee.eas.custom.task.vo.EmpInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.log4j.Logger;

public class SyncZYEmpFacadeControllerBean
extends AbstractSyncZYEmpFacadeControllerBean {
    private static String propertiesUrl = String.valueOf(System.getProperty("EAS_HOME")) + "/server/properties/Api/propertie.properties";
    private List<EmpInfo> empInfoList = new ArrayList<EmpInfo>();
    private static Logger logger = Logger.getLogger(SyncZYEmpFacadeControllerBean.class);
    private int pageSize = 100;

    @Override
    protected void _SyncAllEmp(Context ctx) throws BOSException {
        super._SyncAllEmp(ctx);
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propertiesUrl));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BOSException(String.format("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e[%s]", propertiesUrl));
        }
        int empCount = this.getEmpCount(properties, null, null);
        logger.error((Object)("\u83b7\u53d6\u7528\u6237\u603b\u6570: " + empCount));
        this.getEmp(properties, null, null, empCount);
        this.updateUserInfo(ctx);
    }

    private void updateUserInfo(Context ctx) throws BOSException {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            UserCollection userCollection = UserFactory.getLocalInstance((Context)ctx).getUserCollection("select id,person.*");
            HashMap<String, String> idCardNoMap = new HashMap<String, String>();
            HashMap<String, String> passportNoMap = new HashMap<String, String>();
            HashMap<String, String> emailMap = new HashMap<String, String>();
            int i = 0;
            while (i < userCollection.size()) {
                String email;
                String passportNO;
                UserInfo userInfo = userCollection.get(i);
                String userId = userInfo.getId().toString();
                PersonInfo personInfo = userInfo.getPerson();
                String idCardNO = personInfo.getIdCardNO();
                if (!StringUtils.isEmpty((String)idCardNO)) {
                    idCardNoMap.put(idCardNO, userId);
                }
                if (!StringUtils.isEmpty((String)(passportNO = personInfo.getPassportNO()))) {
                    passportNoMap.put(passportNO, userId);
                }
                if (!StringUtils.isEmpty((String)(email = personInfo.getEmail()))) {
                    emailMap.put(email, userId);
                }
                ++i;
            }
            ArrayList<Object[]> updateParams = new ArrayList<Object[]>();
            int i2 = 0;
            while (i2 < this.empInfoList.size()) {
                EmpInfo empInfo = this.empInfoList.get(i2);
                String username = empInfo.getUsername();
                String email = empInfo.getEmail();
                String cardType = empInfo.getCardType();
                String cardNum = empInfo.getCardNum();
                String userId = null;
                userId = !StringUtils.isEmpty((String)cardNum) ? ("\u5927\u9646\u5730\u533a\u8eab\u4efd\u8bc1".equals(cardType) ? (String)idCardNoMap.get(cardNum) : (String)passportNoMap.get(cardNum)) : (String)emailMap.get(email);
                if (!StringUtils.isEmpty((String)userId)) {
                    updateParams.add(new Object[]{username, userId});
                }
                ++i2;
            }
            logger.error((Object)("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u53c2\u6570: " + objectMapper.writeValueAsString(updateParams)));
            String updateSql = "update t_pm_user set CFZYLoginName=? where fid=?";
            DbUtil.executeBatch((Context)ctx, (String)updateSql, updateParams);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException("\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u62a5\u9519: " + e.getMessage());
        }
    }

    @Override
    protected void _SyncEmpByUpdateTime(Context ctx, String updateBeginTime, String updateEndTime) throws BOSException {
        super._SyncEmpByUpdateTime(ctx, updateBeginTime, updateEndTime);
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propertiesUrl));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BOSException(String.format("\u83b7\u53d6\u914d\u7f6e\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e[%s]", propertiesUrl));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isEmpty((String)updateBeginTime) && StringUtils.isEmpty((String)updateEndTime)) {
            updateBeginTime = sdf.format(DateTimeUtils.addDay((Date)new Date(), (long)-7L));
        }
        int empCount = this.getEmpCount(properties, updateBeginTime, updateEndTime);
        logger.error((Object)("\u83b7\u53d6\u7528\u6237\u603b\u6570: " + empCount));
        this.getEmp(properties, updateBeginTime, updateEndTime, empCount);
        this.updateUserInfo(ctx);
    }

    private String getSignMd5String(String appSecret, String path) throws BOSException {
        StringBuilder errorMsg = new StringBuilder();
        if (StringUtils.isEmpty((String)appSecret)) {
            errorMsg.append("appSecret\u4e0d\u80fd\u4e3a\u7a7a!").append("\n");
        }
        if (StringUtils.isEmpty((String)path)) {
            errorMsg.append("path\u4e0d\u80fd\u4e3a\u7a7a!").append("\n");
        }
        if (errorMsg.length() > 0) {
            throw new BOSException("\u751f\u6210md5\u7b7e\u540d\u62a5\u9519: " + errorMsg);
        }
        String sign = MD5Utils.sign((String)appSecret, (String)path);
        logger.error((Object)("\u751f\u6210md5\u7b7e\u540d: " + sign));
        return sign;
    }

    private int getEmpCount(Properties properties, String updateBeginTime, String updateEndTime) throws BOSException {
        StringBuilder errorMsg = new StringBuilder();
        OkHttpClient client = new OkHttpClient();
        String appkey = properties.getProperty("Appkey");
        String appSecret = properties.getProperty("AppSecret");
        String serverName = properties.getProperty("serverName");
        String getEmpCountPath = properties.getProperty("getEmpCountPath");
        if (StringUtils.isEmpty((String)appkey)) {
            errorMsg.append("appkey \u4e0d\u80fd\u4e3a\u7a7a!").append("\n");
        }
        if (StringUtils.isEmpty((String)appSecret)) {
            errorMsg.append("appSecret \u4e0d\u80fd\u4e3a\u7a7a!").append("\n");
        }
        if (StringUtils.isEmpty((String)serverName)) {
            errorMsg.append("serverName \u4e0d\u80fd\u4e3a\u7a7a!").append("\n");
        }
        if (StringUtils.isEmpty((String)getEmpCountPath)) {
            errorMsg.append("\u83b7\u53d6\u7528\u6237\u603b\u6570\u63a5\u53e3\u5730\u5740 \u4e0d\u80fd\u4e3a\u7a7a!").append("\n");
        }
        if (errorMsg.length() > 0) {
            throw new BOSException("\u751f\u6210md5\u7b7e\u540d\u62a5\u9519: " + errorMsg);
        }
        JSONObject content = new JSONObject();
        content.put("containslnvalid", (Object)false);
        if (!StringUtils.isEmpty((String)updateBeginTime)) {
            content.put("updateBeginTime", (Object)updateBeginTime);
        }
        if (!StringUtils.isEmpty((String)updateEndTime)) {
            content.put("updateEndTime", (Object)updateEndTime);
        }
        String contentStr = content.toJSONString();
        logger.error((Object)("\u67e5\u8be2\u7528\u6237\u603b\u6570\u8bf7\u6c42\u53c2\u6570: " + contentStr));
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)contentStr);
        try {
            Request request = new Request.Builder().url(String.valueOf(serverName) + getEmpCountPath).post(body).addHeader("x-ca-key", appkey).addHeader("x-ca-signature", this.getSignMd5String(appSecret, getEmpCountPath)).addHeader("x-ca-signature-method", "MD5").addHeader("content-type", "application/json").build();
            Response response = client.newCall(request).execute();
            if (response.isSuccessful()) {
                ObjectMapper objectMapper = new ObjectMapper();
                Map result = (Map)objectMapper.readValue(response.body().string(), Map.class);
                Boolean success = (Boolean)result.get("success");
                if (success.booleanValue()) {
                    return (Integer)result.get("total");
                }
                String msg = (String)result.get("msg");
                throw new BOSException(msg);
            }
            throw new BOSException("\u8bf7\u6c42\u5931\u8d25");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException("\u67e5\u8be2\u7528\u6237\u603b\u6570\u62a5\u9519: " + e.getMessage());
        }
    }

    private void getEmp(Properties properties, String updateBeginTime, String updateEndTime, int empCount) throws BOSException {
        if (empCount > 0) {
            ObjectMapper objectMapper = new ObjectMapper();
            StringBuilder errorMsg = new StringBuilder();
            OkHttpClient client = new OkHttpClient();
            String appkey = properties.getProperty("Appkey");
            String appSecret = properties.getProperty("AppSecret");
            String serverName = properties.getProperty("serverName");
            String getEmpPath = properties.getProperty("getEmpPath");
            if (StringUtils.isEmpty((String)appkey)) {
                errorMsg.append("appkey \u4e0d\u80fd\u4e3a\u7a7a!").append("\n");
            }
            if (StringUtils.isEmpty((String)appSecret)) {
                errorMsg.append("appSecret \u4e0d\u80fd\u4e3a\u7a7a!").append("\n");
            }
            if (StringUtils.isEmpty((String)serverName)) {
                errorMsg.append("serverName \u4e0d\u80fd\u4e3a\u7a7a!").append("\n");
            }
            if (StringUtils.isEmpty((String)getEmpPath)) {
                errorMsg.append("\u83b7\u53d6\u7528\u6237\u63a5\u53e3\u5730\u5740 \u4e0d\u80fd\u4e3a\u7a7a!").append("\n");
            }
            if (errorMsg.length() > 0) {
                throw new BOSException("\u751f\u6210md5\u7b7e\u540d\u62a5\u9519: " + errorMsg);
            }
            String signMd5String = this.getSignMd5String(appSecret, getEmpPath);
            int pageCount = empCount % this.pageSize == 0 ? empCount / this.pageSize : empCount / this.pageSize + 1;
            int i = 1;
            while (i <= pageCount) {
                JSONObject content = new JSONObject();
                content.put("containslnvalid", (Object)false);
                content.put("pageSize", (Object)this.pageSize);
                content.put("pageNum", (Object)i);
                if (!StringUtils.isEmpty((String)updateBeginTime)) {
                    content.put("updateBeginTime", (Object)updateBeginTime);
                }
                if (!StringUtils.isEmpty((String)updateEndTime)) {
                    content.put("updateEndTime", (Object)updateEndTime);
                }
                RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)content.toJSONString());
                try {
                    Map result;
                    Request request = new Request.Builder().url(String.valueOf(serverName) + getEmpPath).post(body).addHeader("x-ca-key", appkey).addHeader("x-ca-signature", signMd5String).addHeader("x-ca-signature-method", "MD5").addHeader("content-type", "application/json").build();
                    Response response = client.newCall(request).execute();
                    if (response.isSuccessful()) {
                        String resultStr = response.body().string();
                        result = (Map)objectMapper.readValue(resultStr, Map.class);
                        Boolean success = (Boolean)result.get("success");
                        logger.error((Object)("\u67e5\u8be2\u7528\u6237\u6570\u636e: " + resultStr));
                        if (!success.booleanValue()) {
                            String msg = (String)result.get("msg");
                            throw new BOSException(msg);
                        }
                    } else {
                        throw new BOSException("\u8bf7\u6c42\u5931\u8d25");
                    }
                    String data = (String)result.get("data");
                    EmpInfo empInfo = (EmpInfo)objectMapper.readValue(data, EmpInfo.class);
                    this.empInfoList.add(empInfo);
                    Thread.sleep(100L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BOSException("\u67e5\u8be2\u7528\u6237\u62a5\u9519: " + e.getMessage());
                }
                ++i;
            }
        }
    }
}

