/*
 * Decompiled with CFR 0.152.
 */
package com.qy.sso.bamboocloud.filter.authentication;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.sso.client.util.FilterUtil;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.base.usermonitor.IUserMonitor;
import com.kingdee.eas.base.usermonitor.UserMonitorFactory;
import com.kingdee.eas.base.usermonitor.UserMonitorSessionInfo;
import com.kingdee.eas.cp.eip.sso.util.LoginUtil;
import com.kingdee.shr.guilogin.web.wechart.WeChartUtil;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Locale;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.authentication.AuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.DefaultAuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.DefaultGatewayResolverImpl;
import org.jasig.cas.client.authentication.GatewayResolver;
import org.jasig.cas.client.authentication.UrlPatternMatcherStrategy;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;

public class ZYPortalAuthenticationFilter
extends AbstractCasFilter {
    private boolean getServerNameFromRequest;
    private boolean getServerLoginUrlFromRequest;
    private String serverLoginUrl;
    private String casServerLoginUrl;
    private String clientId;
    private String responseType;
    private boolean renew = false;
    private boolean gateway = false;
    private String method;
    private GatewayResolver gatewayStorage = new DefaultGatewayResolverImpl();
    private AuthenticationRedirectStrategy authenticationRedirectStrategy = new DefaultAuthenticationRedirectStrategy();

    public ZYPortalAuthenticationFilter() {
        this(Protocol.ZY);
    }

    protected ZYPortalAuthenticationFilter(Protocol protocol) {
        super(protocol);
    }

    public void init() {
        super.init();
        String message = String.format("one of %s and %s must not be null.", ConfigurationKeys.CAS_SERVER_LOGIN_URL.getName(), ConfigurationKeys.CAS_SERVER_URL_PREFIX.getName());
        CommonUtils.assertNotNull((Object)this.casServerLoginUrl, (String)message);
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.isRequestUrlExcluded(request)) {
            this.logger.debug("Request is ignored.");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            Assertion assertion;
            boolean sessionRenew = false;
            String username = request.getParameter("kdacccode");
            if (StringUtils.isEmpty((String)username)) {
                username = request.getParameter("username");
            }
            if (StringUtils.isEmpty((String)username)) {
                username = request.getParameter("usern");
            }
            this.logger.debug("username  \"{}\"", (Object)username);
            if (username != null) {
                Assertion assertion2;
                HttpSession session = request.getSession(false);
                Assertion assertion3 = assertion2 = session != null ? (Assertion)session.getAttribute("_const_cas_assertion_") : null;
                if (assertion2 != null) {
                    username = URLDecoder.decode(username, "UTF-8");
                    String ctxUsername = assertion2.getPrincipal().getName();
                    if (ctxUsername != null && !ctxUsername.equalsIgnoreCase(username)) {
                        session.setAttribute("_const_cas_assertion_", null);
                        session.setAttribute("KD_PORTAL_IS_INIT_CONTEXT", null);
                        session.invalidate();
                        sessionRenew = true;
                    }
                    if (session.getAttribute("userMonitorSessionInfo") != null) {
                        UserMonitorSessionInfo userMonitorSessionInfo = (UserMonitorSessionInfo)session.getAttribute("userMonitorSessionInfo");
                        try {
                            IUserMonitor iUserMonitor = UserMonitorFactory.getRemoteInstance();
                            IObjectValue info = iUserMonitor.getValue(userMonitorSessionInfo.getId());
                            if (info == null) {
                                session.setAttribute("_const_cas_assertion_", null);
                                session.setAttribute("KD_PORTAL_IS_INIT_CONTEXT", null);
                                session.invalidate();
                                sessionRenew = true;
                            }
                        }
                        catch (Exception var16) {
                            this.logger.error("checkUserBeTicked err!", (Throwable)var16);
                        }
                    }
                }
            }
            this.setEncodeServiceUrl(true);
            this.constructLoginUrl(servletRequest, sessionRenew);
            String constructServerName = this.constructServerName(servletRequest);
            HttpSession session = request.getSession(false);
            Assertion assertion4 = assertion = session != null ? (Assertion)session.getAttribute("_const_cas_assertion_") : null;
            if (assertion != null) {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                boolean wasGatewayed;
                String serviceUrl = com.kingdee.bos.sso.client.util.CommonUtils.constructServiceUrl((HttpServletRequest)request, (HttpServletResponse)response, null, (String)this.getServerName(constructServerName), (String)this.getProtocol().getServiceParameterName(), (String)this.getProtocol().getArtifactParameterName(), (boolean)true);
                String constructServiceUrl = this.retrieveTicketFromRequest(request);
                boolean bl = wasGatewayed = this.gateway && this.gatewayStorage.hasGatewayedAlready(request, serviceUrl);
                if (!CommonUtils.isNotBlank((String)constructServiceUrl) && !wasGatewayed) {
                    String modifiedServiceUrl;
                    this.logger.debug("no ticket and no assertion found");
                    if (this.gateway) {
                        this.logger.debug("setting gateway attribute in session");
                        modifiedServiceUrl = this.gatewayStorage.storeGatewayInformation(request, serviceUrl);
                    } else {
                        modifiedServiceUrl = serviceUrl;
                    }
                    this.logger.debug("Constructed service url: {}", (Object)modifiedServiceUrl);
                    String urlToRedirectTo = this.constructRedirectUrl(this.casServerLoginUrl, this.getProtocol().getServiceParameterName(), modifiedServiceUrl, this.renew, this.gateway, this.method);
                    this.logger.debug("redirecting to \"{}\"", (Object)urlToRedirectTo);
                    this.authenticationRedirectStrategy.redirect(request, response, urlToRedirectTo);
                } else {
                    filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                }
            }
        }
    }

    public String constructRedirectUrl(String casServerLoginUrl, String serviceParameterName, String serviceUrl, boolean renew, boolean gateway, String method) {
        return casServerLoginUrl + (casServerLoginUrl.contains("?") ? "&" : "?") + serviceParameterName + "=" + serviceUrl + (renew ? "&renew=true" : "") + (gateway ? "&gateway=true" : "") + (method != null ? "&method=" + method : "");
    }

    protected static Context initRPC(String dataCenter, String easSessionId) {
        DCInfo dcInfo = WeChartUtil.getDCInfo((String)dataCenter);
        Context ctx = new Context((IObjectPK)null, dcInfo.getSolutionName(), dcInfo.getNumber(), (Locale)null);
        LoginUtil.initRpcConfig((Context)ctx, (String)easSessionId);
        return ctx;
    }

    private String getServerName(String constructServerName) {
        if (constructServerName != null) {
            return constructServerName;
        }
        try {
            Class<?> clazz = ((Object)((Object)this)).getClass().getSuperclass();
            Field field = clazz.getDeclaredField("serverName");
            field.setAccessible(true);
            return (String)field.get((Object)this);
        }
        catch (Exception var4) {
            return null;
        }
    }

    private String constructServerName(ServletRequest request) {
        if (this.getServerNameFromRequest) {
            StringBuilder serverName = new StringBuilder();
            serverName.append(request.getServerName());
            serverName.append(":");
            serverName.append(request.getServerPort());
            this.setServerName(serverName.toString());
            return serverName.toString();
        }
        return null;
    }

    private void constructLoginUrl(ServletRequest request, boolean sessionRenew) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpSession session = httpRequest.getSession(false);
        Assertion assertion = session != null ? (Assertion)session.getAttribute("_const_cas_assertion_") : null;
        try {
            URL contextURL;
            URL destURL = contextURL = new URL(this.serverLoginUrl);
            if (this.getServerLoginUrlFromRequest) {
                destURL = new URL(request.getScheme(), request.getServerName(), request.getServerPort(), contextURL.getFile());
            }
            if (assertion != null) {
                this.setCasServerLoginUrl(destURL.toString());
            } else {
                String renew = request.getParameter("renew");
                if (sessionRenew) {
                    renew = "true";
                }
                StringBuilder optionParam = new StringBuilder();
                optionParam.append("?client_id=").append(this.clientId).append("&response_type=").append(this.responseType).append("&state=").append(System.currentTimeMillis());
                this.setCasServerLoginUrl(destURL.toString() + optionParam);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public final void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.setCasServerLoginUrl(CommonUtils.addTrailingSlash((String)casServerUrlPrefix) + "login");
    }

    public final void setCasServerLoginUrl(String casServerLoginUrl) {
        this.casServerLoginUrl = casServerLoginUrl;
    }

    public final void setGatewayStorage(GatewayResolver gatewayStorage) {
        this.gatewayStorage = gatewayStorage;
    }

    private boolean isRequestUrlExcluded(HttpServletRequest request) throws MalformedURLException {
        return FilterUtil.isUnFilter((ServletRequest)request);
    }

    public final void setIgnoreUrlPatternMatcherStrategyClass(UrlPatternMatcherStrategy ignoreUrlPatternMatcherStrategyClass) {
    }

    public final void setServerLoginUrl(String serverLoginUrl) {
        this.serverLoginUrl = serverLoginUrl;
        this.setCasServerLoginUrl(this.serverLoginUrl);
    }

    public final void setGetServerNameFromRequest(boolean getServerNameFromRequest) {
        this.getServerNameFromRequest = getServerNameFromRequest;
    }

    public final void setGetServerLoginUrlFromRequest(boolean getServerLoginUrlFromRequest) {
        this.getServerLoginUrlFromRequest = getServerLoginUrlFromRequest;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getClientId() {
        return this.clientId;
    }
}

