/*
 * Decompiled with CFR 0.152.
 */
package com.qy.sso.bamboocloud.filter.validate;

import com.kingdee.bos.sso.client.util.FilterUtil;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.qy.sso.bamboocloud.validation.ZYPortalServiceTicketValidator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorageImpl;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ProxyReceivingTicketValidationFilter;
import org.jasig.cas.client.validation.Cas20ProxyTicketValidator;
import org.jasig.cas.client.validation.TicketValidator;

public class ZYTicketValidationFilter
extends Cas20ProxyReceivingTicketValidationFilter {
    private String getTokenPath;
    private String getUserInfoPath;
    private String clientSecret;
    private String grantType;
    private String clientId;
    private String responseType;
    private boolean getServerNameFromRequest;
    private boolean getServerLoginUrlFromRequest;
    private String casServerUrlPrefix;
    private String acceptAnyProxy;
    private String allowedProxyChains;
    private String proxyCallbackUrl;
    private boolean renew;
    private String encoding;
    private Map<String, String> additionalParameters = new HashMap<String, String>();
    private ProxyGrantingTicketStorage proxyGrantingTicketStorage = new ProxyGrantingTicketStorageImpl();

    public ZYTicketValidationFilter() {
        this(Protocol.ZY);
        this.defaultProxyTicketValidatorClass = Cas20ProxyTicketValidator.class;
    }

    protected ZYTicketValidationFilter(Protocol protocol) {
        super(protocol);
    }

    protected void onSuccessfulValidation(HttpServletRequest request, HttpServletResponse response, Assertion assertion) {
        super.onSuccessfulValidation(request, response, assertion);
        try {
            Map attributes = assertion.getAttributes();
            Boolean isFail = (Boolean)attributes.get("isFail");
            if (isFail.booleanValue()) {
                response.sendRedirect("/eassso/unreg/userNumberError.jsp");
                return;
            }
            this.initializeSessionData(request, response);
        }
        catch (Exception var5) {
            throw new RuntimeException(var5);
        }
    }

    private void initializeSessionData(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        HttpSession session = request.getSession();
        try {
            if (session != null) {
                session.setAttribute("contextPath", (Object)request.getContextPath());
                session.setAttribute("sessionCreateTime", (Object)session.getCreationTime());
            } else {
                response.sendRedirect("/shr");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                if (session != null) {
                    session.invalidate();
                }
                response.sendRedirect("/shr");
            }
            catch (IOException var6) {
                var6.printStackTrace();
            }
        }
    }

    protected TicketValidator getTicketValidator() {
        ZYPortalServiceTicketValidator validator = new ZYPortalServiceTicketValidator();
        validator.setClientId(this.clientId);
        validator.setClientSecret(this.clientSecret);
        validator.setGrantType(this.grantType);
        validator.setResponseType(this.responseType);
        validator.setGetTokenPath(this.getTokenPath);
        validator.setGetUserInfoPath(this.getUserInfoPath);
        return validator;
    }

    protected String retrieveTicketFromRequest(HttpServletRequest request) {
        try {
            if (FilterUtil.isUnFilter((ServletRequest)request)) {
                return null;
            }
            this.constructLoginUrl((ServletRequest)request);
            this.constructServerName((ServletRequest)request);
            this.setTicketValidator(this.getTicketValidator());
        }
        catch (MalformedURLException var3) {
            var3.printStackTrace();
        }
        return super.retrieveTicketFromRequest(request);
    }

    private void constructLoginUrl(ServletRequest request) {
        if (this.getServerLoginUrlFromRequest) {
            try {
                URL contextURL = new URL(this.casServerUrlPrefix);
                URL destURL = new URL(contextURL.getProtocol(), request.getServerName(), request.getServerPort(), contextURL.getFile());
                this.casServerUrlPrefix = destURL.toString();
            }
            catch (MalformedURLException var4) {
                var4.printStackTrace();
            }
        }
    }

    private void constructServerName(ServletRequest request) {
        if (this.getServerNameFromRequest) {
            StringBuilder serverName = new StringBuilder();
            serverName.append(request.getServerName());
            serverName.append(":");
            serverName.append(request.getServerPort());
            this.setServerName(serverName.toString());
        }
    }

    public void setGetTokenPath(String getTokenPath) {
        this.getTokenPath = getTokenPath;
    }

    public void setGetUserInfo(String getUserInfoPath) {
        this.getUserInfoPath = getUserInfoPath;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getGetTokenPath() {
        return this.getTokenPath;
    }

    public String getGetUserInfoPath() {
        return this.getUserInfoPath;
    }

    public void setGetUserInfoPath(String getUserInfoPath) {
        this.getUserInfoPath = getUserInfoPath;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public final void setGetServerNameFromRequest(boolean getServerNameFromRequest) {
        this.getServerNameFromRequest = getServerNameFromRequest;
    }

    public final void setGetServerLoginUrlFromRequest(boolean getServerLoginUrlFromRequest) {
        this.getServerLoginUrlFromRequest = getServerLoginUrlFromRequest;
    }

    public final void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.casServerUrlPrefix = casServerUrlPrefix;
    }

    public final void setAcceptAnyProxy(String acceptAnyProxy) {
        this.acceptAnyProxy = acceptAnyProxy;
    }

    public final void setAllowedProxyChains(String allowedProxyChains) {
        this.allowedProxyChains = allowedProxyChains;
    }

    public final void setProxyCallbackUrl(String proxyCallbackUrl) {
        this.proxyCallbackUrl = proxyCallbackUrl;
    }

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }
}

