/*
 * Decompiled with CFR 0.152.
 */
package com.qy.sso.bamboocloud.validation;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.kingdee.bos.Context;
import com.kingdee.eas.cp.eip.sso.util.CASLoginConfigPropUtil;
import com.kingdee.eas.cp.eip.sso.util.CloudParamUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.ssl.HttpURLConnectionFactory;
import org.jasig.cas.client.ssl.HttpsURLConnectionFactory;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.jasig.cas.client.validation.TicketValidationException;
import org.jasig.cas.client.validation.TicketValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZYPortalServiceTicketValidator
implements TicketValidator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private HttpURLConnectionFactory urlConnectionFactory = new HttpsURLConnectionFactory();
    private boolean renew;
    private Map<String, String> customParameters;
    private String encoding;
    private String clientSecret;
    private String grantType;
    private String clientId;
    private String responseType;
    private String getTokenPath;
    private String getUserInfoPath;

    public final Assertion validate(String code, String service) throws TicketValidationException {
        HashMap<String, Boolean> attributes = new HashMap<String, Boolean>();
        try {
            this.logger.debug("Retrieving response from server.");
            Map<String, Object> token = this.getToken(code, null);
            String loginName = this.getUserInfo(token);
            this.logger.debug("\u83b7\u53d6\u5458\u5de5\u4fe1\u606f \u767b\u5f55\u8d26\u53f7: " + loginName);
            if (StringUtils.isEmpty((String)loginName)) {
                throw new TicketValidationException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u7684\u767b\u5f55\u8d26\u53f7\u4e3a\u7a7a!");
            }
            String dataCenter = CASLoginConfigPropUtil.getDataCenter();
            String locale = CASLoginConfigPropUtil.getLocale();
            if (!StringUtils.isEmpty((String)dataCenter) && !StringUtils.isEmpty((String)locale)) {
                Context ctx = CloudParamUtil.getContext((String)dataCenter, (String)locale, (String)"administrator");
                String sql = "SELECT fnumber FROM T_PM_USER WHERE LOWER(CFZYLoginName)=?";
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{loginName.toLowerCase()});
                String userNumber = null;
                if (rs.next()) {
                    userNumber = rs.getString("fnumber");
                }
                if (StringUtils.isEmpty(userNumber)) {
                    this.logger.error("loginName :" + loginName + "\u4e0d\u662fshr\u7528\u6237");
                    attributes.put("isFail", true);
                    userNumber = loginName;
                }
                AttributePrincipalImpl principal = new AttributePrincipalImpl(userNumber);
                return new AssertionImpl((AttributePrincipal)principal, attributes);
            }
            throw new TicketValidationException("\u6570\u636e\u4e2d\u5fc3 \u6216 locale \u4e3a\u7a7a!");
        }
        catch (Exception var5) {
            var5.printStackTrace();
            throw new TicketValidationException((Throwable)var5);
        }
    }

    private Map<String, Object> getToken(String code, String state) throws TicketValidationException {
        this.logger.debug("code: " + code);
        this.logger.debug("state: " + state);
        if (StringUtils.isEmpty((String)code)) {
            throw new TicketValidationException("code \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        OkHttpClient client = new OkHttpClient();
        MediaType mediaType = MediaType.parse((String)"application/x-www-form-urlencoded");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.clientId);
        params.put("client_secret", this.clientSecret);
        params.put("code", code);
        params.put("grant_type", this.grantType);
        RequestBody body = RequestBody.create((MediaType)mediaType, (String)this.constructRequestParameter(params));
        Request request = new Request.Builder().url(this.getTokenPath).post(body).addHeader("content-type", "application/x-www-form-urlencoded").build();
        Response sYResponse = null;
        try {
            sYResponse = client.newCall(request).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TicketValidationException("\u83b7\u53d6Token\u8bf7\u6c42\u6267\u884c\u5931\u8d25!");
        }
        if (sYResponse.isSuccessful()) {
            try {
                String result = sYResponse.body().string();
                this.logger.debug("getToken sYResponse : " + result);
                ObjectMapper objectMapper = new ObjectMapper();
                Map map = (Map)objectMapper.readValue(result, Map.class);
                String errcode = (String)map.get("errcode");
                if (StringUtils.isEmpty((String)errcode)) {
                    return map;
                }
                String msg = (String)map.get("msg");
                throw new TicketValidationException("\u83b7\u53d6Token\u5931\u8d25: " + msg);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new TicketValidationException("\u83b7\u53d6Token\u5931\u8d25: " + e.getMessage());
            }
        }
        throw new TicketValidationException("\u83b7\u53d6Token\u8bf7\u6c42\u5931\u8d25");
    }

    private String getUserInfo(Map<String, Object> tokenResponse) throws TicketValidationException {
        if (tokenResponse == null) {
            throw new TicketValidationException("tokenResponse \u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String access_token = (String)tokenResponse.get("access_token");
        OkHttpClient client = new OkHttpClient();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("client_id", this.clientId);
        params.put("access_token", access_token);
        Request request = new Request.Builder().url(this.getUserInfoPath + "?" + this.constructRequestParameter(params)).get().addHeader("content-type", "application/json").build();
        Response sYResponse = null;
        try {
            sYResponse = client.newCall(request).execute();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TicketValidationException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\u6267\u884c\u5931\u8d25!");
        }
        if (sYResponse.isSuccessful()) {
            try {
                String result = sYResponse.body().string();
                this.logger.debug("getUserInfo sYResponse : " + result);
                ObjectMapper objectMapper = new ObjectMapper();
                Map map = (Map)objectMapper.readValue(result, Map.class);
                String errcode = (String)map.get("errcode");
                if (StringUtils.isEmpty((String)errcode)) {
                    return (String)map.get("loginName");
                }
                String msg = (String)map.get("msg");
                throw new TicketValidationException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25: " + msg);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new TicketValidationException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25: " + e.getMessage());
            }
        }
        throw new TicketValidationException("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8bf7\u6c42\u5931\u8d25 ");
    }

    private String constructRequestParameter(Map<String, String> map) {
        StringBuilder parameters = new StringBuilder();
        if (map != null) {
            for (String key : map.keySet()) {
                String value = map.get(key);
                parameters.append(key).append("=").append(value).append("&");
            }
            parameters.deleteCharAt(parameters.lastIndexOf("&"));
        }
        return parameters.toString();
    }

    protected String getUrlSuffix() {
        return "serviceValidate";
    }

    public HttpURLConnectionFactory getUrlConnectionFactory() {
        return this.urlConnectionFactory;
    }

    public void setUrlConnectionFactory(HttpURLConnectionFactory urlConnectionFactory) {
        this.urlConnectionFactory = urlConnectionFactory;
    }

    public boolean isRenew() {
        return this.renew;
    }

    public void setRenew(boolean renew) {
        this.renew = renew;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public void setCustomParameters(Map<String, String> customParameters) {
        this.customParameters = customParameters;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getGetTokenPath() {
        return this.getTokenPath;
    }

    public void setGetTokenPath(String getTokenPath) {
        this.getTokenPath = getTokenPath;
    }

    public String getGetUserInfoPath() {
        return this.getUserInfoPath;
    }

    public void setGetUserInfoPath(String getUserInfoPath) {
        this.getUserInfoPath = getUserInfoPath;
    }
}

