/*
 * Decompiled with CFR 0.152.
 */
package com.gemdale.gdgateway.util;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.HmacUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.MultiValueMap;

public class HmacSHA256Utils {
    private static final String DEFAULT_SECRET = "1qaz@WSX#$%&";
    private static final String EQUAL = "=";
    private static final String SPLIT = "&";

    public static String sign(String signSecret, String path, String body, MultiValueMap<String, String> params, Map<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        sb.append(path).append("?");
        if (MapUtils.isNotEmpty(headers)) {
            headers.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> sb.append((String)entry.getKey()).append(EQUAL).append((String)entry.getValue()).append(SPLIT));
        }
        if (MapUtils.isNotEmpty(params)) {
            params.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(paramEntry -> {
                sb.append((String)paramEntry.getKey()).append(EQUAL);
                Object value = paramEntry.getValue();
                if (value instanceof List) {
                    String paramValue = String.join((CharSequence)",", (CharSequence[])Arrays.stream(((List)value).toArray()).sorted().toArray(String[]::new));
                    sb.append(paramValue);
                } else {
                    sb.append(paramEntry.getValue());
                }
                sb.append(SPLIT);
            });
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            sb.append("body=").append(body).append(SPLIT);
        }
        String bodyString = sb.toString();
        bodyString = sb.substring(0, bodyString.length() - 1);
        String createSign = HmacUtils.hmacSha256Hex((String)signSecret, (String)bodyString);
        return createSign;
    }

    public static String sign(String signSecret, String path, String body, Map<String, String[]> params, Map<String, String> headers) {
        StringBuilder sb = new StringBuilder();
        sb.append(path).append("?");
        if (MapUtils.isNotEmpty(headers)) {
            headers.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                sb.append((String)entry.getKey());
                if (StringUtils.isNotBlank((CharSequence)((CharSequence)entry.getValue()))) {
                    sb.append(EQUAL).append((String)entry.getValue());
                }
            });
            sb.append(SPLIT);
        }
        if (MapUtils.isNotEmpty(params)) {
            params.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(paramEntry -> {
                String paramValue = String.join((CharSequence)",", (CharSequence[])Arrays.stream((Object[])paramEntry.getValue()).sorted().toArray(String[]::new));
                sb.append((String)paramEntry.getKey()).append(EQUAL).append(paramValue).append('#');
            });
            sb.append(SPLIT);
        }
        if (StringUtils.isNotBlank((CharSequence)body)) {
            sb.append("body=").append(body).append(SPLIT);
        }
        String bodyString = sb.toString();
        bodyString = sb.substring(0, bodyString.length() - 1);
        String createSign = HmacUtils.hmacSha256Hex((String)signSecret, (String)bodyString);
        return createSign;
    }
}

