/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.handler.wagerecord;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.custom.bill.wagerecord.WageRecordEntryCollection;
import com.kingdee.eas.custom.bill.wagerecord.WageRecordEntryFactory;
import com.kingdee.eas.custom.bill.wagerecord.WageRecordEntryInfo;
import com.kingdee.eas.custom.bill.wagerecord.WageRecordFactory;
import com.kingdee.eas.custom.bill.wagerecord.WageRecordInfo;
import com.kingdee.eas.custom.bill.wagerecord.WageRowStatus;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.LabContractFirstPartyFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;

public class WageRecordEntryListHandler
extends ListHandler {
    protected FilterInfo getDefaultFilter(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        String params = request.getParameter("custom_params");
        HashMap paramMap = JSONUtils.convertJsonToObject((String)params);
        String billId = (String)paramMap.get("policy");
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("parent", paramMap.get("policy")));
        return fi;
    }

    public void doSaveEntryAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String billId = request.getParameter("billId");
        String paras = request.getParameter("para");
        HashMap<String, String> map = new HashMap<String, String>();
        String[] filter = paras.split(",");
        int i = 0;
        while (i < filter.length) {
            String para = filter[i];
            String[] paraArr = para.split(":");
            String key = null;
            String value = null;
            if (paraArr.length == 2) {
                key = paraArr[0];
                value = paraArr[1];
                map.put(key, value);
            } else {
                key = paraArr[0];
                map.put(key, null);
            }
            ++i;
        }
        try {
            String update;
            WageRecordEntryCollection coll;
            SimpleDateFormat format;
            WageRecordInfo info;
            if ("" != billId) {
                WageRecordEntryInfo entryInfo = WageRecordEntryFactory.getRemoteInstance().getWageRecordEntryInfo((IObjectPK)new ObjectUuidPK(billId));
                info = WageRecordFactory.getRemoteInstance().getWageRecordInfo("where id='" + entryInfo.getParent().getId() + "'");
                entryInfo.setAmount(new BigDecimal(map.get("amount").toString()));
                entryInfo.setAccount(map.get("account").toString());
                entryInfo.setProvince(map.get("province").toString());
                entryInfo.setGroupName(map.get("groupName").toString());
                entryInfo.setBank(map.get("bank").toString());
                entryInfo.setCity(map.get("city").toString());
                entryInfo.setBakingfirm(map.get("bakingfirm").toString());
                WageRecordEntryFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(entryInfo.getId()), entryInfo);
                format = new SimpleDateFormat("yyyy-MM-dd");
                info.setPayAccount(map.get("payAccount").toString());
                info.setSysNumber(map.get("sysNumber").toString());
                info.setWishDate(format.parse(map.get("wishDate").toString()));
                coll = WageRecordEntryFactory.getRemoteInstance().getWageRecordEntryCollection("where parent='" + entryInfo.getParent().getId() + "'");
                update = "select sum(Famount) amts,count(*) counts from T_WAG_WageRecordentry where fParentid='" + entryInfo.getParent().getId() + "'";
                IRowSet row = DbUtil.executeQuery((Context)SHRContext.getInstance().getContext(), (String)update);
                int counts = info.getCounts();
                BigDecimal amt = info.getAmt();
                while (row.next()) {
                    counts = row.getInt("counts");
                    amt = row.getBigDecimal("amts");
                }
                info.setAmt(amt);
                info.setCounts(counts);
                info.put("Entry", (Object)coll);
                WageRecordFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
            } else {
                WageRecordEntryInfo entryInfo = new WageRecordEntryInfo();
                info = WageRecordFactory.getRemoteInstance().getWageRecordInfo("where number='" + map.get("number") + "'");
                entryInfo.setAmount(new BigDecimal(map.get("amount").toString()));
                entryInfo.setAccount(map.get("account").toString());
                entryInfo.setProvince(map.get("province").toString());
                entryInfo.setGroupName(map.get("groupName").toString());
                entryInfo.setBank(map.get("bank").toString());
                entryInfo.setCity(map.get("city").toString());
                entryInfo.setBakingfirm(map.get("bakingfirm").toString());
                entryInfo.setRowStatus(WageRowStatus.NONE);
                entryInfo.setPersonName(map.get("personNumber").toString());
                if (map.get("organize") != null) {
                    AdminOrgUnitInfo admin = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(map.get("organize").toString()));
                    entryInfo.setOrganize(admin);
                }
                entryInfo.setParent(info);
                entryInfo.setId(BOSUuid.create((String)"B7148C46"));
                entryInfo.setSeq(info.getEntry().size() + 1);
                WageRecordEntryFactory.getRemoteInstance().addnew((IObjectPK)new ObjectUuidPK(entryInfo.getId()), entryInfo);
                format = new SimpleDateFormat("yyyy-MM-dd");
                info.setPayAccount(map.get("payAccount").toString());
                info.setSysNumber(map.get("sysNumber").toString());
                info.setWishDate(format.parse(map.get("wishDate").toString()));
                coll = WageRecordEntryFactory.getRemoteInstance().getWageRecordEntryCollection("where parent='" + entryInfo.getParent().getId() + "'");
                update = "select sum(Famount) amts,count(*) counts from T_WAG_WageRecordentry where fParentid='" + entryInfo.getParent().getId() + "'";
                IRowSet row = DbUtil.executeQuery((Context)SHRContext.getInstance().getContext(), (String)update);
                int counts = info.getCounts();
                BigDecimal amt = info.getAmt();
                while (row.next()) {
                    counts = row.getInt("counts");
                    amt = row.getBigDecimal("amts");
                }
                info.setAmt(amt);
                info.setCounts(counts);
                info.put("Entry", (Object)coll);
                WageRecordFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void initBillAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        String billId = request.getParameter("billId");
        HashMap<String, Object> res = new HashMap<String, Object>();
        try {
            WageRecordEntryInfo entryInfo = WageRecordEntryFactory.getRemoteInstance().getWageRecordEntryInfo((IObjectPK)new ObjectUuidPK(billId));
            BOSUuid id = entryInfo.getParent().getId();
            WageRecordInfo info = WageRecordFactory.getRemoteInstance().getWageRecordInfo((IObjectPK)new ObjectUuidPK(id.toString()));
            LabContractFirstPartyInfo admin = LabContractFirstPartyFactory.getRemoteInstance().getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(info.getPayCompany().getId()));
            res.put("counts", info.getCounts());
            res.put("payAccount", info.getPayAccount());
            res.put("sysNumber", info.getSysNumber());
            res.put("year", info.getYear());
            res.put("month", info.getMonth());
            res.put("amt", info.getAmt());
            res.put("wishDate", info.getWishDate());
            res.put("status", info.getStatus().getValue());
            res.put("description", info.getDescription());
            res.put("payCompany", admin.getName());
            res.put("number", info.getNumber());
            JSONUtils.writeJson((HttpServletResponse)response, res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String deleteAction(HttpServletRequest arg0, HttpServletResponse arg1, ModelMap arg2) throws SHRWebException {
        try {
            String originalURL = arg0.getContextPath();
            Map parameters = arg0.getParameterMap();
            Object billId = parameters.get("billId");
            String[] ids = (String[])billId;
            String id = null;
            if (ids[0].indexOf(",") > 0) {
                String[] sp = ids[0].split(",");
                id = sp[0];
            } else {
                id = ids[0];
            }
            WageRecordEntryInfo entryInfo = WageRecordEntryFactory.getRemoteInstance().getWageRecordEntryInfo((IObjectPK)new ObjectUuidPK(id));
            WageRecordInfo info = WageRecordFactory.getRemoteInstance().getWageRecordInfo("where id='" + entryInfo.getParent().getId() + "'");
            String pk = super.deleteAction(arg0, arg1, arg2);
            String update = "update T_WAG_WageRecord set FAmt=(select sum(Famount) from T_WAG_WageRecordentry where fParentid='" + info.getId() + "'),FCount=(select count(*) from T_WAG_WageRecordentry where fParentid='" + info.getId() + "') where fid='" + info.getId() + "'";
            DbUtil.execute((Context)SHRContext.getInstance().getContext(), (String)update);
            return pk;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

