/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.custom.salaryadjustment.salaryoffAudit;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.bill.customworkflow.StatusEnum;
import com.kingdee.eas.custom.salaryadjustment.salaryoffaudit.SalaryOffAuditFactory;
import com.kingdee.eas.custom.salaryadjustment.salaryoffaudit.SalaryOffAuditInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;

public class SalaryOffAuditListHandler
extends ListHandler {
    protected FilterInfo getDefaultFilter(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        FilterInfo fi = new FilterInfo();
        try {
            String params = request.getParameter("custom_params");
            HashMap paramMap = JSONUtils.convertJsonToObject((String)params);
            String billId = (String)paramMap.get("param");
            if (billId.indexOf("%2B") >= 0) {
                billId = billId.replaceAll("%2B", "+");
            }
            if (billId.indexOf("%3D") >= 0) {
                billId = billId.replaceAll("%3D", "=");
            }
            if (billId.indexOf("%2F") >= 0) {
                billId = billId.replaceAll("%2F", "/");
            }
            if ("".equals(billId) || billId == null) {
                billId = (String)paramMap.get("billId");
                if (billId.indexOf("%2B") >= 0) {
                    billId = billId.replaceAll("%2B", "+");
                }
                if (billId.indexOf("%3D") >= 0) {
                    billId = billId.replaceAll("%3D", "=");
                }
                if (billId.indexOf("%2F") >= 0) {
                    billId = billId.replaceAll("%2F", "/");
                }
                SalaryOffAuditInfo info = SalaryOffAuditFactory.getRemoteInstance().getSalaryOffAuditInfo((IObjectPK)new ObjectUuidPK(billId));
                fi.getFilterItems().add(new FilterItemInfo("projectId", (Object)info.getProjectId()));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("projectId", (Object)billId));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fi;
    }

    public String submitAction(HttpServletRequest arg0, HttpServletResponse arg1, ModelMap arg2) throws SHRWebException {
        String billId = (String)arg0.getAttribute("billId");
        try {
            SalaryOffAuditInfo info = SalaryOffAuditFactory.getRemoteInstance().getSalaryOffAuditInfo((IObjectPK)new ObjectUuidPK(billId));
            info.setStatus(StatusEnum.SUBMIT);
            SalaryOffAuditFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(billId), (CoreBaseInfo)info);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.submitAction(arg0, arg1, arg2);
    }

    public void auditAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        String billId = (String)request.getAttribute("billId");
        String value = request.getParameter("billId");
        ArrayList<String> errorList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)value)) {
            try {
                int i;
                if (value != null) {
                    String[] bills = value.split(",");
                    ArrayList list = new ArrayList();
                    i = 0;
                    while (i < bills.length) {
                        SalaryOffAuditInfo info = SalaryOffAuditFactory.getRemoteInstance().getSalaryOffAuditInfo((IObjectPK)new ObjectUuidPK(bills[i]));
                        if (info.getStatus() == StatusEnum.SUBMIT) {
                            SalaryOffAuditFactory.getRemoteInstance().audit(info.getId().toString());
                        } else if (info.getStatus() != StatusEnum.SUBMIT) {
                            errorList.add(info.getNumber());
                        }
                        ++i;
                    }
                }
                String errorMsg = "";
                String error = "";
                i = 0;
                while (i < errorList.size()) {
                    error = "[" + (String)errorList.get(i) + "]";
                    errorMsg = String.valueOf(errorMsg) + error;
                    ++i;
                }
                if (errorMsg != "") {
                    throw new ShrWebBizException("\u5355\u636e" + errorMsg + "\u4e0d\u662f\u63d0\u4ea4\u72b6\u6001\uff0c\u4e0d\u80fd\u5ba1\u6838\uff01");
                }
            }
            catch (BOSException e) {
                if (e.getCause() != null) {
                    e.printStackTrace();
                }
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    public void unAuditAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        String billId = (String)request.getAttribute("billId");
        String value = request.getParameter("billId");
        ArrayList<String> errorList = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)value)) {
            try {
                int i;
                if (value != null) {
                    String[] bills = value.split(",");
                    ArrayList list = new ArrayList();
                    i = 0;
                    while (i < bills.length) {
                        SalaryOffAuditInfo info = SalaryOffAuditFactory.getRemoteInstance().getSalaryOffAuditInfo((IObjectPK)new ObjectUuidPK(bills[i]));
                        if (info.getStatus() == StatusEnum.AUDIT) {
                            SalaryOffAuditFactory.getRemoteInstance().unAudit(info.getId().toString());
                        } else if (info.getStatus() != StatusEnum.AUDIT) {
                            errorList.add(info.getNumber());
                        }
                        ++i;
                    }
                }
                String errorMsg = "";
                String error = "";
                i = 0;
                while (i < errorList.size()) {
                    error = "[" + (String)errorList.get(i) + "]";
                    errorMsg = String.valueOf(errorMsg) + error;
                    ++i;
                }
                if (errorMsg != "") {
                    throw new ShrWebBizException("\u5355\u636e" + errorMsg + "\u4e0d\u662f\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\uff01");
                }
            }
            catch (BOSException e) {
                if (e.getCause() != null) {
                    e.printStackTrace();
                }
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    public String deleteAction(HttpServletRequest arg0, HttpServletResponse arg1, ModelMap arg2) throws SHRWebException {
        String pk = super.deleteAction(arg0, arg1, arg2);
        return pk;
    }
}

