/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.web.handler.sign;

import com.kingdee.bos.ctrl.cipher.util.encoders.Base64;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public enum SignUtils {
    HMAC_SHA256;


    public String sign(Map<String, String> params, String appSecret, String characterEncoding) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put("appSecret", appSecret);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            treeMap.put(entry.getKey(), entry.getValue().toString());
        }
        StringBuilder builder = new StringBuilder();
        for (Object parameter : treeMap.values()) {
            if (parameter == null) continue;
            builder.append(parameter.toString());
        }
        String signStr = null;
        try {
            signStr = this.sign1(URLEncoder.encode(builder.toString(), characterEncoding), appSecret);
        }
        catch (UnsupportedEncodingException parameter) {
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        return signStr;
    }

    public String sign1(String data, String accessKey) throws SignatureException {
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            SecretKeySpec signingKey = new SecretKeySpec(accessKey.getBytes(), "HmacSHA256");
            mac.init(signingKey);
            byte[] signData = mac.doFinal(data.getBytes());
            return new String(Base64.encode((byte[])signData));
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException("\u5e73\u53f0\u4e0d\u652f\u6301HmacSHA256\u6458\u8981\u65b9\u5f0f");
        }
        catch (InvalidKeyException e) {
            throw new SignatureException("Speicified access secret is not valid.");
        }
    }
}

