/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pd.web.handler.flow;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.web.handler.EditHandler;
import com.kingdee.shr.pd.web.dto.PdSpFlowFullDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowNoteDTO;
import com.kingdee.shr.pd.web.enums.PdFlowStatusEnum;
import com.kingdee.shr.pd.web.enums.PdFlowXpCommentEnum;
import com.kingdee.shr.pd.web.enums.PdNoteStatusEnum;
import com.kingdee.shr.pd.web.enums.PdSpFlowPdResultEnum;
import com.kingdee.shr.pd.web.server.PdSpComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.ui.ModelMap;

public class PdFlowEditHandler
extends EditHandler {
    private static final String LOG_HEAD = "wdpd_" + PdFlowEditHandler.class.getSimpleName() + "_";
    protected final Context ctx = SHRContext.getInstance().getContext();
    protected final String user_id = this.ctx.getCaller().toString();
    protected final String person_id = ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson().getId().toString();
    protected final String person_name = ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson().getName();
    protected final PdSpComponent component = new PdSpComponent(this.ctx);

    protected void setInitData(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Map<String, Object> initData) throws SHRWebException {
        String flowId = request.getParameter("billId");
        PdSpFlowFullDTO dto = this.component.flow(flowId);
        initData.put("flow", dto);
        initData.put("pdContinueCommentMap", PdFlowXpCommentEnum.map());
        initData.put("pdResultMap", PdSpFlowPdResultEnum.map());
        initData.put("flowStatusMap", PdFlowStatusEnum.map());
        initData.put("btn", this.showBtn(dto));
        super.setInitData(request, response, modelMap, initData);
    }

    private Map<String, String> showBtn(PdSpFlowFullDTO dto) {
        HashMap map = Maps.newHashMap();
        map.put("showPassBtn", "1");
        map.put("showUndoBtn", "1");
        map.put("showEditBtn", "1");
        map.put("showEndBtn", "1");
        try {
            this.checkPass(dto);
        }
        catch (Exception e) {
            map.put("showPassBtn", e.getMessage());
        }
        try {
            this.checkRevoke(dto);
        }
        catch (Exception e) {
            map.put("showUndoBtn", e.getMessage());
        }
        try {
            this.checkEdit(dto);
        }
        catch (Exception e) {
            map.put("showEditBtn", e.getMessage());
        }
        try {
            this.checkEnd(dto);
        }
        catch (Exception e) {
            map.put("showEndBtn", e.getMessage());
        }
        return map;
    }

    protected void checkEnd(PdSpFlowFullDTO dto) throws ShrWebBizException {
        this.checkFlow(dto);
        this.checkFlowStatus(dto.getFlow().getStatus(), PdFlowStatusEnum.endable(), "\u7ed3\u675f");
    }

    protected void checkEdit(PdSpFlowFullDTO dto) throws ShrWebBizException {
        this.checkFlow(dto);
        this.checkFlowStatus(dto.getFlow().getStatus(), PdFlowStatusEnum.editable(), "\u7f16\u8f91");
        this.checkNoteForEdit(dto);
    }

    protected void checkNoteForEdit(PdSpFlowFullDTO dto) throws ShrWebBizException {
        if (!PdNoteStatusEnum.UNSUBMIT.getValue().equals(dto.getFirstNote().getStatus())) {
            throw new ShrWebBizException("\u7b2c\u4e00\u4e2a\u8282\u70b9\u5fc5\u987b\u662f\u672a\u63d0\u4ea4\uff01");
        }
        if (!"1".equals(dto.getFirstNote().getIsCurr())) {
            throw new ShrWebBizException("\u7b2c\u4e00\u4e2a\u8282\u70b9\u975e\u5f53\u524d\u8282\u70b9\uff01");
        }
        if (!dto.getHandlerMap().get(dto.getFirstNote().getId()).contains(this.person_id)) {
            throw new ShrWebBizException("\u7b2c\u4e00\u4e2a\u8282\u70b9\u5904\u7406\u4eba\u975e\u5f53\u524d\u7528\u6237\uff01");
        }
    }

    protected void checkRevoke(PdSpFlowFullDTO dto) throws ShrWebBizException {
        this.checkFlow(dto);
        this.checkFlowStatus(dto.getFlow().getStatus(), PdFlowStatusEnum.revocable(), "\u64a4\u56de");
        this.checkNoteForRevoke(dto);
    }

    private void checkNoteForRevoke(PdSpFlowFullDTO dto) throws ShrWebBizException {
        if (!PdNoteStatusEnum.SUBMITTED.getValue().equals(dto.getFirstNote().getStatus())) {
            throw new ShrWebBizException("\u7b2c\u4e00\u4e2a\u8282\u70b9\u975e\u5df2\u63d0\u4ea4\uff01");
        }
        if (!dto.getHandlerMap().get(dto.getFirstNote().getId()).contains(this.person_id)) {
            throw new ShrWebBizException("\u7b2c\u4e00\u4e2a\u8282\u70b9\u5904\u7406\u4eba\u975e\u5f53\u524d\u7528\u6237\uff01");
        }
        if (!PdNoteStatusEnum.UNSUBMIT.getValue().equals(dto.getSecondNote().getStatus())) {
            throw new ShrWebBizException("\u7b2c\u4e8c\u4e2a\u8282\u70b9\u975e\u672a\u63d0\u4ea4\uff01");
        }
        if (!"1".equals(dto.getSecondNote().getIsCurr())) {
            throw new ShrWebBizException("\u7b2c\u4e8c\u4e2a\u8282\u70b9\u975e\u5f53\u524d\u8282\u70b9\uff01");
        }
    }

    protected void checkRejectAll(PdSpFlowFullDTO dto) throws ShrWebBizException {
        this.checkFlow(dto);
        this.checkFlowStatus(dto.getFlow().getStatus(), PdFlowStatusEnum.rejectable(), "\u9a73\u56de");
        this.checkNoteForPass(dto);
    }

    protected void checkPass(PdSpFlowFullDTO dto) throws ShrWebBizException {
        this.checkFlow(dto);
        this.checkFlowStatus(dto.getFlow().getStatus(), PdFlowStatusEnum.passable(), "\u901a\u8fc7");
        this.checkNoteForPass(dto);
    }

    private void checkNoteForPass(PdSpFlowFullDTO dto) throws ShrWebBizException {
        PdSpFlowNoteDTO currNote = dto.getCurrNote();
        if (!PdNoteStatusEnum.UNSUBMIT.getValue().equals(currNote.getStatus())) {
            throw new ShrWebBizException("\u5f53\u524d\u8282\u70b9\u72b6\u6001\u975e\u672a\u63d0\u4ea4\uff01");
        }
        if ("1".equals(currNote.getIsFirst())) {
            throw new ShrWebBizException("\u5f53\u524d\u8282\u70b9\u4e0d\u80fd\u4e3a\u7b2c\u4e00\u8282\u70b9\uff01");
        }
        List<String> handlerList = dto.getHandlerMap().get(currNote.getId());
        if (CollectionUtils.isEmpty(handlerList) || !handlerList.contains(this.person_id)) {
            throw new ShrWebBizException("\u5f53\u524d\u8282\u70b9\u5904\u7406\u4eba\u975e\u5f53\u524d\u7528\u6237\uff01");
        }
    }

    protected void checkFlow(PdSpFlowFullDTO dto) throws ShrWebBizException {
        if (dto.getFlow() == null) {
            throw new ShrWebBizException("\u6d41\u7a0b\u4e0d\u5b58\u5728\uff01");
        }
        if (CollectionUtils.isEmpty(dto.getNotes())) {
            throw new ShrWebBizException("\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        }
        if (MapUtils.isEmpty(dto.getHandlerMap())) {
            throw new ShrWebBizException("\u8282\u70b9\u5904\u7406\u4eba\u4e0d\u5b58\u5728\uff01");
        }
        if (dto.getFirstNote() == null) {
            throw new ShrWebBizException("\u7b2c\u4e00\u4e2a\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        }
        if (dto.getSecondNote() == null) {
            throw new ShrWebBizException("\u7b2c\u4e8c\u4e2a\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        }
        if (dto.getCurrNote() == null) {
            throw new ShrWebBizException("\u5f53\u524d\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        }
    }

    private void checkFlowStatus(String status, List<PdFlowStatusEnum> allowList, String action) throws ShrWebBizException {
        if (StringUtils.isBlank((String)status)) {
            throw new ShrWebBizException("\u72b6\u6001\u4e0d\u5b58\u5728\uff01");
        }
        if (allowList.stream().map(PdFlowStatusEnum::getValue).noneMatch(s -> s.equals(status))) {
            throw new ShrWebBizException(allowList.stream().map(PdFlowStatusEnum::getAlias).collect(Collectors.joining("\u3001")) + "\u72b6\u6001\uff0c\u624d\u53ef\u4ee5" + action + "\uff01");
        }
    }

    protected String sqlOfUpdateflowStatus(String flowId, String status) {
        return "/*dialect*/ update CT_MP_pdSpFlow set CFSTATUS = '" + status + "', FLASTUPDATEUSERID = '" + this.user_id + "', FLASTUPDATETIME = sysdate where FID = '" + flowId + "'";
    }

    protected String sqlOfUpdateNote(String noteId, PdNoteStatusEnum status, String comment) {
        return "/*dialect*/ update CT_MP_pdSpFlowNote set CFSTATUS = '" + status.getValue() + "', CFHANDLERID = '" + this.person_id + "', CFHANDLETIME = sysdate, CFCOMMENT = '" + comment + "', FLASTUPDATEUSERID = '" + this.user_id + "', FLASTUPDATETIME = sysdate " + "where FID = '" + noteId + "'";
    }

    protected String sqlOfUpdateNoteWhenRovoke(String noteId) {
        return "/*dialect*/ update CT_MP_pdSpFlowNote set CFSTATUS = '" + PdNoteStatusEnum.UNSUBMIT.getValue() + "', CFHANDLERID = null, CFHANDLETIME = null, CFCOMMENT = null, FLASTUPDATEUSERID = '" + this.user_id + "', FLASTUPDATETIME = sysdate " + "where FID = '" + noteId + "'";
    }

    protected String sqlOfClearNote(String flowId) {
        return "/*dialect*/ update CT_MP_pdSpFlowNote set CFHANDLERID = null, CFHANDLETIME = null, CFCOMMENT = null, FLASTUPDATEUSERID = '" + this.user_id + "', FLASTUPDATETIME = sysdate where CFSPFLOWID = '" + flowId + "'";
    }

    protected String sqlOfUpdateNoteStatusByFlowId(String flowId, String status) {
        return "/*dialect*/ update CT_MP_pdSpFlowNote set CFSTATUS = '" + status + "', FLASTUPDATEUSERID = '" + this.user_id + "', FLASTUPDATETIME = sysdate where CFSPFLOWID = '" + flowId + "'";
    }

    protected List<String> sqlOfResetCurrNote(String flowId, String noteId) {
        ArrayList list = Lists.newArrayList();
        list.add("/*dialect*/ update CT_MP_pdSpFlowNote set CFISCURR = 0 where CFSPFLOWID = '" + flowId + "' ");
        if (StringUtils.isNotBlank((String)noteId)) {
            list.add("/*dialect*/ update CT_MP_pdSpFlowNote set CFISCURR = 1 where CFSPFLOWID = '" + flowId + "' and FID = '" + noteId + "' ");
        }
        return list;
    }

    protected String sqlOfUpdateNoteStatusForEnd(String flowId) {
        return "/*dialect*/ update CT_MP_pdSpFlowNote set CFSTATUS = '" + PdNoteStatusEnum.COMPLETED.getValue() + "', FLASTUPDATEUSERID = '" + this.user_id + "', FLASTUPDATETIME = sysdate where CFSPFLOWID = '" + flowId + "' and CFSTATUS = '" + PdNoteStatusEnum.UNSUBMIT.getValue() + "'";
    }

    protected String sqlOfUpdateFlowWhenEditSubmit(String flowId, String reason, String result2) {
        return "/*dialect*/ update CT_MP_pdSpFlow set CFREASON='" + reason + "', CFSTATUS='" + PdFlowStatusEnum.NO_APPROVAL.getValue() + "', CFRESULT='" + result2 + "', FLASTUPDATEUSERID='" + this.user_id + "', FLASTUPDATETIME=sysdate where FID='" + flowId + "'";
    }

    protected String sqlOfUpdateFlowWhenEditSave(String flowId, String reason) {
        return "/*dialect*/ update CT_MP_pdSpFlow set CFREASON='" + reason + "', FLASTUPDATEUSERID='" + this.user_id + "', FLASTUPDATETIME=sysdate where FID='" + flowId + "'";
    }

    protected void success() throws SHRWebException {
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    protected void checkComment(String comment) throws ShrWebBizException {
        if (StringUtils.isBlank((String)comment)) {
            throw new ShrWebBizException("\u5ba1\u6279\u610f\u89c1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (comment.length() > 255) {
            throw new ShrWebBizException("\u5ba1\u6279\u610f\u89c1\u957f\u5ea6\u8d85\u9650\uff01");
        }
    }
}

