/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pd.web.handler.flow;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.pd.web.dto.PdFlowDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowFullDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowNoteDTO;
import com.kingdee.shr.pd.web.dto.req.PdPsrSpFlowRequestDTO;
import com.kingdee.shr.pd.web.dto.req.inner.PdPsrSpFlowPdRequestDTO;
import com.kingdee.shr.pd.web.enums.PdFlowFromEnum;
import com.kingdee.shr.pd.web.enums.PdFlowStatusEnum;
import com.kingdee.shr.pd.web.enums.PdFlowXpCommentEnum;
import com.kingdee.shr.pd.web.enums.PdNoteStatusEnum;
import com.kingdee.shr.pd.web.enums.PdNoticeContentEnum;
import com.kingdee.shr.pd.web.enums.PdSpFlowPdResultEnum;
import com.kingdee.shr.pd.web.enums.PdSpFlowPdStatusEnum;
import com.kingdee.shr.pd.web.handler.flow.PdFlowEditHandler;
import com.kingdee.shr.pd.web.rule.PdRule;
import com.kingdee.shr.pd.web.rule.PdRuleResult;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.ui.ModelMap;

public class PdFlowEditHandler4Form
extends PdFlowEditHandler {
    private static final String LOG_HEAD = "wdpd_" + PdFlowEditHandler4Form.class.getSimpleName() + "_";

    public void spFlowSaveAction(HttpServletRequest req, HttpServletResponse resp, ModelMap m) throws BOSException, SHRWebException, SQLException {
        String reqStr = req.getParameter("spFlowData");
        PdPsrSpFlowRequestDTO reqDTO = this.component.parseJson(reqStr, PdPsrSpFlowRequestDTO.class);
        this.checkNotNull(reqDTO);
        this.checkBiz(reqDTO);
        this.doSave(reqDTO);
        this.success();
    }

    private void checkNotNull(PdPsrSpFlowRequestDTO reqDTO) throws ShrWebBizException {
        if (reqDTO == null) {
            throw new ShrWebBizException("\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((String)reqDTO.getFlowId())) {
            throw new ShrWebBizException("\u6d41\u7a0bID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isBlank((String)reqDTO.getReason())) {
            throw new ShrWebBizException("\u5ba1\u6279\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<PdPsrSpFlowPdRequestDTO> reqPdList = reqDTO.getSpFlowPdList();
        if (CollectionUtils.isEmpty(reqPdList)) {
            throw new ShrWebBizException("\u76d8\u70b9\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (PdPsrSpFlowPdRequestDTO pd : reqPdList) {
            if (StringUtils.isBlank((String)pd.getPdId())) {
                throw new ShrWebBizException("\u76d8\u70b9ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isBlank((String)pd.getResult())) {
                throw new ShrWebBizException("\u76d8\u70b9\u7ed3\u679c\u5fc5\u9009\uff01");
            }
            String xpComment = pd.getContinueComment();
            if (StringUtils.isBlank((String)xpComment)) {
                throw new ShrWebBizException("\u7eed\u8058\u5efa\u8bae\u5fc5\u9009\uff01");
            }
            if (!PdFlowXpCommentEnum.descRequired().stream().anyMatch(e -> e.getValue().equals(xpComment)) || !StringUtils.isBlank((String)pd.getContinueCommentDesc())) continue;
            throw new ShrWebBizException(PdFlowXpCommentEnum.descRequired().stream().map(PdFlowXpCommentEnum::getAlias).collect(Collectors.joining("\u3001")) + "\u7eed\u8058\u5efa\u8bae\uff0c\u7eed\u8058\u5efa\u8bae\u8bf4\u660e\u5fc5\u586b\uff01");
        }
    }

    private PdSpFlowFullDTO checkBiz(PdPsrSpFlowRequestDTO reqDTO) throws ShrWebBizException {
        PdSpFlowFullDTO fullDTO = this.component.flow(reqDTO.getFlowId());
        PdSpFlowDTO flow = fullDTO.getFlow();
        if (flow == null) {
            throw new ShrWebBizException("\u6d41\u7a0b\u4e0d\u5b58\u5728\uff01");
        }
        if (PdFlowStatusEnum.editable().stream().noneMatch(e -> e.getValue().equals(flow.getStatus()))) {
            throw new ShrWebBizException(PdFlowStatusEnum.editable().stream().map(PdFlowStatusEnum::getAlias).collect(Collectors.joining("\u3001")) + "\u72b6\u6001\uff0c\u624d\u53ef\u4ee5\u4fdd\u5b58\u6216\u63d0\u4ea4\uff01");
        }
        List<PdSpFlowNoteDTO> notes = fullDTO.getNotes();
        if (CollectionUtils.isEmpty(notes)) {
            throw new ShrWebBizException("\u6d41\u7a0b\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        }
        PdSpFlowNoteDTO firstNote = fullDTO.getFirstNote();
        if (firstNote == null) {
            throw new ShrWebBizException("\u6d41\u7a0b\u7b2c\u4e00\u4e2a\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        }
        PdSpFlowNoteDTO secondNote = fullDTO.getFirstNote();
        if (secondNote == null) {
            throw new ShrWebBizException("\u6d41\u7a0b\u7b2c\u4e8c\u4e2a\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        }
        PdSpFlowNoteDTO currNote = fullDTO.getFirstNote();
        if (currNote == null) {
            throw new ShrWebBizException("\u6d41\u7a0b\u5f53\u524d\u8282\u70b9\u4e0d\u5b58\u5728\uff01");
        }
        if (!firstNote.getId().equals(currNote.getId())) {
            throw new ShrWebBizException("\u6d41\u7a0b\u7b2c\u4e00\u4e2a\u8282\u70b9\u5fc5\u987b\u4e3a\u5f53\u524d\u8282\u70b9\uff01");
        }
        if (!PdNoteStatusEnum.UNSUBMIT.getValue().equals(firstNote.getStatus())) {
            throw new ShrWebBizException("\u6d41\u7a0b\u7b2c\u4e00\u4e2a\u8282\u70b9\u5fc5\u987b\u4e3a\u672a\u63d0\u4ea4\uff01");
        }
        List<PdFlowDTO> flowPds = fullDTO.getFlowPds();
        if (CollectionUtils.isEmpty(flowPds)) {
            throw new ShrWebBizException("\u76d8\u70b9\u5458\u5de5\u4e0d\u5b58\u5728\uff01");
        }
        Set reqPdIdSet = reqDTO.getSpFlowPdList().stream().map(PdPsrSpFlowPdRequestDTO::getPdId).collect(Collectors.toSet());
        Set existPdIdSet = fullDTO.getFlowPds().stream().map(PdFlowDTO::getPdId).collect(Collectors.toSet());
        if (!existPdIdSet.containsAll(reqPdIdSet)) {
            throw new ShrWebBizException("\u76d8\u70b9\u5458\u5de5\u4e0d\u5c5e\u5f53\u524d\u6d41\u7a0b\uff01");
        }
        Set gidSet = fullDTO.getFlowPds().stream().map(PdFlowDTO::getGid).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(gidSet) || gidSet.size() > 1) {
            throw new ShrWebBizException("\u6392\u5e8f\u7fa4\u4f53\u4e3a\u7a7a\u6216\u591a\u4e8e1\u4e2a\uff01");
        }
        return fullDTO;
    }

    private boolean doSave(PdPsrSpFlowRequestDTO dto) throws BOSException, SQLException {
        String flowSql = this.sqlOfUpdateFlowWhenEditSave(dto.getFlowId(), dto.getReason());
        return this.component.tx(Lists.newArrayList((Object[])new String[]{flowSql}), this.updatePdSql(dto.getSpFlowPdList(), null));
    }

    private Map<String, List<Object[]>> updatePdSql(List<PdPsrSpFlowPdRequestDTO> pdList, String status) {
        String sql = StringUtils.isNotBlank((String)status) ? "/*dialect*/ update CT_MP_pdPerson set CFRESULT          = ?,     CFRESULT_EXPLAIN  = ?,     CFXP_IDEA         = ?,     CFXP_IDEA_EXPLAIN = ?,     CFLAST_RESULT = ?,     CFLast_xp_idea = ?,     CFUPDATE_RESULT = ?,     CFUPDATE_XP_IDEA = ?,     CFStatus = ?,     FLASTUPDATEUSERID = '" + this.user_id + "', " + "    FLASTUPDATETIME   = sysdate " + "where FID = ?" : "/*dialect*/ update CT_MP_pdPerson set CFRESULT          = ?,     CFRESULT_EXPLAIN  = ?,     CFXP_IDEA         = ?,     CFXP_IDEA_EXPLAIN = ?,     CFLAST_RESULT = ?,     CFLast_xp_idea = ?,     CFUPDATE_RESULT = ?,     CFUPDATE_XP_IDEA = ?,     FLASTUPDATEUSERID = '" + this.user_id + "', " + "    FLASTUPDATETIME   = sysdate " + "where FID = ?";
        ArrayList params = Lists.newArrayList();
        for (PdPsrSpFlowPdRequestDTO pd : pdList) {
            String pdResult = pd.getResult();
            String pdResultAlias = PdSpFlowPdResultEnum.aliasOf(pdResult);
            String xpComment = pd.getContinueComment();
            String xpCommentAlias = PdFlowXpCommentEnum.aliasOf(pd.getContinueComment());
            if (StringUtils.isNotBlank((String)status)) {
                params.add(new Object[]{pdResult, pd.getResultDesc(), xpComment, pd.getContinueCommentDesc(), pdResultAlias, xpCommentAlias, pdResultAlias, xpCommentAlias, status, pd.getPdId()});
                continue;
            }
            params.add(new Object[]{pdResult, pd.getResultDesc(), xpComment, pd.getContinueCommentDesc(), pdResultAlias, xpCommentAlias, pdResultAlias, xpCommentAlias, pd.getPdId()});
        }
        HashMap map = Maps.newHashMap();
        map.put(sql, params);
        return map;
    }

    public void spFlowSubmitAction(HttpServletRequest req, HttpServletResponse resp, ModelMap m) throws BOSException, SHRWebException, SQLException {
        String reqStr = req.getParameter("spFlowData");
        PdPsrSpFlowRequestDTO reqDTO = this.component.parseJson(reqStr, PdPsrSpFlowRequestDTO.class);
        this.checkNotNull(reqDTO);
        PdSpFlowFullDTO fullDTO = this.checkBiz(reqDTO);
        String pass = "";
        if (this.doSave(reqDTO)) {
            pass = this.doSubmit(reqDTO, fullDTO);
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        result2.put("pass", pass);
        this.writeSuccessData(result2);
    }

    private String doSubmit(PdPsrSpFlowRequestDTO reqDTO, PdSpFlowFullDTO fullDTO) throws BOSException, SQLException {
        PdFlowDTO pd = fullDTO.getFlowPds().get(0);
        List<String> resultCodes = reqDTO.getSpFlowPdList().stream().map(PdPsrSpFlowPdRequestDTO::getResult).collect(Collectors.toList());
        PdRuleResult ruleResult = PdRule.execute(pd.getGid(), pd.getGname(), resultCodes);
        if (ruleResult.isPass()) {
            this.deleteFlow(reqDTO, pd.getShrId());
            return "1";
        }
        this.submitFlow(reqDTO, ruleResult.getSummary(), fullDTO);
        return "0";
    }

    private void deleteFlow(PdPsrSpFlowRequestDTO reqDTO, String shrId) throws BOSException, SQLException {
        String flowId = reqDTO.getFlowId();
        String delFlowPdSql = "/*dialect*/ delete from CT_MP_pdSpFlowPd where CFSPFLOWID ='" + flowId + "'";
        String delHandlerSql = "/*dialect*/ delete from CT_MP_PdSpFlowNoteHandler h where h.CFspFlowNoteId in (select n.FID from CT_MP_pdSpFlowNote n where n.CFSPFLOWID = '" + flowId + "')";
        String delNoteSql = "/*dialect*/ delete from CT_MP_pdSpFlowNote where CFSPFLOWID = '" + flowId + "'";
        String delFlowSql = "/*dialect*/ delete from CT_MP_pdSpFlow where FID = '" + flowId + "'";
        PdSpFlowPdStatusEnum statusEnum = StringUtils.isNotBlank((String)shrId) ? PdSpFlowPdStatusEnum.AUDITING : PdSpFlowPdStatusEnum.AUDITED;
        Map<String, List<Object[]>> updatePdSql = this.updatePdSql(reqDTO.getSpFlowPdList(), statusEnum.getValue());
        this.component.tx(Lists.newArrayList((Object[])new String[]{delFlowPdSql, delHandlerSql, delNoteSql, delFlowSql}), updatePdSql);
    }

    private void submitFlow(PdPsrSpFlowRequestDTO reqDTO, String result2, PdSpFlowFullDTO fullDTO) throws BOSException, SQLException {
        String flowId = reqDTO.getFlowId();
        String firstNoteId = fullDTO.getFirstNote().getId();
        String secondNoteId = fullDTO.getSecondNote().getId();
        String updateFlowSql = this.sqlOfUpdateFlowWhenEditSubmit(flowId, reqDTO.getReason(), result2);
        String clearNoteSql = this.sqlOfClearNote(flowId);
        String updateNoteSql = this.sqlOfUpdateNote(firstNoteId, PdNoteStatusEnum.SUBMITTED, "\u901a\u8fc7\u3002");
        List<String> resetCurrNoteSqls = this.sqlOfResetCurrNote(flowId, secondNoteId);
        ArrayList sqls = Lists.newArrayList();
        sqls.add(updateFlowSql);
        sqls.add(clearNoteSql);
        sqls.add(updateNoteSql);
        sqls.addAll(resetCurrNoteSqls);
        if (this.component.tx(sqls, this.updatePdSql(reqDTO.getSpFlowPdList(), null))) {
            Set<String> toUsers = fullDTO.getHandlerNumberMap().get(secondNoteId);
            String message = MessageFormat.format(this.component.getTemplate(PdNoticeContentEnum.FLOW_PASS), this.person_name, fullDTO.getFlow().getGname());
            String url = this.component.getUrl(PdFlowFromEnum.AP, flowId);
            this.component.notice(toUsers, message, url);
        }
    }
}

