/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pd.web.handler.flow;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.pd.web.dto.PdSpFlowFullDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowNoteDTO;
import com.kingdee.shr.pd.web.enums.PdFlowFromEnum;
import com.kingdee.shr.pd.web.enums.PdFlowStatusEnum;
import com.kingdee.shr.pd.web.enums.PdNoteStatusEnum;
import com.kingdee.shr.pd.web.enums.PdNoticeContentEnum;
import com.kingdee.shr.pd.web.handler.flow.PdFlowEditHandler;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;

public class PdFlowEditHandler4View
extends PdFlowEditHandler {
    private static final String LOG_HEAD = "wdpd_" + PdFlowEditHandler4View.class.getSimpleName() + "_";

    public void endAction(HttpServletRequest req, HttpServletResponse resp, ModelMap model) throws BOSException, SHRWebException, SQLException {
        String fid = req.getParameter("id");
        String comment = req.getParameter("comment");
        PdSpFlowFullDTO dto = this.component.flow(fid);
        this.checkEnd(dto);
        this.checkComment(comment);
        this.doEnd(dto, comment);
        this.success();
    }

    private void doEnd(PdSpFlowFullDTO dto, String comment) throws BOSException, SQLException {
        String flowId = dto.getFlow().getId();
        String currNoteId = dto.getCurrNote().getId();
        String updateFlowStatusSql = this.sqlOfUpdateflowStatus(flowId, PdFlowStatusEnum.FINISHED.getValue());
        String updateNoteStatusSql = this.sqlOfUpdateNoteStatusForEnd(flowId);
        String updateNoteSql = this.sqlOfUpdateNote(currNoteId, PdNoteStatusEnum.COMPLETED, comment);
        List<String> resetCurrNoteSqls = this.sqlOfResetCurrNote(flowId, null);
        Map<String, List<Object[]>> updatePdStatusSql = this.component.getUpdatePdStatusMap(flowId);
        ArrayList sqls = Lists.newArrayList();
        sqls.add(updateFlowStatusSql);
        sqls.add(updateNoteStatusSql);
        sqls.add(updateNoteSql);
        sqls.addAll(resetCurrNoteSqls);
        if (this.component.tx(sqls, updatePdStatusSql)) {
            HashSet toUsers = Sets.newHashSet((Object[])new String[]{dto.getFlow().getPnumber()});
            String message = MessageFormat.format(this.component.getTemplate(PdNoticeContentEnum.FLOW_COMPLETE), dto.getFlow().getGname());
            String url = this.component.getUrl(PdFlowFromEnum.ST, flowId);
            this.component.notice(toUsers, message, url);
        }
    }

    public void passAction(HttpServletRequest req, HttpServletResponse resp, ModelMap model) throws SHRWebException, BOSException, SQLException {
        String fid = req.getParameter("id");
        String comment = req.getParameter("comment");
        PdSpFlowFullDTO dto = this.component.flow(fid);
        this.checkPass(dto);
        this.checkComment(comment);
        this.doPass(dto, comment);
        this.success();
    }

    private void doPass(PdSpFlowFullDTO dto, String comment) throws BOSException, SQLException {
        if (dto.getCurrNextNote() == null) {
            this.completeFlow(dto, comment);
        } else {
            this.passNote(dto, comment);
        }
    }

    private void completeFlow(PdSpFlowFullDTO dto, String comment) throws BOSException, SQLException {
        String flowId = dto.getFlow().getId();
        String currNoteId = dto.getCurrNote().getId();
        String updateFlowStatusSql = this.sqlOfUpdateflowStatus(flowId, PdFlowStatusEnum.APPROVED.getValue());
        String updateNoteSql = this.sqlOfUpdateNote(currNoteId, PdNoteStatusEnum.SUBMITTED, comment);
        List<String> resetCurrNoteSqls = this.sqlOfResetCurrNote(flowId, null);
        Map<String, List<Object[]>> updatePdStatusSql = this.component.getUpdatePdStatusMap(flowId);
        ArrayList sqls = Lists.newArrayList();
        sqls.add(updateFlowStatusSql);
        sqls.add(updateNoteSql);
        sqls.addAll(resetCurrNoteSqls);
        if (this.component.tx(sqls, updatePdStatusSql)) {
            HashSet toUsers = Sets.newHashSet((Object[])new String[]{dto.getFlow().getPnumber()});
            String message = MessageFormat.format(this.component.getTemplate(PdNoticeContentEnum.FLOW_COMPLETE), dto.getFlow().getGname());
            String url = this.component.getUrl(PdFlowFromEnum.ST, flowId);
            this.component.notice(toUsers, message, url);
        }
    }

    private void passNote(PdSpFlowFullDTO dto, String comment) throws BOSException, SQLException {
        String flowId = dto.getFlow().getId();
        String currNoteId = dto.getCurrNote().getId();
        String currNextNoteId = dto.getCurrNextNote().getId();
        String updateFlowStatusSql = this.sqlOfUpdateflowStatus(flowId, PdFlowStatusEnum.APPROVING.getValue());
        String updateNoteSql = this.sqlOfUpdateNote(currNoteId, PdNoteStatusEnum.SUBMITTED, comment);
        List<String> resetCurrNoteSqls = this.sqlOfResetCurrNote(flowId, currNextNoteId);
        ArrayList sqls = Lists.newArrayList();
        sqls.add(updateFlowStatusSql);
        sqls.add(updateNoteSql);
        sqls.addAll(resetCurrNoteSqls);
        if (this.component.tx(sqls, null)) {
            Set<String> toUsers = dto.getHandlerNumberMap().get(currNextNoteId);
            String message = MessageFormat.format(this.component.getTemplate(PdNoticeContentEnum.FLOW_PASS), dto.getFlow().getPname(), dto.getFlow().getGname());
            String url = this.component.getUrl(PdFlowFromEnum.AP, flowId);
            this.component.notice(toUsers, message, url);
        }
    }

    public void rejectAllAction(HttpServletRequest req, HttpServletResponse resp, ModelMap model) throws BOSException, SHRWebException, SQLException {
        String fid = req.getParameter("id");
        String comment = req.getParameter("comment");
        PdSpFlowFullDTO dto = this.component.flow(fid);
        this.checkRejectAll(dto);
        this.checkComment(comment);
        this.doRejectAll(dto, comment);
        this.success();
    }

    private void doRejectAll(PdSpFlowFullDTO dto, String comment) throws BOSException, SQLException {
        String flowId = dto.getFlow().getId();
        String currNoteId = dto.getCurrNote().getId();
        String updateFlowStatusSql = this.sqlOfUpdateflowStatus(flowId, PdFlowStatusEnum.REJECTED.getValue());
        String updateNoteStatusSql = this.sqlOfUpdateNoteStatusByFlowId(flowId, PdNoteStatusEnum.UNSUBMIT.getValue());
        String updateNoteSql = this.sqlOfUpdateNote(currNoteId, PdNoteStatusEnum.UNSUBMIT, comment);
        List<String> resetCurrNoteSqls = this.sqlOfResetCurrNote(flowId, dto.getFirstNote().getId());
        ArrayList sqls = Lists.newArrayList();
        sqls.add(updateFlowStatusSql);
        sqls.add(updateNoteStatusSql);
        sqls.add(updateNoteSql);
        sqls.addAll(resetCurrNoteSqls);
        if (this.component.tx(sqls, null)) {
            HashSet toUsers = Sets.newHashSet((Object[])new String[]{dto.getFlow().getPnumber()});
            String message = MessageFormat.format(this.component.getTemplate(PdNoticeContentEnum.FLOW_REJECT), dto.getFlow().getGname(), this.person_name);
            String url = this.component.getUrl(PdFlowFromEnum.ST, flowId);
            this.component.notice(toUsers, message, url);
        }
    }

    public void revokeAction(HttpServletRequest req, HttpServletResponse resp, ModelMap model) throws BOSException, SHRWebException, SQLException {
        String fid = req.getParameter("id");
        PdSpFlowFullDTO dto = this.component.flow(fid);
        this.checkRevoke(dto);
        this.doRevoke(dto);
        this.success();
    }

    private void doRevoke(PdSpFlowFullDTO dto) throws BOSException, SQLException {
        String flowId = dto.getFlow().getId();
        PdSpFlowNoteDTO firstNote = dto.getFirstNote();
        String updateFlowStatusSql = this.sqlOfUpdateflowStatus(flowId, PdFlowStatusEnum.UNSUBMIT.getValue());
        String updateNoteSql = this.sqlOfUpdateNoteWhenRovoke(firstNote.getId());
        List<String> resetCurrNoteSqls = this.sqlOfResetCurrNote(flowId, firstNote.getId());
        ArrayList sqls = Lists.newArrayList();
        sqls.add(updateFlowStatusSql);
        sqls.add(updateNoteSql);
        sqls.addAll(resetCurrNoteSqls);
        this.component.tx(sqls, null);
    }

    public void editCheckAction(HttpServletRequest req, HttpServletResponse resp, ModelMap model) throws SHRWebException {
        PdSpFlowFullDTO dto = this.component.flow(req.getParameter("id"));
        this.checkEdit(dto);
        this.success();
    }
}

