/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pd.web.handler.flow;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.exception.ShrWebBizException;
import com.kingdee.shr.base.syssetting.json.GridDataEntity;
import com.kingdee.shr.base.syssetting.web.handler.ListHandler;
import com.kingdee.shr.pd.web.dto.PdFlowNoticeDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowDTO;
import com.kingdee.shr.pd.web.dto.PdSpFlowNoteHandlerDTO;
import com.kingdee.shr.pd.web.enums.PdFlowFromEnum;
import com.kingdee.shr.pd.web.enums.PdFlowStatusEnum;
import com.kingdee.shr.pd.web.enums.PdNoticeContentEnum;
import com.kingdee.shr.pd.web.server.PdSpComponent;
import com.kingdee.shr.pd.web.util.PdUtil;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.ui.ModelMap;

public class PdFlowListHandler
extends ListHandler {
    private static final String LOG_HEAD = "wdpd_" + PdFlowListHandler.class.getSimpleName() + "_";
    protected final Context ctx = SHRContext.getInstance().getContext();
    protected final String user_id = this.ctx.getCaller().toString();
    protected final String person_id = ContextUtil.getCurrentUserInfo((Context)this.ctx).getPerson().getId().toString();
    protected final PdSpComponent component = new PdSpComponent(this.ctx);

    protected FilterInfo getCustomFilter(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        JSONObject jsonObject;
        String schemeId;
        String paramJson = request.getParameter("custom_params");
        if (StringUtils.isNotBlank((String)paramJson) && StringUtils.isNotBlank((String)(schemeId = (String)(jsonObject = JSONObject.parseObject((String)paramJson)).get((Object)"schemeId")))) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("pdScheme", (Object)schemeId));
            return filterInfo;
        }
        return super.getCustomFilter(request, response);
    }

    protected void afterGetListData(HttpServletRequest request, HttpServletResponse response, GridDataEntity gridDataEntity) throws SHRWebException {
        this.setData(gridDataEntity);
        super.afterGetListData(request, response, gridDataEntity);
    }

    private void setData(GridDataEntity gridDataEntity) {
        List rowsData;
        if (gridDataEntity != null && CollectionUtils.isNotEmpty((Collection)(rowsData = gridDataEntity.getRows()))) {
            HashSet spFlowIdSet = Sets.newHashSet();
            rowsData.forEach(rowData -> spFlowIdSet.add(rowData.get("id").toString()));
            Map<String, List<PdSpFlowNoteHandlerDTO>> currSprMap = this.component.mapFlowId2CurrNoteHandlers(spFlowIdSet);
            for (Map rowData2 : rowsData) {
                String spFlowId = rowData2.get("id").toString();
                String sprNames = currSprMap.getOrDefault(spFlowId, Lists.newArrayList()).stream().map(PdSpFlowNoteHandlerDTO::getHandlerName).collect(Collectors.joining("\u3001"));
                rowData2.put("currSpr", sprNames);
                try {
                    JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString(rowData2.get("status")));
                    rowData2.put("statusValue", jsonObject.get((Object)"value"));
                }
                catch (Exception ignored) {}
            }
        }
    }

    protected void success() throws SHRWebException {
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        this.writeSuccessData(result2);
    }

    public void noticeAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        Set<String> ids = PdUtil.split(request.getParameter("ids"));
        this.checkNotice(ids);
        String toUser = this.doNotice(ids);
        HashMap<String, String> result2 = new HashMap<String, String>();
        result2.put("result", "200");
        result2.put("toUser", toUser);
        this.writeSuccessData(result2);
    }

    public void noticeCheckAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        this.checkNotice(PdUtil.split(request.getParameter("ids")));
        this.success();
    }

    private void checkNotice(Set<String> ids) throws ShrWebBizException {
        Map<String, PdSpFlowDTO> flowMap = this.checkNotNull(ids);
        for (String id : ids) {
            String stutas = flowMap.get(id).getStatus();
            if (!PdFlowStatusEnum.ableToNotcie().stream().noneMatch(en -> en.getValue().equals(stutas))) continue;
            throw new ShrWebBizException(PdFlowStatusEnum.ableToNotcie().stream().map(PdFlowStatusEnum::getAlias).collect(Collectors.joining("\u3001")) + "\u72b6\u6001\uff0c\u624d\u53ef\u4ee5\u50ac\u529e\uff01");
        }
    }

    protected Map<String, PdSpFlowDTO> checkNotNull(Set<String> ids) throws ShrWebBizException {
        if (CollectionUtils.isEmpty(ids)) {
            throw new ShrWebBizException("\u6d41\u7a0bID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Map<String, PdSpFlowDTO> flowMap = this.component.mapSpFlow(ids);
        if (MapUtils.isEmpty(flowMap)) {
            throw new ShrWebBizException("\u6d41\u7a0b\u4e0d\u5b58\u5728\uff01");
        }
        for (String id : ids) {
            if (flowMap.get(id) != null) continue;
            throw new ShrWebBizException(id + " \u4e0d\u5b58\u5728\uff01");
        }
        return flowMap;
    }

    private String doNotice(Set<String> ids) {
        List<PdFlowNoticeDTO> list = this.component.listForNotice(ids);
        Map groupMap = list.stream().collect(Collectors.groupingBy(PdFlowNoticeDTO::getFlowId, Collectors.toList()));
        for (List dtos : groupMap.values()) {
            String message;
            Set<Object> toUsers;
            PdFlowFromEnum from;
            PdFlowNoticeDTO flow = (PdFlowNoticeDTO)dtos.get(0);
            String flowId = flow.getFlowId();
            String status = flow.getFlowStatus();
            String gname = flow.getFlowGname();
            String flowCreatorNumber = flow.getFlowCreatorNumber();
            String flowCreatorName = flow.getFlowCreatorName();
            if (Lists.newArrayList((Object[])new PdFlowStatusEnum[]{PdFlowStatusEnum.UNSUBMIT, PdFlowStatusEnum.REJECTED}).stream().anyMatch(e -> e.getValue().equals(status))) {
                from = PdFlowFromEnum.ST;
                toUsers = Sets.newHashSet((Object[])new String[]{flowCreatorNumber});
                message = MessageFormat.format(this.component.getTemplate(PdNoticeContentEnum.FLOW_URGE2), gname);
            } else {
                from = PdFlowFromEnum.AP;
                toUsers = dtos.stream().map(PdFlowNoticeDTO::getHandlerNumber).collect(Collectors.toSet());
                message = MessageFormat.format(this.component.getTemplate(PdNoticeContentEnum.FLOW_URGE), flowCreatorName, gname);
            }
            String url = this.component.getUrl(from, flowId);
            this.component.notice(toUsers, message, url);
        }
        return list.stream().map(PdFlowNoticeDTO::getHandlerName).distinct().collect(Collectors.joining("\u3001"));
    }
}

